/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.grace;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeGraceNoteAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.util.TGContext;

public class TGGraceDialog
extends SelectionAdapter {
    private static final int LAYOUT_COLUMNS = 2;
    private Spinner fretSpinner;
    private Button deadButton;
    private Button beforeBeatButton;
    private Button onBeatButton;
    private Button durationButton1;
    private Button durationButton2;
    private Button durationButton3;
    private Button pppButton;
    private Button ppButton;
    private Button pButton;
    private Button mpButton;
    private Button mfButton;
    private Button fButton;
    private Button ffButton;
    private Button fffButton;
    private Button noneButton;
    private Button slideButton;
    private Button bendButton;
    private Button hammerButton;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            Shell parent = (Shell)context.getAttribute("parent");
            final Shell dialog = DialogUtils.newDialog(parent, 67680);
            dialog.setLayout((Layout)new GridLayout());
            dialog.setText(TuxGuitar.getProperty("effects.grace-editor"));
            dialog.setMinimumSize(360, 360);
            Composite composite = new Composite((Composite)dialog, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            int horizontalSpan = 2;
            boolean dead = false;
            boolean onBeat = false;
            int fret = note.getValue();
            int duration = 1;
            int dynamic = 95;
            int transition = 0;
            if (note.getEffect().isGrace()) {
                dead = note.getEffect().getGrace().isDead();
                fret = note.getEffect().getGrace().getFret();
                onBeat = note.getEffect().getGrace().isOnBeat();
                duration = note.getEffect().getGrace().getDuration();
                dynamic = note.getEffect().getGrace().getDynamic();
                transition = note.getEffect().getGrace().getTransition();
            }
            Group noteGroup = this.makeGroup(composite, horizontalSpan, TuxGuitar.getProperty("note"));
            noteGroup.setLayout((Layout)new GridLayout(2, false));
            Label fretLabel = new Label((Composite)noteGroup, 0);
            fretLabel.setText(TuxGuitar.getProperty("fret") + ": ");
            this.fretSpinner = new Spinner((Composite)noteGroup, 2048);
            this.fretSpinner.setLayoutData((Object)this.makeGridData(1));
            this.fretSpinner.setSelection(fret);
            this.deadButton = new Button((Composite)noteGroup, 32);
            this.deadButton.setText(TuxGuitar.getProperty("note.deadnote"));
            this.deadButton.setLayoutData((Object)this.makeGridData(2));
            this.deadButton.setSelection(dead);
            Group positionGroup = this.makeGroup(composite, horizontalSpan, TuxGuitar.getProperty("position"));
            positionGroup.setLayout((Layout)new GridLayout());
            this.beforeBeatButton = new Button((Composite)positionGroup, 16);
            this.beforeBeatButton.setText(TuxGuitar.getProperty("effects.grace.before-beat"));
            this.beforeBeatButton.setLayoutData((Object)this.makeGridData(1));
            this.beforeBeatButton.setSelection(!onBeat);
            this.onBeatButton = new Button((Composite)positionGroup, 16);
            this.onBeatButton.setText(TuxGuitar.getProperty("effects.grace.on-beat"));
            this.onBeatButton.setLayoutData((Object)this.makeGridData(1));
            this.onBeatButton.setSelection(onBeat);
            Group durationGroup = this.makeGroup(composite, horizontalSpan, TuxGuitar.getProperty("duration"));
            durationGroup.setLayout((Layout)new GridLayout(3, false));
            this.durationButton1 = new Button((Composite)durationGroup, 16);
            this.durationButton1.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
            this.durationButton1.setLayoutData((Object)this.makeGridData(1));
            this.durationButton1.setSelection(duration == 1);
            this.durationButton2 = new Button((Composite)durationGroup, 16);
            this.durationButton2.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
            this.durationButton2.setLayoutData((Object)this.makeGridData(1));
            this.durationButton2.setSelection(duration == 2);
            this.durationButton3 = new Button((Composite)durationGroup, 16);
            this.durationButton3.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
            this.durationButton3.setLayoutData((Object)this.makeGridData(1));
            this.durationButton3.setSelection(duration == 3);
            horizontalSpan = 1;
            Group dynamicGroup = this.makeGroup(composite, horizontalSpan, TuxGuitar.getProperty("dynamic"));
            dynamicGroup.setLayout((Layout)new GridLayout(2, false));
            this.pppButton = new Button((Composite)dynamicGroup, 16);
            this.pppButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicPPP());
            this.pppButton.setLayoutData((Object)this.makeGridData(1));
            this.pppButton.setSelection(dynamic == 15);
            this.mfButton = new Button((Composite)dynamicGroup, 16);
            this.mfButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicMF());
            this.mfButton.setLayoutData((Object)this.makeGridData(1));
            this.mfButton.setSelection(dynamic == 79);
            this.ppButton = new Button((Composite)dynamicGroup, 16);
            this.ppButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicPP());
            this.ppButton.setLayoutData((Object)this.makeGridData(1));
            this.ppButton.setSelection(dynamic == 31);
            this.fButton = new Button((Composite)dynamicGroup, 16);
            this.fButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicF());
            this.fButton.setLayoutData((Object)this.makeGridData(1));
            this.fButton.setSelection(dynamic == 95);
            this.pButton = new Button((Composite)dynamicGroup, 16);
            this.pButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicP());
            this.pButton.setLayoutData((Object)this.makeGridData(1));
            this.pButton.setSelection(dynamic == 47);
            this.ffButton = new Button((Composite)dynamicGroup, 16);
            this.ffButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicFF());
            this.ffButton.setLayoutData((Object)this.makeGridData(1));
            this.ffButton.setSelection(dynamic == 111);
            this.mpButton = new Button((Composite)dynamicGroup, 16);
            this.mpButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicMP());
            this.mpButton.setLayoutData((Object)this.makeGridData(1));
            this.mpButton.setSelection(dynamic == 63);
            this.fffButton = new Button((Composite)dynamicGroup, 16);
            this.fffButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicFFF());
            this.fffButton.setLayoutData((Object)this.makeGridData(1));
            this.fffButton.setSelection(dynamic == 127);
            Group transitionGroup = this.makeGroup(composite, horizontalSpan, TuxGuitar.getProperty("effects.grace.transition"));
            transitionGroup.setLayout((Layout)new GridLayout());
            this.noneButton = new Button((Composite)transitionGroup, 16);
            this.noneButton.setText(TuxGuitar.getProperty("effects.grace.transition-none"));
            this.noneButton.setLayoutData((Object)this.makeGridData(1));
            this.noneButton.setSelection(transition == 0);
            this.bendButton = new Button((Composite)transitionGroup, 16);
            this.bendButton.setText(TuxGuitar.getProperty("effects.grace.transition-bend"));
            this.bendButton.setLayoutData((Object)this.makeGridData(1));
            this.bendButton.setSelection(transition == 2);
            this.slideButton = new Button((Composite)transitionGroup, 16);
            this.slideButton.setText(TuxGuitar.getProperty("effects.grace.transition-slide"));
            this.slideButton.setLayoutData((Object)this.makeGridData(1));
            this.slideButton.setSelection(transition == 1);
            this.hammerButton = new Button((Composite)transitionGroup, 16);
            this.hammerButton.setText(TuxGuitar.getProperty("effects.grace.transition-hammer"));
            this.hammerButton.setLayoutData((Object)this.makeGridData(1));
            this.hammerButton.setSelection(transition == 3);
            Composite buttons = new Composite((Composite)dialog, 0);
            buttons.setLayout((Layout)new GridLayout(3, false));
            buttons.setLayoutData((Object)new GridData(0x1000008, 1024, true, true));
            Button buttonOK = new Button(buttons, 8);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData((Object)this.getButtonData());
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGGraceDialog.this.changeGrace(context.getContext(), measure, beat, string, TGGraceDialog.this.getGrace());
                    dialog.dispose();
                }
            });
            Button buttonClean = new Button(buttons, 8);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.setLayoutData((Object)this.getButtonData());
            buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGGraceDialog.this.changeGrace(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button(buttons, 8);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData((Object)this.getButtonData());
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.setDefaultButton(buttonOK);
            DialogUtils.openDialog(dialog, 10);
        }
    }

    private Group makeGroup(Composite parent, int horizontalSpan, String text) {
        Group group = new Group(parent, 16);
        group.setLayoutData((Object)this.makeGridData(horizontalSpan));
        group.setText(text);
        return group;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private GridData makeGridData(int horizontalSpan) {
        GridData data = new GridData(4, 4, true, true);
        data.horizontalSpan = horizontalSpan;
        return data;
    }

    public TGEffectGrace getGrace() {
        TGEffectGrace effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectGrace();
        effect.setFret(this.fretSpinner.getSelection());
        effect.setDead(this.deadButton.getSelection());
        effect.setOnBeat(this.onBeatButton.getSelection());
        if (this.durationButton1.getSelection()) {
            effect.setDuration(1);
        } else if (this.durationButton2.getSelection()) {
            effect.setDuration(2);
        } else if (this.durationButton3.getSelection()) {
            effect.setDuration(3);
        }
        if (this.pppButton.getSelection()) {
            effect.setDynamic(15);
        } else if (this.ppButton.getSelection()) {
            effect.setDynamic(31);
        } else if (this.pButton.getSelection()) {
            effect.setDynamic(47);
        } else if (this.mpButton.getSelection()) {
            effect.setDynamic(63);
        } else if (this.mfButton.getSelection()) {
            effect.setDynamic(79);
        } else if (this.fButton.getSelection()) {
            effect.setDynamic(95);
        } else if (this.ffButton.getSelection()) {
            effect.setDynamic(111);
        } else if (this.fffButton.getSelection()) {
            effect.setDynamic(127);
        }
        if (this.noneButton.getSelection()) {
            effect.setTransition(0);
        } else if (this.slideButton.getSelection()) {
            effect.setTransition(1);
        } else if (this.bendButton.getSelection()) {
            effect.setTransition(2);
        } else if (this.hammerButton.getSelection()) {
            effect.setTransition(3);
        }
        return effect;
    }

    public void changeGrace(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectGrace effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-grace");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeGraceNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

