/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.fretboard;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGFontImpl;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardConfig;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGFont;
import org.herac.tuxguitar.graphics.TGImage;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.util.TGContext;

public class TGFretBoard
extends Composite {
    public static final int MAX_FRETS = 24;
    public static final int TOP_SPACING = 10;
    public static final int BOTTOM_SPACING = 10;
    private static final int STRING_SPACING = TuxGuitar.getInstance().getConfig().getIntegerValue("fretboard.string-spacing");
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("fretboard");
    private TGContext context;
    private TGFretBoardConfig config;
    private Composite toolComposite;
    private Label durationLabel;
    private Label scaleName;
    private Button scale;
    private Button settings;
    private TGImage fretBoard;
    private TGBeat beat;
    private TGBeat externalBeat;
    private int[] frets;
    private int[] strings;
    private int fretSpacing;
    private boolean changes;
    private Point lastSize;
    private int duration;
    protected Combo handSelector;
    protected Composite fretBoardComposite;

    public TGFretBoard(TGContext context, Composite parent) {
        super(parent, 0);
        this.context = context;
        this.config = new TGFretBoardConfig();
        this.config.load();
        this.setLayout((Layout)new FormLayout());
        this.initToolBar();
        this.initEditor();
        this.loadIcons();
        this.loadProperties();
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.toolComposite);
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.fretBoardComposite);
    }

    private void initToolBar() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 0;
        layout.marginWidth = 0;
        this.toolComposite = new Composite((Composite)this, 0);
        ++layout.numColumns;
        Button goLeft = new Button(this.toolComposite, 16388);
        goLeft.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-left"));
        ++layout.numColumns;
        Button goRight = new Button(this.toolComposite, 131076);
        goRight.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-right"));
        ++layout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++layout.numColumns;
        Button decrement = new Button(this.toolComposite, 132);
        decrement.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.decrement-duration"));
        ++layout.numColumns;
        this.durationLabel = new Label(this.toolComposite, 2048);
        ++layout.numColumns;
        Button increment = new Button(this.toolComposite, 1028);
        increment.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.increment-duration"));
        ++layout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++layout.numColumns;
        this.handSelector = new Combo(this.toolComposite, 12);
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(this.getDirection(this.config.getDirection()));
        this.handSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGFretBoard.this.updateDirection(TGFretBoard.this.handSelector.getSelectionIndex());
            }
        });
        ++layout.numColumns;
        this.makeToolSeparator(this.toolComposite);
        ++layout.numColumns;
        this.scale = new Button(this.toolComposite, 8);
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.scale.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.gui.open-scale-dialog"));
        ++layout.numColumns;
        this.scaleName = new Label(this.toolComposite, 16384);
        ++layout.numColumns;
        this.settings = new Button(this.toolComposite, 8);
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.settings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGFretBoard.this.configure();
            }
        });
        this.toolComposite.setLayoutData((Object)data);
        this.toolComposite.setLayout((Layout)layout);
    }

    private void makeToolSeparator(Composite parent) {
        Label separator = new Label(parent, 2);
        separator.setLayoutData((Object)new GridData(20, 20));
    }

    private void initEditor() {
        this.lastSize = new Point(0, 0);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.toolComposite, 0);
        data.bottom = new FormAttachment(100, 0);
        this.fretBoardComposite = new Composite((Composite)this, 2048);
        this.fretBoardComposite.setLayoutData((Object)data);
        this.fretBoardComposite.setBackground(this.config.getColorBackground());
        this.fretBoardComposite.addMouseListener((MouseListener)new TGFretBoardMouseListener());
        this.fretBoardComposite.addPaintListener((PaintListener)new TGBufferedPainterListenerLocked(this.context, new TGFretBoardPainterListener()));
    }

    private void loadDurationImage(boolean force) {
        int duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (force || this.duration != duration) {
            this.duration = duration;
            this.durationLabel.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.duration));
        }
    }

    private void loadScaleName() {
        int scaleKey = TuxGuitar.getInstance().getScaleManager().getSelectionKey();
        int scaleIndex = TuxGuitar.getInstance().getScaleManager().getSelectionIndex();
        String key = TuxGuitar.getInstance().getScaleManager().getKeyName(scaleKey);
        String name = TuxGuitar.getInstance().getScaleManager().getScaleName(scaleIndex);
        this.scaleName.setText(key != null && name != null ? key + " - " + name : "");
        this.scaleName.pack();
    }

    private void calculateFretSpacing(int width) {
        this.fretSpacing = width / 24;
        int aux = 0;
        for (int i = 0; i < 24; ++i) {
            aux += i * 2;
        }
        this.fretSpacing += aux / 24 + 2;
    }

    private void disposeFretBoardImage() {
        if (this.fretBoard != null && !this.fretBoard.isDisposed()) {
            this.fretBoard.dispose();
        }
    }

    protected void initFrets(int fromX) {
        block3: {
            int direction;
            int nextX;
            block2: {
                this.frets = new int[24];
                nextX = fromX;
                direction = this.getDirection(this.config.getDirection());
                if (direction != 0) break block2;
                for (int i = 0; i < this.frets.length; ++i) {
                    this.frets[i] = nextX;
                    nextX += this.fretSpacing - (i + 1) * 2;
                }
                break block3;
            }
            if (direction != 1) break block3;
            for (int i = this.frets.length - 1; i >= 0; --i) {
                this.frets[i] = nextX;
                nextX += this.fretSpacing - i * 2;
            }
        }
    }

    private int getDirection(int value) {
        int direction = value;
        if (direction != 0 && direction != 1) {
            direction = 0;
        }
        return direction;
    }

    private void initStrings(int count) {
        int fromY = 10;
        this.strings = new int[count];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = fromY + STRING_SPACING * i;
        }
    }

    private void updateEditor() {
        if (this.isVisible()) {
            this.beat = TuxGuitar.getInstance().getPlayer().isRunning() ? TuxGuitar.getInstance().getEditorCache().getPlayBeat() : (this.externalBeat != null ? this.externalBeat : TuxGuitar.getInstance().getEditorCache().getEditBeat());
            if (this.strings.length != this.getStringCount()) {
                this.disposeFretBoardImage();
                this.initStrings(this.getStringCount());
                this.lastSize.y = 0;
            }
            int clientWidth = this.getClientArea().width;
            int clientHeight = this.getClientArea().height;
            if (this.lastSize.x != clientWidth || this.hasChanges()) {
                this.layout(this.getClientArea().width);
            }
            if (this.lastSize.y != clientHeight) {
                TuxGuitar.getInstance().getFretBoardEditor().showFretBoard();
            }
            this.lastSize.x = clientWidth;
            this.lastSize.y = clientHeight;
        }
    }

    private void paintFretBoard(TGPainter painter) {
        if (this.fretBoard == null || this.fretBoard.isDisposed()) {
            int i;
            Rectangle clientArea = this.getClientArea();
            this.fretBoard = new TGImageImpl((Device)this.getDisplay(), clientArea.width, STRING_SPACING * (this.strings.length - 1) + 10 + 10);
            TGPainter painterBuffer = this.fretBoard.createPainter();
            painterBuffer.setBackground((TGColor)new TGColorImpl(this.config.getColorBackground()));
            painterBuffer.initPath(2);
            painterBuffer.addRectangle((float)clientArea.x, (float)clientArea.y, (float)clientArea.width, (float)clientArea.height);
            painterBuffer.closePath();
            TGImageImpl fretImage = new TGImageImpl(TuxGuitar.getInstance().getIconManager().getFretboardFret());
            TGImageImpl firstFretImage = new TGImageImpl(TuxGuitar.getInstance().getIconManager().getFretboardFirstFret());
            painterBuffer.drawImage((TGImage)firstFretImage, 0.0f, 0.0f, firstFretImage.getWidth(), firstFretImage.getHeight(), (float)(this.frets[0] - 5), (float)(this.strings[0] - 5), firstFretImage.getWidth(), (float)this.strings[this.strings.length - 1]);
            this.paintFretPoints(painterBuffer, 0);
            for (i = 1; i < this.frets.length; ++i) {
                painterBuffer.drawImage((TGImage)fretImage, 0.0f, 0.0f, fretImage.getWidth(), fretImage.getHeight(), (float)this.frets[i], (float)(this.strings[0] - 5), fretImage.getWidth(), (float)this.strings[this.strings.length - 1]);
                this.paintFretPoints(painterBuffer, i);
            }
            for (i = 0; i < this.strings.length; ++i) {
                painterBuffer.setForeground((TGColor)new TGColorImpl(this.config.getColorString()));
                if (i > 2) {
                    painterBuffer.setLineWidth(2.0f);
                }
                painterBuffer.initPath();
                painterBuffer.setAntialias(false);
                painterBuffer.moveTo((float)this.frets[0], (float)this.strings[i]);
                painterBuffer.lineTo((float)this.frets[this.frets.length - 1], (float)this.strings[i]);
                painterBuffer.closePath();
            }
            this.paintScale(painterBuffer);
            painterBuffer.dispose();
        }
        painter.drawImage(this.fretBoard, 0.0f, 0.0f);
    }

    private void paintFretPoints(TGPainter painter, int fretIndex) {
        painter.setBackground((TGColor)new TGColorImpl(this.config.getColorFretPoint()));
        if (fretIndex + 1 < this.frets.length) {
            int fret = (fretIndex + 1) % 12;
            painter.setLineWidth(10.0f);
            if (fret == 0) {
                int size = this.getOvalSize();
                int x = this.frets[fretIndex] + (this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2;
                int y1 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 - STRING_SPACING;
                int y2 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 + STRING_SPACING;
                painter.initPath(2);
                painter.addOval((float)(x - size / 2), (float)(y1 - size / 2), (float)size, (float)size);
                painter.addOval((float)(x - size / 2), (float)(y2 - size / 2), (float)size, (float)size);
                painter.closePath();
            } else if (fret == 3 || fret == 5 || fret == 7 || fret == 9) {
                int size = this.getOvalSize();
                int x = this.frets[fretIndex] + (this.frets[fretIndex + 1] - this.frets[fretIndex]) / 2;
                int y = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2;
                painter.initPath(2);
                painter.addOval((float)(x - size / 2), (float)(y - size / 2), (float)size, (float)size);
                painter.closePath();
            }
            painter.setLineWidth(1.0f);
        }
    }

    private void paintScale(TGPainter painter) {
        TGTrack track = this.getTrack();
        for (int i = 0; i < this.strings.length; ++i) {
            TGString string = track.getString(i + 1);
            for (int j = 0; j < this.frets.length; ++j) {
                int noteIndex = (string.getValue() + j) % 12;
                if (!TuxGuitar.getInstance().getScaleManager().getScale().getNote(noteIndex)) continue;
                int x = this.frets[j];
                if (j > 0) {
                    x -= (x - this.frets[j - 1]) / 2;
                }
                int y = this.strings[i];
                if ((this.config.getStyle() & 2) != 0) {
                    this.paintKeyText(painter, this.config.getColorScale(), x, y, NOTE_NAMES[noteIndex]);
                    continue;
                }
                this.paintKeyOval(painter, this.config.getColorScale(), x, y);
            }
        }
        painter.setForeground((TGColor)new TGColorImpl(this.config.getColorBackground()));
    }

    private void paintNotes(TGPainter painter) {
        if (this.beat != null) {
            TGTrack track = this.getTrack();
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    int fretIndex = note.getValue();
                    int stringIndex = note.getString() - 1;
                    if (fretIndex < 0 || fretIndex >= this.frets.length || stringIndex < 0 || stringIndex >= this.strings.length) continue;
                    int x = this.frets[fretIndex];
                    if (fretIndex > 0) {
                        x -= (this.frets[fretIndex] - this.frets[fretIndex - 1]) / 2;
                    }
                    int y = this.strings[stringIndex];
                    if ((this.config.getStyle() & 1) != 0) {
                        int realValue = track.getString(note.getString()).getValue() + note.getValue();
                        this.paintKeyText(painter, this.config.getColorNote(), x, y, NOTE_NAMES[realValue % 12]);
                        continue;
                    }
                    this.paintKeyOval(painter, this.config.getColorNote(), x, y);
                }
            }
            painter.setLineWidth(1.0f);
        }
    }

    private void paintKeyOval(TGPainter painter, Color background, int x, int y) {
        int size = this.getOvalSize();
        painter.setBackground((TGColor)new TGColorImpl(background));
        painter.initPath(2);
        painter.moveTo((float)(x - size / 2), (float)(y - size / 2));
        painter.addOval((float)(x - size / 2), (float)(y - size / 2), (float)size, (float)size);
        painter.closePath();
    }

    private void paintKeyText(TGPainter painter, Color foreground, int x, int y, String text) {
        painter.setBackground((TGColor)new TGColorImpl(this.getDisplay().getSystemColor(1)));
        painter.setForeground((TGColor)new TGColorImpl(foreground));
        painter.setFont((TGFont)new TGFontImpl(this.config.getFont()));
        float fmWidth = painter.getFMWidth(text);
        float fmHeight = painter.getFMHeight();
        painter.initPath(2);
        painter.addRectangle((float)x - fmWidth / 2.0f, (float)y - fmHeight / 2.0f, fmWidth, fmHeight);
        painter.closePath();
        painter.drawString(text, (float)x - fmWidth / 2.0f, (float)y + painter.getFMMiddleLine(), true);
    }

    protected void paintEditor(TGPainter painter) {
        this.updateEditor();
        if (this.frets.length > 0 && this.strings.length > 0) {
            this.paintFretBoard(painter);
            this.paintNotes(painter);
        }
    }

    protected void hit(int x, int y) {
        int fretIndex = this.getFretIndex(x);
        int stringIndex = this.getStringIndex(y);
        int stringNumber = stringIndex + 1;
        this.selectString(stringNumber);
        if (!this.removeNote(fretIndex, stringNumber)) {
            this.addNote(fretIndex, stringNumber);
        }
    }

    private void selectString(int number) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.caret.move-to");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)this.getTrack().getString(number));
        tgActionProcessor.process();
    }

    private int getStringIndex(int y) {
        int index = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (index < 0) {
                index = i;
                continue;
            }
            int distanceY = Math.abs(y - this.strings[index]);
            int currDistanceY = Math.abs(y - this.strings[i]);
            if (currDistanceY >= distanceY) continue;
            index = i;
        }
        return index;
    }

    private int getFretIndex(int x) {
        int length = this.frets.length;
        if (x - 10 <= this.frets[0] && this.frets[0] < this.frets[length - 1]) {
            return 0;
        }
        if (x + 10 >= this.frets[0] && this.frets[0] > this.frets[length - 1]) {
            return 0;
        }
        for (int i = 0; i < length; ++i) {
            if (i + 1 >= length || (x <= this.frets[i] || x > this.frets[i + 1]) && (x <= this.frets[i + 1] || x > this.frets[i])) continue;
            return i + 1;
        }
        return length - 1;
    }

    private boolean removeNote(int fret, int string) {
        if (this.beat != null) {
            for (int v = 0; v < this.beat.countVoices(); ++v) {
                TGVoice voice = this.beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (note.getValue() != fret || note.getString() != string) continue;
                    TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.beat.general.delete-note");
                    tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
                    tgActionProcessor.process();
                    return true;
                }
            }
        }
        return false;
    }

    private TGTrack getTrack() {
        TGTrack track;
        TGMeasure measure;
        if (this.beat != null && (measure = this.beat.getMeasure()) != null && (track = measure.getTrack()) != null) {
            return track;
        }
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack();
    }

    private int getStringCount() {
        TGTrack track = this.getTrack();
        if (track != null) {
            return track.stringCount();
        }
        return 0;
    }

    private int getOvalSize() {
        return STRING_SPACING / 2 + STRING_SPACING / 10;
    }

    private void addNote(int fret, int string) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.note.general.change");
        tgActionProcessor.setAttribute("fret", (Object)fret);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)this.getTrack().getString(string));
        tgActionProcessor.process();
    }

    protected void updateDirection(int direction) {
        this.config.saveDirection(this.getDirection(direction));
        this.initFrets(10);
        this.setChanges(true);
        this.fretBoardComposite.redraw();
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    public void setExternalBeat(TGBeat externalBeat) {
        this.externalBeat = externalBeat;
    }

    public TGBeat getExternalBeat() {
        return this.externalBeat;
    }

    public void redraw() {
        if (!super.isDisposed()) {
            super.redraw();
            this.fretBoardComposite.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed()) {
            this.fretBoardComposite.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeFretBoardImage();
        this.config.dispose();
    }

    public void loadProperties() {
        int selection = this.handSelector.getSelectionIndex();
        this.handSelector.removeAll();
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(selection);
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.scale.setText(TuxGuitar.getProperty("scale"));
        this.loadScaleName();
        this.setChanges(true);
        this.layout(true, true);
    }

    public void loadIcons() {
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.loadDurationImage(true);
        this.layout(true, true);
        this.layout(this.getClientArea().width);
    }

    public void loadScale() {
        this.loadScaleName();
        this.setChanges(true);
    }

    public int getHeight() {
        int borderWidth = 2 * this.fretBoardComposite.getBorderWidth();
        int toolBarHeight = this.toolComposite.getBounds().height;
        int fretBoardHeight = STRING_SPACING * (this.strings.length - 1) + 10 + 10;
        return borderWidth + toolBarHeight + fretBoardHeight;
    }

    public int getWidth() {
        return this.frets[this.frets.length - 1];
    }

    public void layout() {
        super.layout();
    }

    public void layout(int width) {
        this.disposeFretBoardImage();
        this.calculateFretSpacing(width);
        this.initFrets(10);
        this.initStrings(this.getStringCount());
        this.setChanges(false);
    }

    protected void configure() {
        this.config.configure(this.getShell());
        this.handSelector.select(this.getDirection(this.config.getDirection()));
        this.setChanges(true);
        this.redraw();
    }

    public Composite getFretBoardComposite() {
        return this.fretBoardComposite;
    }

    private class TGFretBoardPainterListener
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        public void paintControl(TGPainter painter) {
            TGFretBoard.this.paintEditor(painter);
        }

        public Composite getPaintableControl() {
            return TGFretBoard.this.fretBoardComposite;
        }
    }

    private class TGFretBoardMouseListener
    implements MouseListener {
        public void mouseUp(MouseEvent e) {
            TGFretBoard.this.getFretBoardComposite().setFocus();
            if (e.button == 1) {
                if (!TuxGuitar.getInstance().getPlayer().isRunning() && !TGEditorManager.getInstance((TGContext)TGFretBoard.this.context).isLocked()) {
                    if (TGFretBoard.this.getExternalBeat() == null) {
                        TGFretBoard.this.hit(e.x, e.y);
                    } else {
                        TGFretBoard.this.setExternalBeat(null);
                        TuxGuitar.getInstance().updateCache(true);
                    }
                }
            } else {
                new TGActionProcessor(TGFretBoard.this.context, "action.caret.go-right").process();
            }
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

