/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGChordEditor
extends Composite {
    public static final int STRING_SPACING = 30;
    public static final int FRET_SPACING = 30;
    public static final short MIN_FRET = 1;
    public static final short MAX_FRET = 24;
    private TGChordDialog dialog;
    private Composite composite;
    private Text chordName;
    private List<Point> points;
    private boolean[] firstFrets;
    private int[] strings;
    private int[] frets;
    private short fret;
    private short maxStrings;
    private int width;
    private int height;
    private TGTrack currentTrack;

    public TGChordEditor(Composite parent, int style) {
        super(parent, style);
    }

    public TGChordEditor(TGChordDialog dialog, Composite parent, int style, short maxStrings) {
        this(parent, style);
        this.dialog = dialog;
        this.setLayout((Layout)dialog.gridLayout(1, false, 0, 0));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.init(maxStrings);
    }

    public void init(short maxStrings) {
        int i;
        this.fret = 1;
        this.maxStrings = maxStrings;
        this.firstFrets = new boolean[this.maxStrings];
        this.strings = new int[this.maxStrings];
        this.frets = new int[6];
        this.width = 30 * this.maxStrings - 30;
        this.height = 150;
        this.points = new ArrayList<Point>();
        for (i = 0; i < this.firstFrets.length; ++i) {
            this.firstFrets[i] = false;
        }
        for (i = 0; i < this.strings.length; ++i) {
            this.strings[i] = (i + 1) * 30;
        }
        for (i = 0; i < this.frets.length; ++i) {
            this.frets[i] = (i + 1) * 30;
        }
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = new Composite(composite, 0x20000A00);
        Composite nameComposite = new Composite(composite, 0);
        nameComposite.setLayout((Layout)this.dialog.gridLayout(1, true, 0, 0));
        nameComposite.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label formulaLabel = new Label(nameComposite, 258);
        formulaLabel.setLayoutData((Object)new GridData(4, 1024, true, true));
        Label chordNameLabel = new Label(nameComposite, 16384);
        chordNameLabel.setText(TuxGuitar.getProperty("chord.name"));
        chordNameLabel.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.chordName = new Text(nameComposite, 2052);
        this.chordName.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TGPainterImpl painter = new TGPainterImpl(e.gc);
                TGChordEditor.this.paintEditor(painter);
            }
        });
        this.composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TGChordEditor.this.getComposite().setFocus();
                TGChordEditor.this.checkPoint(e.x, e.y);
                TGChordEditor.this.redraw();
            }
        });
        this.composite.getVerticalBar().setIncrement(1);
        this.composite.getVerticalBar().setMaximum(21);
        this.composite.getVerticalBar().setMinimum(1);
        this.composite.getVerticalBar().setThumb(1);
        this.composite.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChordEditor.this.setFret((short)TGChordEditor.this.getComposite().getVerticalBar().getSelection(), false, true);
                TGChordEditor.this.redraw();
            }
        });
        this.composite.setLayoutData((Object)this.makeCompositeData());
    }

    private GridData makeCompositeData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = this.getWidth() + 60 + this.composite.getVerticalBar().getSize().x;
        data.minimumHeight = this.getHeight() + 60;
        return data;
    }

    protected void paintEditor(TGPainterImpl painter) {
        int i;
        int noteSize = 15;
        painter.setForeground(new TGColorImpl(this.getDisplay().getSystemColor(2)));
        painter.initPath();
        painter.setAntialias(false);
        painter.moveTo(20.0f, 20.0f);
        painter.lineTo(30 + (this.width + 10), 20.0f);
        painter.closePath();
        painter.drawString(Integer.toString(this.getFret()), 5.0f, 30.0f);
        painter.initPath();
        painter.setAntialias(false);
        for (i = 0; i < this.strings.length; ++i) {
            painter.moveTo(this.strings[i], 30.0f);
            painter.lineTo(this.strings[i], 30 + this.height);
        }
        painter.closePath();
        painter.initPath();
        painter.setAntialias(false);
        for (i = 0; i < this.frets.length; ++i) {
            painter.moveTo(30.0f, this.frets[i]);
            painter.lineTo(30 + this.width, this.frets[i]);
        }
        painter.closePath();
        painter.setBackground(new TGColorImpl(this.getDisplay().getSystemColor(2)));
        for (Point point : this.points) {
            painter.initPath(2);
            painter.addOval(point.x - noteSize / 2, point.y + noteSize / 2, noteSize, noteSize);
            painter.closePath();
        }
        for (int i2 = 0; i2 < this.firstFrets.length; ++i2) {
            int y;
            int x;
            if (this.hasPoints(i2)) continue;
            painter.initPath();
            if (this.firstFrets[i2]) {
                x = this.strings[i2] - noteSize / 2;
                y = 30 - noteSize - 11;
                painter.addOval(x, y, noteSize - 1, noteSize - 1);
            } else {
                x = this.strings[i2];
                y = 30 - noteSize - 4;
                painter.moveTo(x - (noteSize / 2 - 1), y + (noteSize / 2 - 1));
                painter.lineTo(x + (noteSize / 2 - 1), y - (noteSize / 2 - 1));
                painter.moveTo(x - (noteSize / 2 - 1), y - (noteSize / 2 - 1));
                painter.lineTo(x + (noteSize / 2 - 1), y + (noteSize / 2 - 1));
            }
            painter.closePath();
        }
    }

    protected void checkPoint(int x, int y) {
        int stringIndex = this.getStringIndex(x);
        int fretIndex = this.getFretIndex(y);
        if (y < 30) {
            this.firstFrets[stringIndex] = !this.firstFrets[stringIndex];
            this.removePointsAtStringLine(this.strings[stringIndex]);
        } else if (y < 180) {
            Point point = new Point(this.strings[stringIndex], this.frets[fretIndex]);
            if (!this.removePoint(point)) {
                this.firstFrets[stringIndex] = false;
                this.removePointsAtStringLine(this.strings[stringIndex]);
                this.addPoint(point);
                this.orderPoints();
            }
        } else {
            return;
        }
        this.dialog.getRecognizer().recognize(this.getChord(), true, false);
    }

    private boolean removePoint(Point point) {
        for (Point currPoint : this.points) {
            if (currPoint.x != point.x || currPoint.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point minPoint = null;
            for (int noteIdx = i; noteIdx < this.points.size(); ++noteIdx) {
                Point point = this.points.get(noteIdx);
                if (minPoint != null && point.x >= minPoint.x) continue;
                minPoint = point;
            }
            this.points.remove(minPoint);
            this.points.add(i, minPoint);
        }
    }

    private void removePointsAtStringLine(int x) {
        for (Point point : this.points) {
            if (point.x != x) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getStringIndex(int x) {
        int index = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (index < 0) {
                index = i;
                continue;
            }
            int distanceX = Math.abs(x - this.strings[index]);
            int currDistanceX = Math.abs(x - this.strings[i]);
            if (currDistanceX >= distanceX) continue;
            index = i;
        }
        return index;
    }

    private int getFretIndex(int y) {
        int index = -1;
        for (int i = 0; i < this.frets.length; ++i) {
            if (index < 0) {
                index = i;
                continue;
            }
            int distanceX = Math.abs(y - (this.frets[index] + 15));
            int currDistanceX = Math.abs(y - (this.frets[i] + 15));
            if (currDistanceX >= distanceX) continue;
            index = i;
        }
        return index;
    }

    private boolean hasPoints(int stringIndex) {
        for (Point point : this.points) {
            if (point.x != this.strings[stringIndex]) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public int getValue(int string) {
        int value = -1;
        if (this.firstFrets[this.maxStrings - string]) {
            value = 0;
        }
        if (value < 0) {
            for (Point point : this.points) {
                if (string != this.maxStrings - this.getStringIndex(point.x)) continue;
                value = this.getFretIndex(point.y + 15) + 1;
                value += this.getFret() - 1;
            }
        }
        return value;
    }

    public void addValue(int value, int string) {
        int realValue = value;
        if (string >= 1 && string <= this.maxStrings) {
            this.firstFrets[this.maxStrings - string] = false;
            this.removePointsAtStringLine(this.strings[this.maxStrings - string]);
            if (realValue == 0) {
                this.firstFrets[this.maxStrings - string] = true;
            } else if (realValue >= 0 && (realValue -= this.getFret() - 1) > 0 && realValue <= 6) {
                this.addPoint(new Point(this.strings[this.maxStrings - string], this.frets[realValue - 1]));
            }
        }
    }

    public short getFret() {
        return this.fret;
    }

    public void setFret(short fret) {
        this.setFret(fret, true, false);
    }

    protected void setFret(short fret, boolean updateScroll, boolean recognize) {
        if (fret >= 1 && fret <= 24) {
            this.fret = fret;
        }
        if (updateScroll) {
            this.composite.getVerticalBar().setSelection((int)this.fret);
        }
        if (recognize) {
            this.dialog.getRecognizer().recognize(this.getChord(), true, false);
        }
    }

    public TGChord getChord() {
        TGChord chord = TuxGuitar.getInstance().getSongManager().getFactory().newChord(this.strings.length);
        chord.setName(this.chordName.getText());
        chord.setFirstFret((int)this.fret);
        for (int i = 0; i < chord.getStrings().length; ++i) {
            chord.addFretValue(i, this.getValue(i + 1));
        }
        return chord;
    }

    public void setChord(TGChord chord) {
        if (chord != null) {
            this.setFret((short)chord.getFirstFret());
            for (int i = 0; i < chord.getStrings().length; ++i) {
                int fretValue = chord.getFretValue(i);
                this.addValue(fretValue, i + 1);
            }
            String name = chord.getName();
            this.dialog.getRecognizer().recognize(this.getChord(), name == null, name == null);
            this.previewChord(chord);
            if (name != null) {
                this.setChordName(name);
            }
            this.redraw();
        }
    }

    public short getMaxStrings() {
        return this.maxStrings;
    }

    public void setMaxStrings(short maxStrings) {
        this.maxStrings = maxStrings;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    public Text getChordName() {
        return this.chordName;
    }

    public void setChordName(String chordName) {
        this.chordName.setText(chordName);
    }

    public void redraw() {
        super.redraw();
        this.composite.redraw();
    }

    public void setCurrentTrack(TGTrack track) {
        this.currentTrack = track;
    }

    public TGTrack getCurrentTrack() {
        return this.currentTrack;
    }

    public void previewChord(final TGChord chord) {
        new Thread(new Runnable(){

            public void run() {
                int playedStrings = 0;
                int stringCount = Math.min(TGChordEditor.this.getMaxStrings(), chord.countStrings());
                for (int i = 0; i < stringCount; ++i) {
                    if (chord.getFretValue(i) == -1) continue;
                    ++playedStrings;
                }
                int next = 0;
                int[][] beat = new int[playedStrings][2];
                for (int i = 0; i < stringCount; ++i) {
                    int string = stringCount - i;
                    int value = chord.getFretValue(string - 1);
                    if (value == -1) continue;
                    beat[next][0] = TGChordEditor.this.getCurrentTrack().getOffset() + TGChordEditor.this.getCurrentTrack().getString(string).getValue() + value;
                    beat[next][1] = 95;
                    ++next;
                }
                TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
                TGChannel channel = TuxGuitar.getInstance().getSongManager().getChannel(song, TGChordEditor.this.getCurrentTrack().getChannelId());
                if (channel != null) {
                    TuxGuitar.getInstance().getPlayer().playBeat(channel.getChannelId(), (int)channel.getBank(), (int)channel.getProgram(), (int)channel.getVolume(), (int)channel.getBalance(), (int)channel.getChorus(), (int)channel.getReverb(), (int)channel.getPhaser(), (int)channel.getTremolo(), beat, 200L, 200);
                }
            }
        }).start();
    }
}

