/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelItem;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import org.herac.tuxguitar.song.models.TGChannel;

public class TGChannelList {
    private List<TGChannelItem> channelItems;
    private TGChannelManagerDialog dialog;
    protected ScrolledComposite channelItemAreaSC;
    protected Composite channelItemArea;

    public TGChannelList(TGChannelManagerDialog dialog) {
        this.dialog = dialog;
        this.channelItems = new ArrayList<TGChannelItem>();
    }

    public void show(Composite parent) {
        this.channelItemAreaSC = new ScrolledComposite(parent, 512);
        this.channelItemAreaSC.setLayoutData((Object)new GridData(4, 4, true, true));
        this.channelItemAreaSC.setExpandHorizontal(true);
        this.channelItemAreaSC.setExpandVertical(true);
        this.channelItemArea = new Composite((Composite)this.channelItemAreaSC, 0);
        this.channelItemArea.setLayout((Layout)this.dialog.createGridLayout(1, false, true, false));
        this.channelItemArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.channelItemAreaSC.setContent((Control)this.channelItemArea);
    }

    public void removeChannelsAfter(int count) {
        while (!this.channelItems.isEmpty() && this.channelItems.size() > count) {
            TGChannelItem tgChannelItem = this.channelItems.get(0);
            tgChannelItem.dispose();
            this.channelItemAreaSC.setMinSize(this.channelItemArea.computeSize(-1, -1));
            this.channelItemArea.layout(true, true);
            this.channelItems.remove(tgChannelItem);
        }
    }

    public TGChannelItem getOrCreateChannelItemAt(int index) {
        while (this.channelItems.size() <= index) {
            TGChannelItem tgChannelItem = new TGChannelItem(this.dialog);
            tgChannelItem.show(this.channelItemArea, new GridData(4, 128, true, false));
            this.channelItemAreaSC.setMinSize(this.channelItemArea.computeSize(-1, -1));
            this.channelItemArea.layout(true, true);
            this.channelItems.add(tgChannelItem);
        }
        return this.channelItems.get(index);
    }

    public void loadProperties() {
        for (TGChannelItem tgChannelItem : this.channelItems) {
            tgChannelItem.loadProperties();
        }
    }

    public void loadIcons() {
        for (TGChannelItem tgChannelItem : this.channelItems) {
            tgChannelItem.loadIcons();
        }
    }

    public void updateItems() {
        List<TGChannel> channels = this.dialog.getHandle().getChannels();
        this.removeChannelsAfter(channels.size());
        for (int i = 0; i < channels.size(); ++i) {
            TGChannel channel = channels.get(i);
            TGChannelItem tgChannelItem = this.getOrCreateChannelItemAt(i);
            tgChannelItem.setChannel(channel);
            tgChannelItem.updateItems();
        }
    }
}

