/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.browser.main;

import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserData;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactory;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;

public abstract class TGBrowserBar
implements TGEventListener {
    private TGBrowserDialog browser;

    public TGBrowserBar(TGBrowserDialog browser) {
        this.browser = browser;
    }

    public abstract void init(Shell var1);

    public abstract void updateItems();

    public abstract void updateCollections(TGBrowserCollection var1);

    public abstract void loadProperties();

    protected TGBrowserDialog getBrowser() {
        return this.browser;
    }

    protected void newCollection(String type) {
        TGBrowserData data;
        TGBrowserFactory factory = TGBrowserManager.getInstance(this.getBrowser().getContext()).getFactory(type);
        if (factory != null && (data = factory.dataDialog(this.getBrowser().getShell())) != null) {
            this.openCollection(this.addCollection(factory, data, true));
        }
    }

    protected TGBrowserCollection addCollection(TGBrowserFactory factory, String data) {
        return this.addCollection(factory, factory.parseData(data), false);
    }

    protected TGBrowserCollection addCollection(TGBrowserFactory factory, TGBrowserData data, boolean reload) {
        TGBrowserCollection collection = new TGBrowserCollection();
        collection.setType(factory.getType());
        collection.setData(data);
        collection = TGBrowserManager.getInstance(this.getBrowser().getContext()).addCollection(collection);
        if (reload) {
            this.getBrowser().updateCollections(collection);
        }
        return collection;
    }

    protected void openCollection(TGBrowserCollection collection) {
        this.getBrowser().setCollection(collection);
        this.getBrowser().openCollection();
    }

    protected void removeCollection(TGBrowserCollection collection) {
        this.getBrowser().removeCollection(collection);
    }

    protected void closeCollection() {
        this.getBrowser().closeCollection();
    }

    public void processEvent(TGEvent event) {
        if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

