/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.beat;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGBeatMoveDialog {
    private static final ComboItem[] MOVE_DIRECTIONS = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.direction.right"), new Integer(1)), new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.direction.left"), new Integer(-1))};
    private static final ComboItem[] MOVE_DURATIONS = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("duration.whole"), new Integer(1)), new ComboItem(TuxGuitar.getProperty("duration.half"), new Integer(2)), new ComboItem(TuxGuitar.getProperty("duration.quarter"), new Integer(4)), new ComboItem(TuxGuitar.getProperty("duration.eighth"), new Integer(8)), new ComboItem(TuxGuitar.getProperty("duration.sixteenth"), new Integer(16)), new ComboItem(TuxGuitar.getProperty("duration.thirtysecond"), new Integer(32)), new ComboItem(TuxGuitar.getProperty("duration.sixtyfourth"), new Integer(64))};
    private static final ComboItem[] MOVE_DURATION_TYPES = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.duration.type.normal"), new boolean[]{false, false}), new ComboItem(TuxGuitar.getProperty("duration.dotted"), new boolean[]{true, false}), new ComboItem(TuxGuitar.getProperty("duration.doubledotted"), new boolean[]{false, true})};
    private static final ComboItem[] MOVE_DURATION_DIVISIONS = TGBeatMoveDialog.createDivisionTypeComboItems();

    public void show(final TGViewContext context) {
        final TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("beat.move-custom.dialog.title"));
        Group direction = new Group((Composite)dialog, 16);
        direction.setLayout((Layout)new GridLayout(2, false));
        direction.setLayoutData((Object)new GridData(4, 4, true, true));
        direction.setText(TuxGuitar.getProperty("beat.move-custom.dialog.direction-tip"));
        Label directionLabel = new Label((Composite)direction, 131072);
        directionLabel.setText(TuxGuitar.getProperty("beat.move-custom.dialog.direction") + ":");
        final Combo directionCombo = new Combo((Composite)direction, 12);
        for (int i = 0; i < MOVE_DIRECTIONS.length; ++i) {
            directionCombo.add(MOVE_DIRECTIONS[i].getLabel());
        }
        directionCombo.select(0);
        directionCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        final ArrayList<Control> move1Controls = new ArrayList<Control>();
        Group move1 = new Group((Composite)dialog, 16);
        move1.setLayout((Layout)new GridLayout(2, false));
        move1.setLayoutData((Object)new GridData(4, 4, true, true));
        move1.setText(TuxGuitar.getProperty("beat.move-custom.dialog.move-1.tip"));
        Label count1Label = new Label((Composite)move1, 131072);
        count1Label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        count1Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.count") + ":");
        final Spinner count1Spinner = new Spinner((Composite)move1, 2048);
        count1Spinner.setLayoutData((Object)new GridData(4, 4, true, true));
        count1Spinner.setMinimum(0);
        count1Spinner.setMaximum(100);
        count1Spinner.setIncrement(1);
        count1Spinner.setSelection(0);
        count1Spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBeatMoveDialog.this.updateControls(count1Spinner.getSelection(), move1Controls);
            }
        });
        Label duration1Label = new Label((Composite)move1, 131072);
        duration1Label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        duration1Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration") + ":");
        move1Controls.add((Control)duration1Label);
        final Combo duration1Combo = new Combo((Composite)move1, 12);
        duration1Combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATIONS.length; ++i) {
            duration1Combo.add(MOVE_DURATIONS[i].getLabel());
        }
        duration1Combo.select(0);
        move1Controls.add((Control)duration1Combo);
        this.updateControls(0, move1Controls);
        final ArrayList<Control> move2Controls = new ArrayList<Control>();
        Group move2 = new Group((Composite)dialog, 16);
        move2.setLayout((Layout)new GridLayout(2, false));
        move2.setLayoutData((Object)new GridData(4, 4, true, true));
        move2.setText(TuxGuitar.getProperty("beat.move-custom.dialog.move-2.tip"));
        Label count2Label = new Label((Composite)move2, 131072);
        count2Label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        count2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.count") + ":");
        final Spinner count2Spinner = new Spinner((Composite)move2, 2048);
        count2Spinner.setLayoutData((Object)new GridData(4, 4, true, true));
        count2Spinner.setSelection(0);
        count2Spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGBeatMoveDialog.this.updateControls(count2Spinner.getSelection(), move2Controls);
            }
        });
        Label duration2Label = new Label((Composite)move2, 131072);
        duration2Label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        duration2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration") + ":");
        move2Controls.add((Control)duration2Label);
        final Combo duration2Combo = new Combo((Composite)move2, 12);
        duration2Combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATIONS.length; ++i) {
            duration2Combo.add(MOVE_DURATIONS[i].getLabel());
        }
        duration2Combo.select(2);
        move2Controls.add((Control)duration2Combo);
        Label type2Label = new Label((Composite)move2, 131072);
        type2Label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        type2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration.type") + ":");
        move2Controls.add((Control)type2Label);
        final Combo type2Combo = new Combo((Composite)move2, 12);
        type2Combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATION_TYPES.length; ++i) {
            type2Combo.add(MOVE_DURATION_TYPES[i].getLabel());
        }
        type2Combo.select(0);
        move2Controls.add((Control)type2Combo);
        Label division2Label = new Label((Composite)move2, 131072);
        division2Label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        division2Label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration.division-type") + ":");
        move2Controls.add((Control)division2Label);
        final Combo division2Combo = new Combo((Composite)move2, 12);
        division2Combo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATION_DIVISIONS.length; ++i) {
            division2Combo.add(MOVE_DURATION_DIVISIONS[i].getLabel());
        }
        division2Combo.select(0);
        move2Controls.add((Control)division2Combo);
        this.updateControls(0, move2Controls);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int directionValue = TGBeatMoveDialog.this.getDirection(directionCombo.getSelectionIndex());
                long duration1 = TGBeatMoveDialog.this.getDuration1(duration1Combo.getSelectionIndex(), count1Spinner.getSelection());
                long duration2 = TGBeatMoveDialog.this.getDuration2(duration2Combo.getSelectionIndex(), type2Combo.getSelectionIndex(), division2Combo.getSelectionIndex(), count2Spinner.getSelection());
                long duration = (duration1 + duration2) * (long)directionValue;
                dialog.dispose();
                TGBeatMoveDialog.this.moveBeats(context.getContext(), track, measure, beat, duration);
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    protected GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected int getDirection(int index) {
        if (index >= 0 && index < MOVE_DIRECTIONS.length) {
            return (Integer)MOVE_DIRECTIONS[index].getValue();
        }
        return 0;
    }

    protected long getDuration1(int index, int count) {
        if (count > 0 && index >= 0 && index < MOVE_DURATIONS.length) {
            TGDuration duration = new TGFactory().newDuration();
            duration.setValue(((Integer)MOVE_DURATIONS[index].getValue()).intValue());
            duration.setDotted(false);
            duration.setDoubleDotted(false);
            duration.getDivision().setTimes(1);
            duration.getDivision().setEnters(1);
            return duration.getTime() * (long)count;
        }
        return 0L;
    }

    protected long getDuration2(int index, int indexType, int indexDivision, int count) {
        if (count > 0 && index >= 0 && index < MOVE_DURATIONS.length && indexType >= 0 && indexType < MOVE_DURATION_TYPES.length && indexDivision >= 0 && indexDivision < MOVE_DURATION_DIVISIONS.length) {
            TGDuration duration = new TGFactory().newDuration();
            duration.setValue(((Integer)MOVE_DURATIONS[index].getValue()).intValue());
            duration.setDotted(((boolean[])MOVE_DURATION_TYPES[indexType].getValue())[0]);
            duration.setDoubleDotted(((boolean[])MOVE_DURATION_TYPES[indexType].getValue())[1]);
            duration.getDivision().setEnters(((int[])MOVE_DURATION_DIVISIONS[indexDivision].getValue())[0]);
            duration.getDivision().setTimes(((int[])MOVE_DURATION_DIVISIONS[indexDivision].getValue())[1]);
            return duration.getTime() * (long)count;
        }
        return 0L;
    }

    protected void updateControls(int count, List<Control> controls) {
        for (Control control : controls) {
            control.setEnabled(count > 0);
        }
    }

    public void moveBeats(TGContext context, TGTrack track, TGMeasure measure, TGBeat beat, Long theMove) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.beat.general.move");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute("move", (Object)theMove);
        tgActionProcessor.process();
    }

    private static ComboItem[] createDivisionTypeComboItems() {
        TGDivisionType[] types = TGDivisionType.ALTERED_DIVISION_TYPES;
        ComboItem[] comboItems = new ComboItem[types.length + 1];
        comboItems[0] = new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.duration.division-type.normal"), new int[]{1, 1});
        for (int i = 0; i < types.length; ++i) {
            comboItems[i + 1] = new ComboItem(new Integer(types[i].getEnters()).toString(), new int[]{types[i].getEnters(), types[i].getTimes()});
        }
        return comboItems;
    }

    protected static class ComboItem {
        private String label;
        private Object value;

        public ComboItem(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

