/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.table.TGTable;

public class TGTableColumn {
    private TGTable table;
    private CLabel column;
    private List<Control> controls;

    public TGTableColumn(TGTable table, int align) {
        this.table = table;
        this.controls = new ArrayList<Control>();
        this.column = new CLabel(this.table.getColumnControl(), align | 8);
        this.column.setLayout((Layout)new GridLayout());
        this.column.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                TGTableColumn.this.layout();
            }
        });
        this.column.pack();
        this.appendListeners((Control)this.column);
    }

    public CLabel getControl() {
        return this.column;
    }

    public void setTitle(String title) {
        this.column.setText(title);
    }

    public void addControl(Control control) {
        this.controls.add(control);
        this.appendListeners(control);
    }

    public void appendListeners(Control control) {
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo(control);
    }

    public void layout() {
        Point location = this.column.getLocation();
        Point size = this.column.getSize();
        for (int i = 0; i < this.controls.size(); ++i) {
            Control control = this.controls.get(i);
            if (control.isDisposed()) continue;
            control.setSize(size.x, this.table.getRowHeight());
            control.setLocation(location.x, 0);
        }
    }

    public void notifyRemoved() {
        for (int i = 0; i < this.controls.size(); ++i) {
            Control control = this.controls.get(i);
            if (!control.isDisposed()) continue;
            this.controls.remove(i--);
        }
    }
}

