/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.song.models.TGTrack;

public class TGTableCanvasPainter {
    private TGTableViewer viewer;
    private TGTrack track;

    public TGTableCanvasPainter(TGTableViewer viewer, TGTrack track) {
        this.viewer = viewer;
        this.track = track;
    }

    protected void paintTrack(TGTableRow row, TGPainter painter) {
        int x = -this.viewer.getHScrollSelection();
        int y = 0;
        int size = this.viewer.getTable().getRowHeight();
        int width = row.getPainter().getBounds().width;
        boolean playing = TuxGuitar.getInstance().getPlayer().isRunning();
        painter.setBackground((TGColor)new TGColorImpl(row.getPainter().getDisplay().getSystemColor(15)));
        painter.initPath(2);
        painter.setAntialias(false);
        painter.addRectangle(0.0f, (float)y, (float)width, (float)size);
        painter.closePath();
        TGColor trackColor = painter.createColor(this.track.getColor().getR(), this.track.getColor().getG(), this.track.getColor().getB());
        painter.setBackground(trackColor);
        painter.setForeground(trackColor);
        int count = this.track.countMeasures();
        for (int j = 0; j < count; ++j) {
            TGMeasureImpl measure = (TGMeasureImpl)this.track.getMeasure(j);
            if (this.isRestMeasure(measure)) {
                painter.initPath();
                painter.setAntialias(false);
                painter.addRectangle((float)x, (float)y, (float)(size - 2), (float)(size - 1));
                painter.closePath();
            } else {
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRectangle((float)x, (float)y, (float)(size - 1), (float)size);
                painter.closePath();
            }
            boolean hasCaret = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure().equals(measure);
            if (playing && measure.isPlaying(this.viewer.getEditor().getTablature().getViewLayout()) || !playing && hasCaret) {
                painter.setBackground((TGColor)new TGColorImpl(row.getPainter().getDisplay().getSystemColor(2)));
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRectangle((float)(x + 4), (float)(y + 4), (float)(size - 9), (float)(size - 8));
                painter.closePath();
                painter.setBackground(trackColor);
            }
            x += size;
        }
        trackColor.dispose();
    }

    private boolean isRestMeasure(TGMeasureImpl measure) {
        int beatCount = measure.countBeats();
        for (int i = 0; i < beatCount; ++i) {
            if (measure.getBeat(i).isRestBeat()) continue;
            return false;
        }
        return true;
    }
}

