/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.keybindings.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBindingWriter {
    private static final String SHORTCUT_ROOT = "shortcuts";
    private static final String SHORTCUT_TAG = "shortcut";
    private static final String SHORTCUT_ATTRIBUTE_ACTION = "action";
    private static final String SHORTCUT_ATTRIBUTE_KEY = "key";
    private static final String SHORTCUT_ATTRIBUTE_MASK = "mask";

    public static void setBindings(List<KeyBindingAction> list, String fileName) {
        try {
            File file = new File(fileName);
            Document doc = KeyBindingWriter.createDocument();
            KeyBindingWriter.setBindings(list, doc);
            KeyBindingWriter.saveDocument(doc, file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return document;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fs = new FileOutputStream(file);
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            Transformer idTransform = xformFactory.newTransformer();
            DOMSource input = new DOMSource(document);
            StreamResult output = new StreamResult(fs);
            idTransform.setOutputProperty("indent", "yes");
            idTransform.transform(input, output);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void setBindings(List<KeyBindingAction> list, Document document) {
        Element shortcutsNode = document.createElement(SHORTCUT_ROOT);
        for (KeyBindingAction keyBindingAction : list) {
            Element node = document.createElement(SHORTCUT_TAG);
            shortcutsNode.appendChild(node);
            Attr attrKey = document.createAttribute(SHORTCUT_ATTRIBUTE_KEY);
            Attr attrMask = document.createAttribute(SHORTCUT_ATTRIBUTE_MASK);
            Attr attrAction = document.createAttribute(SHORTCUT_ATTRIBUTE_ACTION);
            attrKey.setNodeValue(Integer.toString(keyBindingAction.getKeyBinding().getKey()));
            attrMask.setNodeValue(Integer.toString(keyBindingAction.getKeyBinding().getMask()));
            attrAction.setNodeValue(keyBindingAction.getAction());
            node.getAttributes().setNamedItem(attrKey);
            node.getAttributes().setNamedItem(attrMask);
            node.getAttributes().setNamedItem(attrAction);
        }
        document.appendChild(shortcutsNode);
    }
}

