/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.icons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconEvent;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGIconManager {
    private TGContext context;
    private String theme;
    private List<Resource> disposableIcons;
    private Image[] durations;
    private Image editUndo;
    private Image editRedo;
    private Image editVoice1;
    private Image editVoice2;
    private Image editModeSelection;
    private Image editModeEdition;
    private Image editModeEditionNotNatural;
    private Image layoutPage;
    private Image layoutLinear;
    private Image layoutMultitrack;
    private Image layoutScore;
    private Image layoutCompact;
    private Image transport;
    private Image transportFirst1;
    private Image transportFirst2;
    private Image transportLast1;
    private Image transportLast2;
    private Image transportPrevious1;
    private Image transportPrevious2;
    private Image transportNext1;
    private Image transportNext2;
    private Image transportStop1;
    private Image transportStop2;
    private Image transportPlay1;
    private Image transportPlay2;
    private Image transportPause;
    private Image transportIconFirst1;
    private Image transportIconFirst2;
    private Image transportIconLast1;
    private Image transportIconLast2;
    private Image transportIconPrevious1;
    private Image transportIconPrevious2;
    private Image transportIconNext1;
    private Image transportIconNext2;
    private Image transportIconStop1;
    private Image transportIconStop2;
    private Image transportIconPlay1;
    private Image transportIconPlay2;
    private Image transportIconPause;
    private Image transportMetronome;
    private Image transportMode;
    private Image markerList;
    private Image markerAdd;
    private Image markerRemove;
    private Image markerFirst;
    private Image markerLast;
    private Image markerPrevious;
    private Image markerNext;
    private Image aboutDescription;
    private Image aboutLicense;
    private Image aboutAuthors;
    private Image appIcon;
    private Image appIcon16;
    private Image appIcon24;
    private Image appIcon32;
    private Image appIcon48;
    private Image appIcon64;
    private Image appIcon96;
    private Image appSplash;
    private Image optionMain;
    private Image optionStyle;
    private Image optionSound;
    private Image optionLanguage;
    private Image optionToolbars;
    private Image optionSkin;
    private Image trackAdd;
    private Image trackRemove;
    private Image paintableTempo;
    private Image paintableGrace;
    private Image fretboard;
    private Image fretboardFirstFret;
    private Image fretboardFret;
    private Image compositionTimeSignature;
    private Image compositionTempo;
    private Image compositionRepeatOpen;
    private Image compositionRepeatClose;
    private Image compositionRepeatAlternative;
    private Image songProperties;
    private Image durationDotted;
    private Image durationDoubleDotted;
    private Image divisionType;
    private Image fileNew;
    private Image fileOpen;
    private Image fileSave;
    private Image fileSaveAs;
    private Image filePrint;
    private Image filePrintPreview;
    private Image chord;
    private Image noteTied;
    private Image instruments;
    private Image dynamicPPP;
    private Image dynamicPP;
    private Image dynamicP;
    private Image dynamicMP;
    private Image dynamicMF;
    private Image dynamicF;
    private Image dynamicFF;
    private Image dynamicFFF;
    private Image effectDead;
    private Image effectGhost;
    private Image effectAccentuated;
    private Image effectHeavyAccentuated;
    private Image effectHarmonic;
    private Image effectGrace;
    private Image effectBend;
    private Image effectTremoloBar;
    private Image effectSlide;
    private Image effectHammer;
    private Image effectVibrato;
    private Image effectTrill;
    private Image effectTremoloPicking;
    private Image effectPalmMute;
    private Image effectStaccato;
    private Image effectTapping;
    private Image effectSlapping;
    private Image effectPopping;
    private Image effectFadeIn;
    private Image browserNew;
    private Image browserFile;
    private Image browserFolder;
    private Image browserRoot;
    private Image browserBack;
    private Image browserRefresh;
    private Image settings;

    private TGIconManager(TGContext context) {
        this.context = context;
        this.disposableIcons = new ArrayList<Resource>();
        this.loadIcons();
    }

    public void addLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-icon", listener);
    }

    public void removeLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-icon", listener);
    }

    private void fireChanges() {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGIconEvent());
    }

    public void reloadIcons() {
        List<Resource> disposableIcons = this.purgeDisposableIcons();
        this.loadIcons();
        this.fireChanges();
        this.disposeIcons(disposableIcons);
    }

    public void loadIcons() {
        this.theme = TuxGuitar.getInstance().getConfig().getStringValue("skin");
        this.durations = new Image[]{this.loadIcon("1.png"), this.loadIcon("2.png"), this.loadIcon("4.png"), this.loadIcon("8.png"), this.loadIcon("16.png"), this.loadIcon("32.png"), this.loadIcon("64.png")};
        this.paintableTempo = this.loadIcon("tempo.png");
        this.paintableGrace = this.loadIcon("grace.png");
        this.layoutPage = this.loadIcon("layout_page.png");
        this.layoutLinear = this.loadIcon("layout_linear.png");
        this.layoutMultitrack = this.loadIcon("layout_multitrack.png");
        this.layoutScore = this.loadIcon("layout_score.png");
        this.layoutCompact = this.loadIcon("layout_compact.png");
        this.fileNew = this.loadIcon("new.png");
        this.fileOpen = this.loadIcon("open.png");
        this.fileSave = this.loadIcon("save.png");
        this.fileSaveAs = this.loadIcon("save-as.png");
        this.filePrint = this.loadIcon("print.png");
        this.filePrintPreview = this.loadIcon("print-preview.png");
        this.editUndo = this.loadIcon("edit_undo.png");
        this.editRedo = this.loadIcon("edit_redo.png");
        this.editVoice1 = this.loadIcon("edit_voice_1.png");
        this.editVoice2 = this.loadIcon("edit_voice_2.png");
        this.editModeSelection = this.loadIcon("edit_mode_selection.png");
        this.editModeEdition = this.loadIcon("edit_mode_edition.png");
        this.editModeEditionNotNatural = this.loadIcon("edit_mode_edition_no_natural.png");
        this.appIcon = this.loadIcon("icon.png");
        this.appIcon16 = this.loadIcon("icon-16x16.png");
        this.appIcon24 = this.loadIcon("icon-24x24.png");
        this.appIcon32 = this.loadIcon("icon-32x32.png");
        this.appIcon48 = this.loadIcon("icon-48x48.png");
        this.appIcon64 = this.loadIcon("icon-64x64.png");
        this.appIcon96 = this.loadIcon("icon-96x96.png");
        this.appSplash = this.loadIcon("splash.png");
        this.aboutDescription = this.loadIcon("about_description.png");
        this.aboutLicense = this.loadIcon("about_license.png");
        this.aboutAuthors = this.loadIcon("about_authors.png");
        this.optionMain = this.loadIcon("option_view.png");
        this.optionStyle = this.loadIcon("option_style.png");
        this.optionSound = this.loadIcon("option_sound.png");
        this.optionSkin = this.loadIcon("option_skin.png");
        this.optionLanguage = this.loadIcon("option_language.png");
        this.optionToolbars = this.loadIcon("option_toolbars.png");
        this.compositionTimeSignature = this.loadIcon("timesignature.png");
        this.compositionTempo = this.loadIcon("tempoicon.png");
        this.compositionRepeatOpen = this.loadIcon("openrepeat.png");
        this.compositionRepeatClose = this.loadIcon("closerepeat.png");
        this.compositionRepeatAlternative = this.loadIcon("repeat_alternative.png");
        this.songProperties = this.loadIcon("song_properties.png");
        this.trackAdd = this.loadIcon("track_add.png");
        this.trackRemove = this.loadIcon("track_remove.png");
        this.durationDotted = this.loadIcon("dotted.png");
        this.durationDoubleDotted = this.loadIcon("doubledotted.png");
        this.divisionType = this.loadIcon("division-type.png");
        this.fretboard = this.loadIcon("fretboard.png");
        this.fretboardFirstFret = this.loadIcon("firstfret.png");
        this.fretboardFret = this.loadIcon("fret.png");
        this.chord = this.loadIcon("chord.png");
        this.noteTied = this.loadIcon("tiednote.png");
        this.transport = this.loadIcon("transport.png");
        this.transportFirst1 = this.loadIcon("transport_first_1.png");
        this.transportFirst2 = this.loadIcon("transport_first_2.png");
        this.transportLast1 = this.loadIcon("transport_last_1.png");
        this.transportLast2 = this.loadIcon("transport_last_2.png");
        this.transportPrevious1 = this.loadIcon("transport_previous_1.png");
        this.transportPrevious2 = this.loadIcon("transport_previous_2.png");
        this.transportNext1 = this.loadIcon("transport_next_1.png");
        this.transportNext2 = this.loadIcon("transport_next_2.png");
        this.transportStop1 = this.loadIcon("transport_stop_1.png");
        this.transportStop2 = this.loadIcon("transport_stop_2.png");
        this.transportPlay1 = this.loadIcon("transport_play_1.png");
        this.transportPlay2 = this.loadIcon("transport_play_2.png");
        this.transportPause = this.loadIcon("transport_pause.png");
        this.transportIconFirst1 = this.loadIcon("transport_icon_first_1.png");
        this.transportIconFirst2 = this.loadIcon("transport_icon_first_2.png");
        this.transportIconLast1 = this.loadIcon("transport_icon_last_1.png");
        this.transportIconLast2 = this.loadIcon("transport_icon_last_2.png");
        this.transportIconPrevious1 = this.loadIcon("transport_icon_previous_1.png");
        this.transportIconPrevious2 = this.loadIcon("transport_icon_previous_2.png");
        this.transportIconNext1 = this.loadIcon("transport_icon_next_1.png");
        this.transportIconNext2 = this.loadIcon("transport_icon_next_2.png");
        this.transportIconStop1 = this.loadIcon("transport_icon_stop_1.png");
        this.transportIconStop2 = this.loadIcon("transport_icon_stop_2.png");
        this.transportIconPlay1 = this.loadIcon("transport_icon_play_1.png");
        this.transportIconPlay2 = this.loadIcon("transport_icon_play_2.png");
        this.transportIconPause = this.loadIcon("transport_icon_pause.png");
        this.transportMetronome = this.loadIcon("transport_metronome.png");
        this.transportMode = this.loadIcon("transport_mode.png");
        this.markerList = this.loadIcon("marker_list.png");
        this.markerAdd = this.loadIcon("marker_add.png");
        this.markerRemove = this.loadIcon("marker_remove.png");
        this.markerFirst = this.loadIcon("marker_first.png");
        this.markerLast = this.loadIcon("marker_last.png");
        this.markerPrevious = this.loadIcon("marker_previous.png");
        this.markerNext = this.loadIcon("marker_next.png");
        this.instruments = this.loadIcon("mixer.png");
        this.dynamicPPP = this.loadIcon("dynamic_ppp.png");
        this.dynamicPP = this.loadIcon("dynamic_pp.png");
        this.dynamicP = this.loadIcon("dynamic_p.png");
        this.dynamicMP = this.loadIcon("dynamic_mp.png");
        this.dynamicMF = this.loadIcon("dynamic_mf.png");
        this.dynamicF = this.loadIcon("dynamic_f.png");
        this.dynamicFF = this.loadIcon("dynamic_ff.png");
        this.dynamicFFF = this.loadIcon("dynamic_fff.png");
        this.effectDead = this.loadIcon("effect_dead.png");
        this.effectGhost = this.loadIcon("effect_ghost.png");
        this.effectAccentuated = this.loadIcon("effect_accentuated.png");
        this.effectHeavyAccentuated = this.loadIcon("effect_heavy_accentuated.png");
        this.effectHarmonic = this.loadIcon("effect_harmonic.png");
        this.effectGrace = this.loadIcon("effect_grace.png");
        this.effectBend = this.loadIcon("effect_bend.png");
        this.effectTremoloBar = this.loadIcon("effect_tremolo_bar.png");
        this.effectSlide = this.loadIcon("effect_slide.png");
        this.effectHammer = this.loadIcon("effect_hammer.png");
        this.effectVibrato = this.loadIcon("effect_vibrato.png");
        this.effectTrill = this.loadIcon("effect_trill.png");
        this.effectTremoloPicking = this.loadIcon("effect_tremolo_picking.png");
        this.effectPalmMute = this.loadIcon("effect_palm_mute.png");
        this.effectStaccato = this.loadIcon("effect_staccato.png");
        this.effectTapping = this.loadIcon("effect_tapping.png");
        this.effectSlapping = this.loadIcon("effect_slapping.png");
        this.effectPopping = this.loadIcon("effect_popping.png");
        this.effectFadeIn = this.loadIcon("effect_fade_in.png");
        this.browserNew = this.loadIcon("browser_new.png");
        this.browserFile = this.loadIcon("browser_file.png");
        this.browserFolder = this.loadIcon("browser_folder.png");
        this.browserRoot = this.loadIcon("browser_root.png");
        this.browserBack = this.loadIcon("browser_back.png");
        this.browserRefresh = this.loadIcon("browser_refresh.png");
        this.settings = this.loadIcon("settings.png");
    }

    private Image loadIcon(String name) {
        Image image = TGFileUtils.loadImage(this.context, this.theme, name);
        this.disposableIcons.add((Resource)image);
        return image;
    }

    private List<Resource> purgeDisposableIcons() {
        ArrayList<Resource> disposableIcons = new ArrayList<Resource>();
        for (Resource resource : this.disposableIcons) {
            disposableIcons.add(resource);
        }
        this.disposableIcons.clear();
        return disposableIcons;
    }

    public void disposeIcons(List<Resource> resources) {
        for (Image image : resources) {
            image.dispose();
        }
    }

    public void disposeIcons() {
        this.disposeIcons(this.purgeDisposableIcons());
    }

    public boolean shouldReload() {
        return !this.theme.equals(TuxGuitar.getInstance().getConfig().getStringValue("skin"));
    }

    public Image getDuration(int value) {
        switch (value) {
            case 1: {
                return this.durations[0];
            }
            case 2: {
                return this.durations[1];
            }
            case 4: {
                return this.durations[2];
            }
            case 8: {
                return this.durations[3];
            }
            case 16: {
                return this.durations[4];
            }
            case 32: {
                return this.durations[5];
            }
            case 64: {
                return this.durations[6];
            }
        }
        return null;
    }

    public Image getAboutAuthors() {
        return this.aboutAuthors;
    }

    public Image getAboutDescription() {
        return this.aboutDescription;
    }

    public Image getAboutLicense() {
        return this.aboutLicense;
    }

    public Image getAppIcon() {
        return this.appIcon;
    }

    public Image getAppIcon16() {
        return this.appIcon16;
    }

    public Image getAppIcon24() {
        return this.appIcon24;
    }

    public Image getAppIcon32() {
        return this.appIcon32;
    }

    public Image getAppIcon48() {
        return this.appIcon48;
    }

    public Image getAppIcon64() {
        return this.appIcon64;
    }

    public Image getAppIcon96() {
        return this.appIcon96;
    }

    public Image getAppSplash() {
        return this.appSplash;
    }

    public Image getChord() {
        return this.chord;
    }

    public Image getCompositionRepeatClose() {
        return this.compositionRepeatClose;
    }

    public Image getCompositionRepeatAlternative() {
        return this.compositionRepeatAlternative;
    }

    public Image getCompositionRepeatOpen() {
        return this.compositionRepeatOpen;
    }

    public Image getCompositionTempo() {
        return this.compositionTempo;
    }

    public Image getCompositionTimeSignature() {
        return this.compositionTimeSignature;
    }

    public Image getDurationDotted() {
        return this.durationDotted;
    }

    public Image getDurationDoubleDotted() {
        return this.durationDoubleDotted;
    }

    public Image getDivisionType() {
        return this.divisionType;
    }

    public Image getDynamicF() {
        return this.dynamicF;
    }

    public Image getDynamicFF() {
        return this.dynamicFF;
    }

    public Image getDynamicFFF() {
        return this.dynamicFFF;
    }

    public Image getDynamicMF() {
        return this.dynamicMF;
    }

    public Image getDynamicMP() {
        return this.dynamicMP;
    }

    public Image getDynamicP() {
        return this.dynamicP;
    }

    public Image getDynamicPP() {
        return this.dynamicPP;
    }

    public Image getDynamicPPP() {
        return this.dynamicPPP;
    }

    public Image getEditModeEdition() {
        return this.editModeEdition;
    }

    public Image getEditModeEditionNotNatural() {
        return this.editModeEditionNotNatural;
    }

    public Image getEditModeSelection() {
        return this.editModeSelection;
    }

    public Image getEditRedo() {
        return this.editRedo;
    }

    public Image getEditUndo() {
        return this.editUndo;
    }

    public Image getEditVoice1() {
        return this.editVoice1;
    }

    public Image getEditVoice2() {
        return this.editVoice2;
    }

    public Image getEffectAccentuated() {
        return this.effectAccentuated;
    }

    public Image getEffectBend() {
        return this.effectBend;
    }

    public Image getEffectDead() {
        return this.effectDead;
    }

    public Image getEffectFadeIn() {
        return this.effectFadeIn;
    }

    public Image getEffectGhost() {
        return this.effectGhost;
    }

    public Image getEffectGrace() {
        return this.effectGrace;
    }

    public Image getEffectHammer() {
        return this.effectHammer;
    }

    public Image getEffectHarmonic() {
        return this.effectHarmonic;
    }

    public Image getEffectHeavyAccentuated() {
        return this.effectHeavyAccentuated;
    }

    public Image getEffectPalmMute() {
        return this.effectPalmMute;
    }

    public Image getEffectPopping() {
        return this.effectPopping;
    }

    public Image getEffectSlapping() {
        return this.effectSlapping;
    }

    public Image getEffectSlide() {
        return this.effectSlide;
    }

    public Image getEffectStaccato() {
        return this.effectStaccato;
    }

    public Image getEffectTapping() {
        return this.effectTapping;
    }

    public Image getEffectTremoloBar() {
        return this.effectTremoloBar;
    }

    public Image getEffectTremoloPicking() {
        return this.effectTremoloPicking;
    }

    public Image getEffectTrill() {
        return this.effectTrill;
    }

    public Image getEffectVibrato() {
        return this.effectVibrato;
    }

    public Image getFileNew() {
        return this.fileNew;
    }

    public Image getFileOpen() {
        return this.fileOpen;
    }

    public Image getFilePrint() {
        return this.filePrint;
    }

    public Image getFilePrintPreview() {
        return this.filePrintPreview;
    }

    public Image getFileSave() {
        return this.fileSave;
    }

    public Image getFileSaveAs() {
        return this.fileSaveAs;
    }

    public Image getFretboard() {
        return this.fretboard;
    }

    public Image getFretboardFirstFret() {
        return this.fretboardFirstFret;
    }

    public Image getFretboardFret() {
        return this.fretboardFret;
    }

    public Image getLayoutLinear() {
        return this.layoutLinear;
    }

    public Image getLayoutMultitrack() {
        return this.layoutMultitrack;
    }

    public Image getLayoutPage() {
        return this.layoutPage;
    }

    public Image getLayoutScore() {
        return this.layoutScore;
    }

    public Image getLayoutCompact() {
        return this.layoutCompact;
    }

    public Image getMarkerAdd() {
        return this.markerAdd;
    }

    public Image getMarkerFirst() {
        return this.markerFirst;
    }

    public Image getMarkerLast() {
        return this.markerLast;
    }

    public Image getMarkerList() {
        return this.markerList;
    }

    public Image getMarkerNext() {
        return this.markerNext;
    }

    public Image getMarkerPrevious() {
        return this.markerPrevious;
    }

    public Image getMarkerRemove() {
        return this.markerRemove;
    }

    public Image getInstruments() {
        return this.instruments;
    }

    public Image getNoteTied() {
        return this.noteTied;
    }

    public Image getOptionLanguage() {
        return this.optionLanguage;
    }

    public Image getOptionMain() {
        return this.optionMain;
    }

    public Image getOptionSound() {
        return this.optionSound;
    }

    public Image getOptionStyle() {
        return this.optionStyle;
    }

    public Image getOptionToolbars() {
        return this.optionToolbars;
    }

    public Image getOptionSkin() {
        return this.optionSkin;
    }

    public Image getPaintableGrace() {
        return this.paintableGrace;
    }

    public Image getPaintableTempo() {
        return this.paintableTempo;
    }

    public Image getSongProperties() {
        return this.songProperties;
    }

    public Image getTrackAdd() {
        return this.trackAdd;
    }

    public Image getTrackRemove() {
        return this.trackRemove;
    }

    public Image getTransport() {
        return this.transport;
    }

    public Image getTransportFirst1() {
        return this.transportFirst1;
    }

    public Image getTransportFirst2() {
        return this.transportFirst2;
    }

    public Image getTransportIconFirst1() {
        return this.transportIconFirst1;
    }

    public Image getTransportIconFirst2() {
        return this.transportIconFirst2;
    }

    public Image getTransportIconLast1() {
        return this.transportIconLast1;
    }

    public Image getTransportIconLast2() {
        return this.transportIconLast2;
    }

    public Image getTransportIconNext1() {
        return this.transportIconNext1;
    }

    public Image getTransportIconNext2() {
        return this.transportIconNext2;
    }

    public Image getTransportIconPause() {
        return this.transportIconPause;
    }

    public Image getTransportIconPlay1() {
        return this.transportIconPlay1;
    }

    public Image getTransportIconPlay2() {
        return this.transportIconPlay2;
    }

    public Image getTransportIconPrevious1() {
        return this.transportIconPrevious1;
    }

    public Image getTransportIconPrevious2() {
        return this.transportIconPrevious2;
    }

    public Image getTransportIconStop1() {
        return this.transportIconStop1;
    }

    public Image getTransportIconStop2() {
        return this.transportIconStop2;
    }

    public Image getTransportLast1() {
        return this.transportLast1;
    }

    public Image getTransportLast2() {
        return this.transportLast2;
    }

    public Image getTransportNext1() {
        return this.transportNext1;
    }

    public Image getTransportNext2() {
        return this.transportNext2;
    }

    public Image getTransportPause() {
        return this.transportPause;
    }

    public Image getTransportPlay1() {
        return this.transportPlay1;
    }

    public Image getTransportPlay2() {
        return this.transportPlay2;
    }

    public Image getTransportPrevious1() {
        return this.transportPrevious1;
    }

    public Image getTransportPrevious2() {
        return this.transportPrevious2;
    }

    public Image getTransportStop1() {
        return this.transportStop1;
    }

    public Image getTransportStop2() {
        return this.transportStop2;
    }

    public Image getTransportMetronome() {
        return this.transportMetronome;
    }

    public Image getTransportMode() {
        return this.transportMode;
    }

    public Image getBrowserBack() {
        return this.browserBack;
    }

    public Image getBrowserFile() {
        return this.browserFile;
    }

    public Image getBrowserFolder() {
        return this.browserFolder;
    }

    public Image getBrowserRefresh() {
        return this.browserRefresh;
    }

    public Image getBrowserRoot() {
        return this.browserRoot;
    }

    public Image getBrowserNew() {
        return this.browserNew;
    }

    public Image getSettings() {
        return this.settings;
    }

    public static TGIconManager getInstance(TGContext context) {
        return (TGIconManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGIconManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGIconManager>(){

            public TGIconManager createInstance(TGContext context) {
                return new TGIconManager(context);
            }
        });
    }
}

