/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.lilypond;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.io.lilypond.LilypondSettings;
import org.herac.tuxguitar.song.models.TGSong;

public class LilypondSettingsDialog {
    private static final int STATUS_NONE = 0;
    private static final int STATUS_CANCELLED = 1;
    private static final int STATUS_ACCEPTED = 2;
    private TGSong song;
    protected int status;

    public LilypondSettingsDialog(TGSong song) {
        this.song = song;
    }

    public LilypondSettings open() {
        this.status = 0;
        final LilypondSettings settings = LilypondSettings.getDefaults();
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setText(TuxGuitar.getProperty((String)"lilypond.options"));
        Composite columnLeft = new Composite((Composite)dialog, 0);
        columnLeft.setLayoutData((Object)new GridData(4, 4, true, true));
        columnLeft.setLayout((Layout)this.getColumnLayout());
        Composite columnRight = new Composite((Composite)dialog, 0);
        columnRight.setLayoutData((Object)new GridData(4, 4, true, true));
        columnRight.setLayout((Layout)this.getColumnLayout());
        Group trackGroup = new Group(columnLeft, 16);
        trackGroup.setLayout((Layout)new GridLayout(2, false));
        trackGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        trackGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.select-track.tip"));
        final Label trackLabel = new Label((Composite)trackGroup, 0);
        trackLabel.setText(TuxGuitar.getProperty((String)"lilypond.options.select-track") + ":");
        trackLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Combo trackCombo = new Combo((Composite)trackGroup, 12);
        trackCombo.setLayoutData((Object)this.getComboData());
        for (int number = 1; number <= this.song.countTracks(); ++number) {
            trackCombo.add(TuxGuitar.getInstance().getSongManager().getTrack(this.song, number).getName());
        }
        trackCombo.select(TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        trackCombo.setEnabled(settings.getTrack() != -1);
        final Button trackAllCheck = new Button((Composite)trackGroup, 32);
        trackAllCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        trackAllCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.select-all-tracks"));
        trackAllCheck.setSelection(settings.getTrack() == -1);
        Group measureGroup = new Group(columnLeft, 16);
        measureGroup.setLayout((Layout)new GridLayout(2, false));
        measureGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        measureGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.tip"));
        boolean minSelection = true;
        final int maxSelection = this.song.countMeasureHeaders();
        Label measureFromLabel = new Label((Composite)measureGroup, 0);
        measureFromLabel.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.from"));
        measureFromLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Spinner measureFromSpinner = new Spinner((Composite)measureGroup, 2048);
        measureFromSpinner.setLayoutData((Object)this.getSpinnerData());
        measureFromSpinner.setMaximum(maxSelection);
        measureFromSpinner.setMinimum(1);
        measureFromSpinner.setSelection(1);
        Label measureToLabel = new Label((Composite)measureGroup, 0);
        measureToLabel.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.to"));
        measureToLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Spinner measureToSpinner = new Spinner((Composite)measureGroup, 2048);
        measureToSpinner.setLayoutData((Object)this.getSpinnerData());
        measureToSpinner.setMinimum(1);
        measureToSpinner.setMaximum(maxSelection);
        measureToSpinner.setSelection(maxSelection);
        measureFromSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection = measureFromSpinner.getSelection();
                int toSelection = measureToSpinner.getSelection();
                if (fromSelection < 1) {
                    measureFromSpinner.setSelection(1);
                } else if (fromSelection > toSelection) {
                    measureFromSpinner.setSelection(toSelection);
                }
            }
        });
        measureToSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection;
                int toSelection = measureToSpinner.getSelection();
                if (toSelection < (fromSelection = measureFromSpinner.getSelection())) {
                    measureToSpinner.setSelection(fromSelection);
                } else if (toSelection > maxSelection) {
                    measureToSpinner.setSelection(maxSelection);
                }
            }
        });
        Group versionGroup = new Group(columnRight, 16);
        versionGroup.setLayout((Layout)new GridLayout());
        versionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        versionGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.format-version"));
        final Text lilyVersion = new Text((Composite)versionGroup, 18432);
        lilyVersion.setText(settings.getLilypondVersion());
        lilyVersion.setLayoutData((Object)new GridData(4, 4, true, true));
        Group layoutGroup = new Group(columnRight, 16);
        layoutGroup.setLayout((Layout)new GridLayout());
        layoutGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        layoutGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.tip"));
        final Button scoreCheck = new Button((Composite)layoutGroup, 32);
        scoreCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        scoreCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-score"));
        scoreCheck.setSelection(settings.isScoreEnabled());
        final Button tablatureCheck = new Button((Composite)layoutGroup, 32);
        tablatureCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        tablatureCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-tablature"));
        tablatureCheck.setSelection(settings.isTablatureEnabled());
        final Button trackGroupCheck = new Button((Composite)layoutGroup, 32);
        trackGroupCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        trackGroupCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-track-groups"));
        trackGroupCheck.setSelection(settings.isTrackGroupEnabled());
        trackGroupCheck.setEnabled(settings.getTrack() == -1);
        final Button trackNameCheck = new Button((Composite)layoutGroup, 32);
        trackNameCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        trackNameCheck.setSelection(settings.isTrackNameEnabled());
        trackNameCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-track-names"));
        final Button lyricsCheck = new Button((Composite)layoutGroup, 32);
        lyricsCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        lyricsCheck.setSelection(settings.isLyricsEnabled());
        lyricsCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-lyrics"));
        final Button textsCheck = new Button((Composite)layoutGroup, 32);
        textsCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        textsCheck.setSelection(settings.isTextEnabled());
        textsCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-texts"));
        final Button chordDiagramsCheck = new Button((Composite)layoutGroup, 32);
        chordDiagramsCheck.setLayoutData((Object)new GridData(4, 4, true, true));
        chordDiagramsCheck.setSelection(settings.isChordDiagramEnabled());
        chordDiagramsCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-chord-diagrams"));
        tablatureCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!tablatureCheck.getSelection()) {
                    scoreCheck.setSelection(true);
                }
            }
        });
        scoreCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!scoreCheck.getSelection()) {
                    tablatureCheck.setSelection(true);
                }
            }
        });
        trackAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                trackLabel.setEnabled(!trackAllCheck.getSelection());
                trackCombo.setEnabled(!trackAllCheck.getSelection());
                trackGroupCheck.setEnabled(trackAllCheck.getSelection());
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 4, true, true, 2, 1));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LilypondSettingsDialog.this.status = 2;
                settings.setTrack(trackAllCheck.getSelection() ? -1 : trackCombo.getSelectionIndex() + 1);
                settings.setTrackGroupEnabled(trackAllCheck.getSelection() ? trackGroupCheck.getSelection() : false);
                settings.setTrackNameEnabled(trackNameCheck.getSelection());
                settings.setMeasureFrom(measureFromSpinner.getSelection());
                settings.setMeasureTo(measureToSpinner.getSelection());
                settings.setScoreEnabled(scoreCheck.getSelection());
                settings.setTablatureEnabled(tablatureCheck.getSelection());
                settings.setChordDiagramEnabled(chordDiagramsCheck.getSelection());
                settings.setLyricsEnabled(lyricsCheck.getSelection());
                settings.setTextEnabled(textsCheck.getSelection());
                settings.setLilypondVersion(lilyVersion.getText());
                settings.check();
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LilypondSettingsDialog.this.status = 1;
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
        return this.status == 2 ? settings : null;
    }

    private GridLayout getColumnLayout() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    private GridData getComboData() {
        GridData data = new GridData(4, 0x1000000, true, true);
        data.minimumWidth = 120;
        return data;
    }

    private GridData getSpinnerData() {
        GridData data = new GridData(4, 0x1000000, true, true);
        data.minimumWidth = 60;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }
}

