/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiRepeatController;
import org.herac.tuxguitar.player.base.MidiSequenceHandler;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;

public class MidiSequenceParser {
    private static final int DEFAULT_METRONOME_KEY = 37;
    private static final int DEFAULT_DURATION_PM = 60;
    private static final int DEFAULT_DURATION_DEAD = 30;
    private static final int DEFAULT_BEND = 64;
    private static final float DEFAULT_BEND_SEMI_TONE = 2.75f;
    public static final int ADD_DEFAULT_CONTROLS = 1;
    public static final int ADD_MIXER_MESSAGES = 2;
    public static final int ADD_METRONOME = 4;
    public static final int ADD_FIRST_TICK_MOVE = 8;
    public static final int DEFAULT_PLAY_FLAGS = 4;
    public static final int DEFAULT_EXPORT_FLAGS = 11;
    private TGSong song;
    private TGSongManager songManager;
    private int flags;
    private int infoTrack;
    private int metronomeTrack;
    private int metronomeChannelId;
    private int firstTickMove;
    private int tempoPercent;
    private int transpose;
    private int sHeader;
    private int eHeader;

    public MidiSequenceParser(TGSong song, TGSongManager songManager, int flags) {
        this.song = song;
        this.songManager = songManager;
        this.flags = flags;
        this.tempoPercent = 100;
        this.transpose = 0;
        this.sHeader = -1;
        this.eHeader = -1;
        this.firstTickMove = (int)((flags & 8) != 0 ? -960L : 0L);
    }

    public int getInfoTrack() {
        return this.infoTrack;
    }

    public int getMetronomeTrack() {
        return this.metronomeTrack;
    }

    private long getTick(long tick) {
        return tick + (long)this.firstTickMove;
    }

    public void setSHeader(int header) {
        this.sHeader = header;
    }

    public void setEHeader(int header) {
        this.eHeader = header;
    }

    public void setMetronomeChannelId(int metronomeChannelId) {
        this.metronomeChannelId = metronomeChannelId;
    }

    public void setTempoPercent(int tempoPercent) {
        this.tempoPercent = tempoPercent;
    }

    public void setTranspose(int transpose) {
        this.transpose = transpose;
    }

    private int fix(int value) {
        return value >= 0 ? (value <= 127 ? value : 127) : 0;
    }

    public void parse(MidiSequenceHandler sequence) {
        this.infoTrack = 0;
        this.metronomeTrack = sequence.getTracks() - 1;
        MidiSequenceHelper helper = new MidiSequenceHelper(sequence);
        MidiRepeatController controller = new MidiRepeatController(this.song, this.sHeader, this.eHeader);
        while (!controller.finished()) {
            int index = controller.getIndex();
            long move = controller.getRepeatMove();
            controller.process();
            if (!controller.shouldPlay()) continue;
            helper.addMeasureHelper(new MidiMeasureHelper(index, move));
        }
        this.addDefaultMessages(helper, this.song);
        for (int i = 0; i < this.song.countTracks(); ++i) {
            TGTrack songTrack = this.song.getTrack(i);
            this.createTrack(helper, songTrack);
        }
        sequence.notifyFinish();
    }

    private void createTrack(MidiSequenceHelper sh, TGTrack track) {
        TGChannel tgChannel = this.songManager.getChannel(this.song, track.getChannelId());
        if (tgChannel != null) {
            TGMeasure previous = null;
            this.addBend(sh, track.getNumber(), 960L, 64, tgChannel.getChannelId(), -1, false);
            this.makeChannel(sh, tgChannel, track.getNumber());
            int mCount = sh.getMeasureHelpers().size();
            for (int mIndex = 0; mIndex < mCount; ++mIndex) {
                MidiMeasureHelper mh = sh.getMeasureHelper(mIndex);
                TGMeasure measure = track.getMeasure(mh.getIndex());
                if (track.getNumber() == 1) {
                    this.addTimeSignature(sh, measure, previous, mh.getMove());
                    this.addTempo(sh, measure, previous, mh.getMove());
                    this.addMetronome(sh, measure.getHeader(), mh.getMove());
                }
                this.makeBeats(sh, tgChannel, track, measure, mIndex, mh.getMove());
                previous = measure;
            }
        }
    }

    private void makeBeats(MidiSequenceHelper sh, TGChannel channel, TGTrack track, TGMeasure measure, int mIndex, long startMove) {
        int[] stroke = new int[track.stringCount()];
        TGBeat previous = null;
        for (int bIndex = 0; bIndex < measure.countBeats(); ++bIndex) {
            TGBeat beat = measure.getBeat(bIndex);
            this.makeNotes(sh, channel, track, beat, measure.getTempo(), mIndex, bIndex, startMove, this.getStroke(beat, previous, stroke));
            previous = beat;
        }
    }

    private void makeNotes(MidiSequenceHelper sh, TGChannel tgChannel, TGTrack track, TGBeat beat, TGTempo tempo, int mIndex, int bIndex, long startMove, int[] stroke) {
        for (int vIndex = 0; vIndex < beat.countVoices(); ++vIndex) {
            TGVoice voice = beat.getVoice(vIndex);
            MidiTickHelper th = this.checkTripletFeel(voice, bIndex);
            for (int noteIdx = 0; noteIdx < voice.countNotes(); ++noteIdx) {
                TGNote note = voice.getNote(noteIdx);
                if (note.isTiedNote()) continue;
                int key = this.transpose + track.getOffset() + note.getValue() + track.getStrings().get(note.getString() - 1).getValue();
                long start = this.applyStrokeStart(note, th.getStart() + startMove, stroke);
                long duration = this.applyStrokeDuration(note, this.getRealNoteDuration(sh, track, note, tempo, th.getDuration(), mIndex, bIndex), stroke);
                int velocity = this.getRealVelocity(sh, note, track, tgChannel, mIndex, bIndex);
                int channel = tgChannel.getChannelId();
                int midiVoice = note.getString();
                boolean bendMode = false;
                boolean percussionChannel = tgChannel.isPercussionChannel();
                if (note.getEffect().isFadeIn()) {
                    this.makeFadeIn(sh, track.getNumber(), start, duration, tgChannel.getVolume(), channel);
                }
                if (note.getEffect().isGrace() && !percussionChannel) {
                    long graceDuration;
                    bendMode = true;
                    int graceKey = track.getOffset() + note.getEffect().getGrace().getFret() + track.getStrings().get(note.getString() - 1).getValue();
                    int graceLength = note.getEffect().getGrace().getDurationTime();
                    int graceVelocity = note.getEffect().getGrace().getDynamic();
                    long l = graceDuration = note.getEffect().getGrace().isDead() ? this.applyStaticDuration(tempo, 30L, graceLength) : (long)graceLength;
                    if (note.getEffect().getGrace().isOnBeat() || start - (long)graceLength < 960L) {
                        start += (long)graceLength;
                        duration -= (long)graceLength;
                    }
                    this.makeNote(sh, track.getNumber(), graceKey, start - (long)graceLength, graceDuration, graceVelocity, channel, midiVoice, bendMode);
                }
                if (note.getEffect().isTrill() && !percussionChannel) {
                    int trillKey = track.getOffset() + note.getEffect().getTrill().getFret() + track.getStrings().get(note.getString() - 1).getValue();
                    long trillLength = note.getEffect().getTrill().getDuration().getTime();
                    boolean realKey = true;
                    long tick = start;
                    while (tick + 10L < start + duration) {
                        if (tick + trillLength >= start + duration) {
                            trillLength = start + duration - tick - 1L;
                        }
                        this.makeNote(sh, track.getNumber(), realKey ? key : trillKey, tick, trillLength, velocity, channel, midiVoice, bendMode);
                        realKey = !realKey;
                        tick += trillLength;
                    }
                    continue;
                }
                if (note.getEffect().isTremoloPicking()) {
                    long tpLength = note.getEffect().getTremoloPicking().getDuration().getTime();
                    long tick = start;
                    while (tick + 10L < start + duration) {
                        if (tick + tpLength >= start + duration) {
                            tpLength = start + duration - tick - 1L;
                        }
                        this.makeNote(sh, track.getNumber(), key, tick, tpLength, velocity, channel, midiVoice, bendMode);
                        tick += tpLength;
                    }
                    continue;
                }
                if (note.getEffect().isBend() && !percussionChannel) {
                    bendMode = true;
                    this.makeBend(sh, track.getNumber(), start, duration, note.getEffect().getBend(), channel, midiVoice, bendMode);
                } else if (note.getEffect().isTremoloBar() && !percussionChannel) {
                    bendMode = true;
                    this.makeTremoloBar(sh, track.getNumber(), start, duration, note.getEffect().getTremoloBar(), channel, midiVoice, bendMode);
                } else if (note.getEffect().isSlide() && !percussionChannel) {
                    bendMode = true;
                    this.makeSlide(sh, note, track, mIndex, bIndex, startMove, channel, midiVoice, bendMode);
                } else if (note.getEffect().isVibrato() && !percussionChannel) {
                    bendMode = true;
                    this.makeVibrato(sh, track.getNumber(), start, duration, channel, midiVoice, bendMode);
                }
                if (note.getEffect().isHarmonic() && !percussionChannel) {
                    int orig = key;
                    if (note.getEffect().getHarmonic().isNatural()) {
                        for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                            if (note.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[i][0] % 12) continue;
                            key = orig + TGEffectHarmonic.NATURAL_FREQUENCIES[i][1] - note.getValue();
                            break;
                        }
                    } else {
                        if (note.getEffect().getHarmonic().isSemi() && !percussionChannel) {
                            this.makeNote(sh, track.getNumber(), Math.min(127, orig), start, duration, Math.max(15, velocity - 48), channel, midiVoice, bendMode);
                        }
                        key = orig + TGEffectHarmonic.NATURAL_FREQUENCIES[note.getEffect().getHarmonic().getData()][1];
                    }
                    if (key - 12 > 0) {
                        int hVelocity = Math.max(15, velocity - 64);
                        this.makeNote(sh, track.getNumber(), key - 12, start, duration, hVelocity, channel, midiVoice, bendMode);
                    }
                }
                this.makeNote(sh, track.getNumber(), Math.min(127, key), start, duration, velocity, channel, midiVoice, bendMode);
            }
        }
    }

    private void makeNote(MidiSequenceHelper sh, int track, int key, long start, long duration, int velocity, int channel, int midiVoice, boolean bendMode) {
        sh.getSequence().addNoteOn(this.getTick(start), track, channel, this.fix(key), this.fix(velocity), midiVoice, bendMode);
        if (duration > 0L) {
            sh.getSequence().addNoteOff(this.getTick(start + duration), track, channel, this.fix(key), this.fix(velocity), midiVoice, bendMode);
        }
    }

    private void makeChannel(MidiSequenceHelper sh, TGChannel channel, int track) {
        if ((this.flags & 2) != 0) {
            int channelId = channel.getChannelId();
            long tick = this.getTick(960L);
            sh.getSequence().addControlChange(tick, track, channelId, 7, this.fix(channel.getVolume()));
            sh.getSequence().addControlChange(tick, track, channelId, 10, this.fix(channel.getBalance()));
            sh.getSequence().addControlChange(tick, track, channelId, 93, this.fix(channel.getChorus()));
            sh.getSequence().addControlChange(tick, track, channelId, 91, this.fix(channel.getReverb()));
            sh.getSequence().addControlChange(tick, track, channelId, 95, this.fix(channel.getPhaser()));
            sh.getSequence().addControlChange(tick, track, channelId, 92, this.fix(channel.getTremolo()));
            sh.getSequence().addControlChange(tick, track, channelId, 11, 127);
            if (!channel.isPercussionChannel()) {
                sh.getSequence().addControlChange(tick, track, channelId, 0, this.fix(channel.getBank()));
            }
            sh.getSequence().addProgramChange(tick, track, channelId, this.fix(channel.getProgram()));
        }
    }

    private void addTimeSignature(MidiSequenceHelper sh, TGMeasure currMeasure, TGMeasure prevMeasure, long startMove) {
        boolean addTimeSignature = false;
        if (prevMeasure == null) {
            addTimeSignature = true;
        } else {
            int currNumerator = currMeasure.getTimeSignature().getNumerator();
            int currValue = currMeasure.getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getTimeSignature().getDenominator().getValue();
            if (currNumerator != prevNumerator || currValue != prevValue) {
                addTimeSignature = true;
            }
        }
        if (addTimeSignature) {
            sh.getSequence().addTimeSignature(this.getTick(currMeasure.getStart() + startMove), this.getInfoTrack(), currMeasure.getTimeSignature());
        }
    }

    private void addTempo(MidiSequenceHelper sh, TGMeasure currMeasure, TGMeasure prevMeasure, long startMove) {
        boolean addTempo = false;
        if (prevMeasure == null) {
            addTempo = true;
        } else if (currMeasure.getTempo().getInUSQ() != prevMeasure.getTempo().getInUSQ()) {
            addTempo = true;
        }
        if (addTempo) {
            int usq = (int)((double)currMeasure.getTempo().getInUSQ() * 100.0 / (double)this.tempoPercent);
            sh.getSequence().addTempoInUSQ(this.getTick(currMeasure.getStart() + startMove), this.getInfoTrack(), usq);
        }
    }

    private long getRealNoteDuration(MidiSequenceHelper sh, TGTrack track, TGNote note, TGTempo tempo, long duration, int mIndex, int bIndex) {
        boolean letRing = note.getEffect().isLetRing();
        boolean letRingBeatChanged = false;
        long lastEnd = note.getVoice().getBeat().getStart() + note.getVoice().getDuration().getTime() + sh.getMeasureHelper(mIndex).getMove();
        long realDuration = duration;
        int nextBIndex = bIndex + 1;
        int mCount = sh.getMeasureHelpers().size();
        for (int m = mIndex; m < mCount; ++m) {
            MidiMeasureHelper mh = sh.getMeasureHelper(m);
            TGMeasure measure = track.getMeasure(mh.getIndex());
            int beatCount = measure.countBeats();
            for (int b = nextBIndex; b < beatCount; ++b) {
                TGBeat beat = measure.getBeat(b);
                TGVoice voice = beat.getVoice(note.getVoice().getIndex());
                if (voice.isEmpty()) continue;
                if (voice.isRestVoice()) {
                    return this.applyDurationEffects(note, tempo, realDuration);
                }
                int noteCount = voice.countNotes();
                for (int n = 0; n < noteCount; ++n) {
                    TGNote nextNote = voice.getNote(n);
                    if (nextNote.equals(note) && mIndex == m || nextNote.getString() != note.getString()) continue;
                    if (nextNote.isTiedNote()) {
                        realDuration += mh.getMove() + beat.getStart() - lastEnd + nextNote.getVoice().getDuration().getTime();
                        lastEnd = mh.getMove() + beat.getStart() + voice.getDuration().getTime();
                        letRing = nextNote.getEffect().isLetRing();
                        letRingBeatChanged = true;
                        continue;
                    }
                    return this.applyDurationEffects(note, tempo, realDuration);
                }
                if (letRing && !letRingBeatChanged) {
                    realDuration += voice.getDuration().getTime();
                }
                letRingBeatChanged = false;
            }
            nextBIndex = 0;
        }
        return this.applyDurationEffects(note, tempo, realDuration);
    }

    private long applyDurationEffects(TGNote note, TGTempo tempo, long duration) {
        if (note.getEffect().isDeadNote()) {
            return this.applyStaticDuration(tempo, 30L, duration);
        }
        if (note.getEffect().isPalmMute()) {
            return this.applyStaticDuration(tempo, 60L, duration);
        }
        if (note.getEffect().isStaccato()) {
            return (long)((double)duration * 50.0 / 100.0);
        }
        return duration;
    }

    private long applyStaticDuration(TGTempo tempo, long duration, long maximum) {
        long value = (long)tempo.getValue() * duration / 60L;
        return value < maximum ? value : maximum;
    }

    private int getRealVelocity(MidiSequenceHelper sh, TGNote note, TGTrack tgTrack, TGChannel tgChannel, int mIndex, int bIndex) {
        MidiNoteHelper previousNote;
        int velocity = note.getVelocity();
        if (!tgChannel.isPercussionChannel() && (previousNote = this.getPreviousNote(sh, note, tgTrack, mIndex, bIndex, false)) != null && previousNote.getNote().getEffect().isHammer()) {
            velocity = Math.max(15, velocity - 25);
        }
        if (note.getEffect().isGhostNote()) {
            velocity = Math.max(15, velocity - 16);
        } else if (note.getEffect().isAccentuatedNote()) {
            velocity = Math.max(15, velocity + 16);
        } else if (note.getEffect().isHeavyAccentuatedNote()) {
            velocity = Math.max(15, velocity + 32);
        }
        return velocity > 127 ? 127 : velocity;
    }

    public void addMetronome(MidiSequenceHelper sh, TGMeasureHeader header, long startMove) {
        if ((this.flags & 4) != 0 && this.metronomeChannelId >= 0) {
            long start = startMove + header.getStart();
            long length = header.getTimeSignature().getDenominator().getTime();
            for (int i = 1; i <= header.getTimeSignature().getNumerator(); ++i) {
                this.makeNote(sh, this.getMetronomeTrack(), 37, start, length, 95, this.metronomeChannelId, -1, false);
                start += length;
            }
        }
    }

    public void addDefaultMessages(MidiSequenceHelper sh, TGSong tgSong) {
        if ((this.flags & 1) != 0) {
            Iterator<TGChannel> it = tgSong.getChannels();
            while (it.hasNext()) {
                int channelId = it.next().getChannelId();
                sh.getSequence().addControlChange(this.getTick(960L), this.getInfoTrack(), channelId, 101, 0);
                sh.getSequence().addControlChange(this.getTick(960L), this.getInfoTrack(), channelId, 100, 0);
                sh.getSequence().addControlChange(this.getTick(960L), this.getInfoTrack(), channelId, 6, 12);
                sh.getSequence().addControlChange(this.getTick(960L), this.getInfoTrack(), channelId, 38, 0);
            }
        }
    }

    private void addBend(MidiSequenceHelper sh, int track, long tick, int bend, int channel, int midiVoice, boolean bendMode) {
        sh.getSequence().addPitchBend(this.getTick(tick), track, channel, this.fix(bend), midiVoice, bendMode);
    }

    public void makeVibrato(MidiSequenceHelper sh, int track, long start, long duration, int channel, int midiVoice, boolean bendMode) {
        long nextStart = start;
        long end = nextStart + duration;
        while (nextStart < end) {
            nextStart = nextStart + 160L > end ? end : nextStart + 160L;
            this.addBend(sh, track, nextStart, 64, channel, midiVoice, bendMode);
            nextStart = nextStart + 160L > end ? end : nextStart + 160L;
            this.addBend(sh, track, nextStart, 65, channel, midiVoice, bendMode);
        }
        this.addBend(sh, track, nextStart, 64, channel, midiVoice, bendMode);
    }

    public void makeBend(MidiSequenceHelper sh, int track, long start, long duration, TGEffectBend bend, int channel, int midiVoice, boolean bendMode) {
        List<TGEffectBend.BendPoint> points = bend.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            TGEffectBend.BendPoint point = points.get(i);
            long bendStart = start + point.getTime(duration);
            int value = 64 + (int)((float)point.getValue() * 2.75f / 1.0f);
            value = value <= 127 ? value : 127;
            value = value >= 0 ? value : 0;
            this.addBend(sh, track, bendStart, value, channel, midiVoice, bendMode);
            if (points.size() <= i + 1) continue;
            TGEffectBend.BendPoint nextPoint = points.get(i + 1);
            int nextValue = 64 + (int)((float)nextPoint.getValue() * 2.75f / 1.0f);
            long nextBendStart = start + nextPoint.getTime(duration);
            if (nextValue == value) continue;
            double width = (nextBendStart - bendStart) / (long)Math.abs(nextValue - value);
            if (value < nextValue) {
                while (value < nextValue) {
                    bendStart = (long)((double)bendStart + width);
                    this.addBend(sh, track, bendStart, ++value <= 127 ? value : 127, channel, midiVoice, bendMode);
                }
                continue;
            }
            if (value <= nextValue) continue;
            while (value > nextValue) {
                bendStart = (long)((double)bendStart + width);
                this.addBend(sh, track, bendStart, --value >= 0 ? value : 0, channel, midiVoice, bendMode);
            }
        }
        this.addBend(sh, track, start + duration, 64, channel, midiVoice, bendMode);
    }

    public void makeTremoloBar(MidiSequenceHelper sh, int track, long start, long duration, TGEffectTremoloBar effect, int channel, int midiVoice, boolean bendMode) {
        List<TGEffectTremoloBar.TremoloBarPoint> points = effect.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            TGEffectTremoloBar.TremoloBarPoint point = points.get(i);
            long pointStart = start + point.getTime(duration);
            int value = 64 + (int)((float)point.getValue() * 5.5f);
            value = value <= 127 ? value : 127;
            value = value >= 0 ? value : 0;
            this.addBend(sh, track, pointStart, value, channel, midiVoice, bendMode);
            if (points.size() <= i + 1) continue;
            TGEffectTremoloBar.TremoloBarPoint nextPoint = points.get(i + 1);
            int nextValue = 64 + (int)((float)nextPoint.getValue() * 5.5f);
            long nextPointStart = start + nextPoint.getTime(duration);
            if (nextValue == value) continue;
            double width = (nextPointStart - pointStart) / (long)Math.abs(nextValue - value);
            if (value < nextValue) {
                while (value < nextValue) {
                    pointStart = (long)((double)pointStart + width);
                    this.addBend(sh, track, pointStart, ++value <= 127 ? value : 127, channel, midiVoice, bendMode);
                }
                continue;
            }
            if (value <= nextValue) continue;
            while (value > nextValue) {
                pointStart = (long)((double)pointStart + width);
                this.addBend(sh, track, pointStart, --value >= 0 ? value : 0, channel, midiVoice, bendMode);
            }
        }
        this.addBend(sh, track, start + duration, 64, channel, midiVoice, bendMode);
    }

    private void makeSlide(MidiSequenceHelper sh, TGNote note, TGTrack track, int mIndex, int bIndex, long startMove, int channel, int midiVoice, boolean bendMode) {
        MidiNoteHelper nextNote = this.getNextNote(sh, note, track, mIndex, bIndex, true);
        if (nextNote != null) {
            int value1 = note.getValue();
            int value2 = nextNote.getNote().getValue();
            long tick1 = note.getVoice().getBeat().getStart() + startMove;
            long tick2 = nextNote.getNote().getVoice().getBeat().getStart() + nextNote.getMeasure().getMove();
            this.makeSlide(sh, track.getNumber(), tick1, value1, tick2, value2, channel, midiVoice, bendMode);
            this.addBend(sh, track.getNumber(), tick2, 64, channel, midiVoice, bendMode);
        }
    }

    public void makeSlide(MidiSequenceHelper sh, int track, long tick1, int value1, long tick2, int value2, int channel, int midiVoice, boolean bendMode) {
        long distance = value2 - value1;
        long length = tick2 - tick1;
        int points = (int)(length / 120L);
        for (int i = 1; i <= points; ++i) {
            float tone = (float)(length / (long)points) * (float)i * (float)distance / (float)length;
            int bend = 64 + (int)(tone * 5.5f);
            this.addBend(sh, track, tick1 + length / (long)points * (long)i, bend, channel, midiVoice, bendMode);
        }
    }

    private void makeFadeIn(MidiSequenceHelper sh, int track, long start, long duration, int volume3, int channel) {
        int expression = 31;
        int expressionIncrement = 1;
        long tickIncrement = duration / (long)((127 - expression) / expressionIncrement);
        for (long tick = start; tick < start + duration && expression < 127; tick += tickIncrement, expression += expressionIncrement) {
            sh.getSequence().addControlChange(this.getTick(tick), track, channel, 11, this.fix(expression));
        }
        sh.getSequence().addControlChange(this.getTick(start + duration), track, channel, 11, 127);
    }

    private int[] getStroke(TGBeat beat, TGBeat previous, int[] stroke) {
        block4: {
            int direction;
            block5: {
                direction = beat.getStroke().getDirection();
                if (previous != null && direction == 0 && previous.getStroke().getDirection() == 0) break block4;
                if (direction != 0) break block5;
                for (int i = 0; i < stroke.length; ++i) {
                    stroke[i] = 0;
                }
                break block4;
            }
            int stringUseds = 0;
            int stringCount = 0;
            for (int vIndex = 0; vIndex < beat.countVoices(); ++vIndex) {
                TGVoice voice = beat.getVoice(vIndex);
                for (int nIndex = 0; nIndex < voice.countNotes(); ++nIndex) {
                    TGNote note = voice.getNote(nIndex);
                    if (note.isTiedNote()) continue;
                    stringUseds |= 1 << note.getString() - 1;
                    ++stringCount;
                }
            }
            if (stringCount <= 0) break block4;
            int strokeMove = 0;
            int strokeIncrement = beat.getStroke().getIncrementTime(beat);
            for (int i = 0; i < stroke.length; ++i) {
                int index;
                int n = index = direction == -1 ? stroke.length - 1 - i : i;
                if ((stringUseds & 1 << index) == 0) continue;
                stroke[index] = strokeMove;
                strokeMove += strokeIncrement;
            }
        }
        return stroke;
    }

    private long applyStrokeStart(TGNote note, long start, int[] stroke) {
        return start + (long)stroke[note.getString() - 1];
    }

    private long applyStrokeDuration(TGNote note, long duration, int[] stroke) {
        return duration > (long)stroke[note.getString() - 1] ? duration - (long)stroke[note.getString() - 1] : duration;
    }

    private MidiTickHelper checkTripletFeel(TGVoice voice, int bIndex) {
        long bStart = voice.getBeat().getStart();
        long bDuration = voice.getDuration().getTime();
        if (voice.getBeat().getMeasure().getTripletFeel() == 2) {
            if (voice.getDuration().isEqual(this.newDuration(8))) {
                TGVoice v;
                if (bStart % 960L == 0L) {
                    TGVoice v2 = this.getNextBeat(voice, bIndex);
                    if (v2 == null || v2.getBeat().getStart() > bStart + voice.getDuration().getTime() || v2.getDuration().isEqual(this.newDuration(8))) {
                        TGDuration duration = this.newDuration(8);
                        duration.getDivision().setEnters(3);
                        duration.getDivision().setTimes(2);
                        bDuration = duration.getTime() * 2L;
                    }
                } else if (bStart % 480L == 0L && ((v = this.getPreviousBeat(voice, bIndex)) == null || v.getBeat().getStart() < bStart - voice.getDuration().getTime() || v.getDuration().isEqual(this.newDuration(8)))) {
                    TGDuration duration = this.newDuration(8);
                    duration.getDivision().setEnters(3);
                    duration.getDivision().setTimes(2);
                    bStart = bStart - voice.getDuration().getTime() + duration.getTime() * 2L;
                    bDuration = duration.getTime();
                }
            }
        } else if (voice.getBeat().getMeasure().getTripletFeel() == 3 && voice.getDuration().isEqual(this.newDuration(16))) {
            TGVoice v;
            if (bStart % 480L == 0L) {
                TGVoice v3 = this.getNextBeat(voice, bIndex);
                if (v3 == null || v3.getBeat().getStart() > bStart + voice.getDuration().getTime() || v3.getDuration().isEqual(this.newDuration(16))) {
                    TGDuration duration = this.newDuration(16);
                    duration.getDivision().setEnters(3);
                    duration.getDivision().setTimes(2);
                    bDuration = duration.getTime() * 2L;
                }
            } else if (bStart % 240L == 0L && ((v = this.getPreviousBeat(voice, bIndex)) == null || v.getBeat().getStart() < bStart - voice.getDuration().getTime() || v.getDuration().isEqual(this.newDuration(16)))) {
                TGDuration duration = this.newDuration(16);
                duration.getDivision().setEnters(3);
                duration.getDivision().setTimes(2);
                bStart = bStart - voice.getDuration().getTime() + duration.getTime() * 2L;
                bDuration = duration.getTime();
            }
        }
        return new MidiTickHelper(bStart, bDuration);
    }

    private TGDuration newDuration(int value) {
        TGDuration duration = this.songManager.getFactory().newDuration();
        duration.setValue(value);
        return duration;
    }

    private TGVoice getPreviousBeat(TGVoice beat, int bIndex) {
        TGVoice previous = null;
        for (int b = bIndex - 1; b >= 0; --b) {
            TGBeat current = beat.getBeat().getMeasure().getBeat(b);
            if (current.getStart() >= beat.getBeat().getStart() || current.getVoice(beat.getIndex()).isEmpty() || previous != null && current.getStart() <= previous.getBeat().getStart()) continue;
            previous = current.getVoice(beat.getIndex());
        }
        return previous;
    }

    private TGVoice getNextBeat(TGVoice beat, int bIndex) {
        TGVoice next = null;
        for (int b = bIndex + 1; b < beat.getBeat().getMeasure().countBeats(); ++b) {
            TGBeat current = beat.getBeat().getMeasure().getBeat(b);
            if (current.getStart() <= beat.getBeat().getStart() || current.getVoice(beat.getIndex()).isEmpty() || next != null && current.getStart() >= next.getBeat().getStart()) continue;
            next = current.getVoice(beat.getIndex());
        }
        return next;
    }

    private MidiNoteHelper getNextNote(MidiSequenceHelper sh, TGNote note, TGTrack track, int mIndex, int bIndex, boolean breakAtRest) {
        int nextBIndex = bIndex + 1;
        int measureCount = sh.getMeasureHelpers().size();
        for (int m = mIndex; m < measureCount; ++m) {
            MidiMeasureHelper mh = sh.getMeasureHelper(m);
            TGMeasure measure = track.getMeasure(mh.getIndex());
            int beatCount = measure.countBeats();
            for (int b = nextBIndex; b < beatCount; ++b) {
                TGBeat beat = measure.getBeat(b);
                TGVoice voice = beat.getVoice(note.getVoice().getIndex());
                if (voice.isEmpty()) continue;
                int noteCount = voice.countNotes();
                for (int n = 0; n < noteCount; ++n) {
                    TGNote nextNote = voice.getNote(n);
                    if (nextNote.getString() != note.getString()) continue;
                    return new MidiNoteHelper(mh, nextNote);
                }
                if (!breakAtRest) continue;
                return null;
            }
            nextBIndex = 0;
        }
        return null;
    }

    private MidiNoteHelper getPreviousNote(MidiSequenceHelper pHelper, TGNote note, TGTrack track, int mIndex, int bIndex, boolean breakAtRest) {
        int nextBIndex = bIndex;
        for (int m = mIndex; m >= 0; --m) {
            MidiMeasureHelper mh = pHelper.getMeasureHelper(m);
            TGMeasure measure = track.getMeasure(mh.getIndex());
            if (this.sHeader == -1 || this.sHeader <= measure.getNumber()) {
                nextBIndex = nextBIndex < 0 ? measure.countBeats() : nextBIndex;
                for (int b = nextBIndex - 1; b >= 0; --b) {
                    TGBeat beat = measure.getBeat(b);
                    TGVoice voice = beat.getVoice(note.getVoice().getIndex());
                    if (voice.isEmpty()) continue;
                    int noteCount = voice.countNotes();
                    for (int n = 0; n < noteCount; ++n) {
                        TGNote current = voice.getNote(n);
                        if (current.getString() != note.getString()) continue;
                        return new MidiNoteHelper(mh, current);
                    }
                    if (!breakAtRest) continue;
                    return null;
                }
            }
            nextBIndex = -1;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MidiSequenceHelper {
        private List<MidiMeasureHelper> measureHeaderHelpers;
        private MidiSequenceHandler sequence;

        public MidiSequenceHelper(MidiSequenceHandler sequence) {
            this.sequence = sequence;
            this.measureHeaderHelpers = new ArrayList<MidiMeasureHelper>();
        }

        public MidiSequenceHandler getSequence() {
            return this.sequence;
        }

        public void addMeasureHelper(MidiMeasureHelper helper) {
            this.measureHeaderHelpers.add(helper);
        }

        public List<MidiMeasureHelper> getMeasureHelpers() {
            return this.measureHeaderHelpers;
        }

        public MidiMeasureHelper getMeasureHelper(int index) {
            return this.measureHeaderHelpers.get(index);
        }
    }

    private class MidiMeasureHelper {
        private int index;
        private long move;

        public MidiMeasureHelper(int index, long move) {
            this.index = index;
            this.move = move;
        }

        public int getIndex() {
            return this.index;
        }

        public long getMove() {
            return this.move;
        }
    }

    private class MidiNoteHelper {
        private MidiMeasureHelper measure;
        private TGNote note;

        public MidiNoteHelper(MidiMeasureHelper measure, TGNote note) {
            this.measure = measure;
            this.note = note;
        }

        public MidiMeasureHelper getMeasure() {
            return this.measure;
        }

        public TGNote getNote() {
            return this.note;
        }
    }

    private class MidiTickHelper {
        private long start;
        private long duration;

        public MidiTickHelper(long start, long duration) {
            this.start = start;
            this.duration = duration;
        }

        public long getDuration() {
            return this.duration;
        }

        public long getStart() {
            return this.start;
        }
    }
}

