package org.herac.tuxguitar.android.view.dialog.repeat;

import org.herac.tuxguitar.android.R;
import org.herac.tuxguitar.android.view.dialog.TGDialog;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.composition.TGRepeatCloseAction;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;

public class TGRepeatCloseDialog extends TGDialog {

	public TGRepeatCloseDialog() {
		super();
	}
	
	@SuppressLint("InflateParams")
	public Dialog onCreateDialog() {
		View view = getActivity().getLayoutInflater().inflate(R.layout.view_repeat_close, null);
		
		final TGSong song = getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
		final TGMeasureHeader header = getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
		
		int repeatCloseDefault = header.getRepeatClose();
		if( repeatCloseDefault < 1 ) {
			repeatCloseDefault = 1;
		}
		
		ArrayAdapter<Integer> repeatValues = new ArrayAdapter<Integer>(getActivity(), android.R.layout.simple_spinner_item, createRepeatValues());
		
		final Spinner spinner = (Spinner) view.findViewById(R.id.repeat_close_dlg_count_value);
		spinner.setAdapter(repeatValues);
		spinner.setSelection(repeatValues.getPosition(Integer.valueOf(repeatCloseDefault)));
		
		AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
		builder.setTitle(R.string.repeat_close_dlg_title);
		builder.setView(view);
		builder.setPositiveButton(R.string.global_button_ok, new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int id) {
				changeRepeatClose(song, header, parseRepeatValue(spinner));
				dialog.dismiss();
			}
		});
		builder.setNegativeButton(R.string.global_button_cancel, new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int id) {
				dialog.dismiss();
			}
		});
		
		return builder.create();
	}
	
	public Integer[] createRepeatValues() {
		Integer[] items = new Integer[101];
		for (int i = 0; i < items.length; i++) {
			items[i] = Integer.valueOf(i);
		}
		return items;
	}
	
	public int parseRepeatValue(Spinner spinner) {
		return ((Integer)spinner.getSelectedItem()).intValue();
	}
	
	public void updateRadio(RadioButton button, Integer value, Integer selection) {
		button.setTag(Integer.valueOf(value));
		button.setChecked(selection != null && selection.equals(value));
	}

	public Integer parseApplyTo(RadioGroup radioGroup, Integer defaultValue) {
		int radioButtonId = radioGroup.getCheckedRadioButtonId();
		if( radioButtonId != -1 ) {
			RadioButton radioButton = (RadioButton) radioGroup.findViewById(radioButtonId);
			if( radioButton != null ) {
				return ((Integer)radioButton.getTag()).intValue();
			}
		}
		return defaultValue;
	}
	
	public void changeRepeatClose(TGSong song, TGMeasureHeader header, Integer repeatCount) {
		TGActionProcessor tgActionProcessor = new TGActionProcessor(findContext(), TGRepeatCloseAction.NAME);
		tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
		tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
		tgActionProcessor.setAttribute(TGRepeatCloseAction.ATTRIBUTE_REPEAT_COUNT, repeatCount);
		tgActionProcessor.processOnNewThread();
	}
}
