/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.base.TGInputStreamBase;
import org.herac.tuxguitar.io.gtp.GTPFileFormat;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.factory.TGFactory;

public abstract class GTPInputStream
extends GTPFileFormat
implements TGInputStreamBase {
    private int versionIndex;
    private String version;
    private String[] versions;
    private InputStream stream;

    public GTPInputStream(GTPSettings settings, String[] versions) {
        super(settings);
        this.versions = versions;
    }

    public void init(TGFactory factory, InputStream stream) {
        super.init(factory);
        this.stream = stream;
        this.version = null;
    }

    protected String getVersion() {
        return this.version;
    }

    protected int getVersionIndex() {
        return this.versionIndex;
    }

    public boolean isSupportedVersion(String version) {
        for (int i = 0; i < this.versions.length; ++i) {
            if (!version.equals(this.versions[i])) continue;
            this.versionIndex = i;
            return true;
        }
        return false;
    }

    public boolean isSupportedVersion() {
        try {
            this.readVersion();
            return this.isSupportedVersion(this.getVersion());
        }
        catch (Exception e) {
            return false;
        }
        catch (Error e) {
            return false;
        }
    }

    protected void readVersion() {
        try {
            if (this.version == null) {
                this.version = this.readStringByte(30, "UTF-8");
            }
        }
        catch (IOException e) {
            this.version = "NOT_SUPPORTED";
        }
    }

    protected int read() throws IOException {
        return this.stream.read();
    }

    protected int read(byte[] bytes) throws IOException {
        return this.stream.read(bytes);
    }

    protected int read(byte[] bytes, int off, int len) throws IOException {
        return this.stream.read(bytes, off, len);
    }

    protected void skip(int bytes) throws IOException {
        this.stream.read(new byte[bytes]);
    }

    protected int readUnsignedByte() throws IOException {
        return this.stream.read() & 0xFF;
    }

    protected byte readByte() throws IOException {
        return (byte)this.stream.read();
    }

    protected boolean readBoolean() throws IOException {
        return this.stream.read() == 1;
    }

    protected int readInt() throws IOException {
        byte[] bytes = new byte[4];
        this.stream.read(bytes);
        return (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
    }

    protected long readLong() throws IOException {
        byte[] bytes = new byte[8];
        this.stream.read(bytes);
        return (long)(bytes[7] & 0xFF) << 56 | (long)(bytes[6] & 0xFF) << 48 | (long)(bytes[5] & 0xFF) << 40 | (long)(bytes[4] & 0xFF) << 32 | (long)(bytes[3] & 0xFF) << 24 | (long)(bytes[2] & 0xFF) << 16 | (long)(bytes[1] & 0xFF) << 8 | (long)(bytes[0] & 0xFF);
    }

    protected String readString(int size, int len, String charset) throws IOException {
        byte[] bytes = new byte[size > 0 ? size : len];
        this.stream.read(bytes);
        return this.newString(bytes, len >= 0 && len <= bytes.length ? len : size, charset);
    }

    protected String readString(int length, String charset) throws IOException {
        return this.readString(length, length, charset);
    }

    protected String readString(int length) throws IOException {
        return this.readString(length, this.getSettings().getCharset());
    }

    protected String readStringInteger(String charset) throws IOException {
        return this.readString(this.readInt(), charset);
    }

    protected String readStringInteger() throws IOException {
        return this.readStringInteger(this.getSettings().getCharset());
    }

    protected String readStringByte(int size, String charset) throws IOException {
        return this.readString(size, this.readUnsignedByte(), charset);
    }

    protected String readStringByte(int size) throws IOException {
        return this.readStringByte(size, this.getSettings().getCharset());
    }

    protected String readStringByteSizeOfByte(String charset) throws IOException {
        return this.readStringByte(this.readUnsignedByte() - 1, charset);
    }

    protected String readStringByteSizeOfByte() throws IOException {
        return this.readStringByteSizeOfByte(this.getSettings().getCharset());
    }

    protected String readStringByteSizeOfInteger(String charset) throws IOException {
        return this.readStringByte(this.readInt() - 1, charset);
    }

    protected String readStringByteSizeOfInteger() throws IOException {
        return this.readStringByteSizeOfInteger(this.getSettings().getCharset());
    }

    private String newString(byte[] bytes, int length, String charset) {
        try {
            return new String(new String(bytes, 0, length, charset).getBytes("UTF-8"), "UTF-8");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new String(bytes, 0, length);
        }
    }

    protected void close() throws IOException {
        this.stream.close();
    }
}

