/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;

public class TGToolBarSectionComposition
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 8);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionComposition.this.createMenu(toolBar, (ToolItem)event.widget);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("composition"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getCompositionTimeSignature());
    }

    public void updateItems(TGToolBar toolBar) {
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        TGMeasureImpl measure = toolBar.getTablature().getCaret().getMeasure();
        Menu menu = new Menu((Control)item.getParent().getShell());
        MenuItem tempo = new MenuItem(menu, 8);
        tempo.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-tempo-dialog"));
        tempo.setEnabled(!running);
        tempo.setText(toolBar.getText("composition.tempo"));
        tempo.setImage(toolBar.getIconManager().getCompositionTempo());
        MenuItem timeSignature = new MenuItem(menu, 8);
        timeSignature.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-time-signature-dialog"));
        timeSignature.setEnabled(!running);
        timeSignature.setText(toolBar.getText("composition.timesignature"));
        timeSignature.setImage(toolBar.getIconManager().getCompositionTimeSignature());
        new MenuItem(menu, 2);
        MenuItem repeatOpen = new MenuItem(menu, 8);
        repeatOpen.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.insert.open-repeat"));
        repeatOpen.setEnabled(!running);
        repeatOpen.setText(toolBar.getText("repeat.open", measure != null && measure.isRepeatOpen()));
        repeatOpen.setImage(toolBar.getIconManager().getCompositionRepeatOpen());
        MenuItem repeatClose = new MenuItem(menu, 8);
        repeatClose.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-repeat-close-dialog"));
        repeatClose.setEnabled(!running);
        repeatClose.setText(toolBar.getText("repeat.close", measure != null && measure.getRepeatClose() > 0));
        repeatClose.setImage(toolBar.getIconManager().getCompositionRepeatClose());
        MenuItem repeatAlternative = new MenuItem(menu, 8);
        repeatAlternative.addSelectionListener((SelectionListener)toolBar.createActionProcessor("action.gui.open-repeat-alternative-dialog"));
        repeatAlternative.setEnabled(!running);
        repeatAlternative.setText(toolBar.getText("repeat.alternative", measure != null && measure.getHeader().getRepeatAlternative() > 0));
        repeatAlternative.setImage(toolBar.getIconManager().getCompositionRepeatAlternative());
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }
}

