/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.dialog.chord.TGCustomChordManager;
import org.herac.tuxguitar.app.view.toolbar.TGToolBar;
import org.herac.tuxguitar.app.view.toolbar.TGToolBarSection;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.util.TGContext;

public class TGToolBarSectionChord
implements TGToolBarSection {
    private ToolItem menuItem;

    public void createSection(final TGToolBar toolBar) {
        this.menuItem = new ToolItem(toolBar.getControl(), 4);
        this.menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGToolBarSectionChord.this.processItemSelection(toolBar, event);
            }
        });
        this.loadIcons(toolBar);
        this.loadProperties(toolBar);
    }

    public void loadProperties(TGToolBar toolBar) {
        this.menuItem.setToolTipText(toolBar.getText("insert.chord"));
    }

    public void loadIcons(TGToolBar toolBar) {
        this.menuItem.setImage(toolBar.getIconManager().getChord());
    }

    public void updateItems(TGToolBar toolBar) {
        boolean running = MidiPlayer.getInstance((TGContext)toolBar.getContext()).isRunning();
        this.menuItem.setEnabled(!running);
    }

    public void processItemSelection(TGToolBar toolBar, SelectionEvent event) {
        if (event.detail == 4) {
            this.createMenu(toolBar, (ToolItem)event.widget);
        } else {
            toolBar.createActionProcessor("action.gui.open-chord-dialog").process();
        }
    }

    public void createMenu(TGToolBar toolBar, ToolItem item) {
        Rectangle rect = item.getBounds();
        Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
        Menu menu = new Menu((Control)item.getParent().getShell());
        TGCustomChordManager customChordManager = TuxGuitar.getInstance().getCustomChordManager();
        for (int i = 0; i < customChordManager.countChords(); ++i) {
            TGChord chord = TuxGuitar.getInstance().getCustomChordManager().getChord(i);
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(chord.getName());
            menuItem.addSelectionListener((SelectionListener)this.createInsertChordAction(toolBar, chord));
        }
        menu.setLocation(pt.x, pt.y + rect.height);
        menu.setVisible(true);
    }

    public TGActionProcessorListener createInsertChordAction(TGToolBar toolBar, TGChord chord) {
        TGActionProcessorListener tgActionProcessor = toolBar.createActionProcessor("action.beat.general.insert-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHORD, chord);
        return tgActionProcessor;
    }
}

