/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.TGCustomTool;
import org.herac.tuxguitar.app.tools.custom.TGCustomToolManager;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;

public class ToolMenuItem
extends TGMenuItem {
    private MenuItem settingsMenuItem;
    private Menu menu;
    private MenuItem scale;
    private MenuItem browser;
    private MenuItem transpose;
    private MenuItem plugins;
    private MenuItem config;
    private MenuItem keyBindings;

    public ToolMenuItem(Shell shell, Menu parent, int style) {
        this.settingsMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.transpose = new MenuItem(this.menu, 8);
        this.transpose.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-transpose-dialog"));
        this.scale = new MenuItem(this.menu, 8);
        this.scale.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-scale-dialog"));
        this.browser = new MenuItem(this.menu, 8);
        this.browser.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.toggle-browser-dialog"));
        Iterator<TGCustomTool> it = TGCustomToolManager.instance().getCustomTools();
        while (it.hasNext()) {
            TGCustomTool tool = it.next();
            MenuItem menuItem = new MenuItem(this.menu, 8);
            menuItem.setText(tool.getName());
            menuItem.addSelectionListener((SelectionListener)this.createActionProcessor(tool.getAction()));
        }
        new MenuItem(this.menu, 2);
        this.plugins = new MenuItem(this.menu, 8);
        this.plugins.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-plugin-list-dialog"));
        this.keyBindings = new MenuItem(this.menu, 8);
        this.keyBindings.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-key-binding-editor"));
        this.config = new MenuItem(this.menu, 8);
        this.config.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-settings-editor"));
        this.settingsMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.settingsMenuItem, "tools", null);
        this.setMenuItemTextAndAccelerator(this.transpose, "tools.transpose", "action.gui.open-transpose-dialog");
        this.setMenuItemTextAndAccelerator(this.scale, "tools.scale", "action.gui.open-scale-dialog");
        this.setMenuItemTextAndAccelerator(this.browser, "tools.browser", "action.gui.toggle-browser-dialog");
        this.setMenuItemTextAndAccelerator(this.plugins, "tools.plugins", "action.gui.open-plugin-list-dialog");
        this.setMenuItemTextAndAccelerator(this.keyBindings, "tools.shortcuts", "action.gui.open-key-binding-editor");
        this.setMenuItemTextAndAccelerator(this.config, "tools.settings", "action.gui.open-settings-editor");
    }

    public void loadIcons() {
    }

    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.transpose.setEnabled(!running);
    }
}

