/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.action.impl.file.TGExportFileAction;
import org.herac.tuxguitar.app.action.impl.file.TGExportSongAction;
import org.herac.tuxguitar.app.action.impl.file.TGImportFileAction;
import org.herac.tuxguitar.app.action.impl.file.TGImportSongAction;
import org.herac.tuxguitar.app.action.impl.file.TGReadURLAction;
import org.herac.tuxguitar.app.helper.TGFileHistory;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.editor.action.file.TGLoadTemplateAction;
import org.herac.tuxguitar.editor.template.TGTemplate;
import org.herac.tuxguitar.editor.template.TGTemplateManager;
import org.herac.tuxguitar.io.base.TGLocalFileExporter;
import org.herac.tuxguitar.io.base.TGLocalFileImporter;
import org.herac.tuxguitar.io.base.TGRawExporter;
import org.herac.tuxguitar.io.base.TGRawImporter;
import org.herac.tuxguitar.util.TGContext;

public class FileMenuItem
extends TGMenuItem {
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu newSongMenu;
    private Menu importMenu;
    private Menu exportMenu;
    private Menu historyMenu;
    private MenuItem newSong;
    private MenuItem newSongDefault;
    private MenuItem open;
    private MenuItem openURL;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem close;
    private MenuItem closeOthers;
    private MenuItem closeAll;
    private MenuItem importItem;
    private MenuItem exportItem;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem historyItem;
    private MenuItem[] historyFiles;
    private MenuItem exit;
    private List<MenuItem> importItems;
    private List<MenuItem> exportItems;

    public FileMenuItem(Shell shell, Menu parent, int style) {
        this.fileMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
        this.importItems = new ArrayList<MenuItem>();
        this.exportItems = new ArrayList<MenuItem>();
    }

    public void showItems() {
        this.newSong = new MenuItem(this.menu, 64);
        this.newSongMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.newSongDefault = new MenuItem(this.newSongMenu, 8);
        this.newSongDefault.addSelectionListener((SelectionListener)this.createNewSongFromTemplateActionProcessor(null));
        this.addNewSongTemplates();
        this.open = new MenuItem(this.menu, 8);
        this.open.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.open"));
        this.openURL = new MenuItem(this.menu, 8);
        this.openURL.addSelectionListener((SelectionListener)this.createActionProcessor("action.gui.open-url-dialog"));
        new MenuItem(this.menu, 2);
        this.close = new MenuItem(this.menu, 8);
        this.close.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.close-current"));
        this.closeOthers = new MenuItem(this.menu, 8);
        this.closeOthers.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.close-others"));
        this.closeAll = new MenuItem(this.menu, 8);
        this.closeAll.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.close-all"));
        new MenuItem(this.menu, 2);
        this.save = new MenuItem(this.menu, 8);
        this.save.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.save"));
        this.saveAs = new MenuItem(this.menu, 8);
        this.saveAs.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.save-as"));
        int countImporters = TuxGuitar.getInstance().getFileFormatManager().countImporters();
        int countExporters = TuxGuitar.getInstance().getFileFormatManager().countExporters();
        if (countImporters + countExporters > 0) {
            new MenuItem(this.menu, 2);
            this.importItems.clear();
            if (countImporters > 0) {
                this.importItem = new MenuItem(this.menu, 64);
                this.importMenu = new Menu((Decorations)this.menu.getShell(), 4);
                this.addImporters();
            }
            this.exportItems.clear();
            if (countExporters > 0) {
                this.exportItem = new MenuItem(this.menu, 64);
                this.exportMenu = new Menu((Decorations)this.menu.getShell(), 4);
                this.addExporters();
            }
        }
        new MenuItem(this.menu, 2);
        this.printPreview = new MenuItem(this.menu, 8);
        this.printPreview.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.print-preview"));
        this.print = new MenuItem(this.menu, 8);
        this.print.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.print"));
        new MenuItem(this.menu, 2);
        this.historyItem = new MenuItem(this.menu, 64);
        this.historyMenu = new Menu((Decorations)this.menu.getShell(), 4);
        this.updateHistoryFiles();
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener((SelectionListener)this.createActionProcessor("action.file.exit"));
        if (this.importItem != null) {
            this.importItem.setMenu(this.importMenu);
        }
        if (this.exportItem != null) {
            this.exportItem.setMenu(this.exportMenu);
        }
        this.newSong.setMenu(this.newSongMenu);
        this.historyItem.setMenu(this.historyMenu);
        this.fileMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    private void addNewSongTemplates() {
        TGTemplateManager templateManager = TGTemplateManager.getInstance((TGContext)this.findContext());
        if (templateManager.countTemplates() > 0) {
            new MenuItem(this.newSongMenu, 2);
            Iterator it = templateManager.getTemplates();
            while (it.hasNext()) {
                TGTemplate tgTemplate = (TGTemplate)it.next();
                MenuItem menuItem = new MenuItem(this.newSongMenu, 8);
                menuItem.setText(tgTemplate.getName());
                menuItem.addSelectionListener((SelectionListener)this.createNewSongFromTemplateActionProcessor(tgTemplate));
            }
        }
    }

    private void addImporters() {
        MenuItem item;
        TGLocalFileImporter importer;
        int i;
        ArrayList<TGRawImporter> importersRaw = new ArrayList<TGRawImporter>();
        ArrayList<TGLocalFileImporter> importersFile = new ArrayList<TGLocalFileImporter>();
        Iterator importers = TuxGuitar.getInstance().getFileFormatManager().getImporters();
        while (importers.hasNext()) {
            TGRawImporter importer2 = (TGRawImporter)importers.next();
            if (importer2 instanceof TGLocalFileImporter) {
                importersFile.add((TGLocalFileImporter)importer2);
                continue;
            }
            importersRaw.add(importer2);
        }
        for (i = 0; i < importersFile.size(); ++i) {
            importer = (TGLocalFileImporter)importersFile.get(i);
            item = new MenuItem(this.importMenu, 8);
            item.setData((Object)importer);
            item.addSelectionListener((SelectionListener)this.createImportFileActionProcessor(importer));
            this.importItems.add(item);
        }
        if (!importersFile.isEmpty() && !importersRaw.isEmpty()) {
            new MenuItem(this.importMenu, 2);
        }
        for (i = 0; i < importersRaw.size(); ++i) {
            importer = (TGRawImporter)importersRaw.get(i);
            item = new MenuItem(this.importMenu, 8);
            item.setData((Object)importer);
            item.addSelectionListener((SelectionListener)this.createImportSongActionProcessor((TGRawImporter)importer));
            this.importItems.add(item);
        }
    }

    private void addExporters() {
        MenuItem item;
        TGLocalFileExporter exporter;
        int i;
        ArrayList<TGRawExporter> exportersRaw = new ArrayList<TGRawExporter>();
        ArrayList<TGLocalFileExporter> exportersFile = new ArrayList<TGLocalFileExporter>();
        Iterator exporters = TuxGuitar.getInstance().getFileFormatManager().getExporters();
        while (exporters.hasNext()) {
            TGRawExporter exporter2 = (TGRawExporter)exporters.next();
            if (exporter2 instanceof TGLocalFileExporter) {
                exportersFile.add((TGLocalFileExporter)exporter2);
                continue;
            }
            exportersRaw.add(exporter2);
        }
        for (i = 0; i < exportersFile.size(); ++i) {
            exporter = (TGLocalFileExporter)exportersFile.get(i);
            item = new MenuItem(this.exportMenu, 8);
            item.setData((Object)exporter);
            item.addSelectionListener((SelectionListener)this.createExportFileActionProcessor(exporter));
            this.exportItems.add(item);
        }
        if (!exportersFile.isEmpty() && !exportersRaw.isEmpty()) {
            new MenuItem(this.exportMenu, 2);
        }
        for (i = 0; i < exportersRaw.size(); ++i) {
            exporter = (TGRawExporter)exportersRaw.get(i);
            item = new MenuItem(this.exportMenu, 8);
            item.setData((Object)exporter);
            item.addSelectionListener((SelectionListener)this.createExportSongActionProcessor((TGRawExporter)exporter));
            this.exportItems.add(item);
        }
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List<URL> urls = TGFileHistory.getInstance(this.findContext()).getURLs();
        this.historyFiles = new MenuItem[urls.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            URL url = urls.get(i);
            this.historyFiles[i] = new MenuItem(this.historyMenu, 8);
            this.historyFiles[i].setText(this.decode(url.toString()));
            this.historyFiles[i].addSelectionListener((SelectionListener)this.createOpenUrlActionProcessor(url));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    public TGActionProcessorListener createOpenUrlActionProcessor(URL url) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.url.read");
        tgActionProcessorListener.setAttribute(TGReadURLAction.ATTRIBUTE_URL, url);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createNewSongFromTemplateActionProcessor(TGTemplate template) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.new-from-template");
        tgActionProcessorListener.setAttribute(TGLoadTemplateAction.ATTRIBUTE_TEMPLATE, template);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createImportFileActionProcessor(TGLocalFileImporter importer) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.file.import");
        tgActionProcessorListener.setAttribute(TGImportFileAction.ATTRIBUTE_PROVIDER, importer);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createImportSongActionProcessor(TGRawImporter importer) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.import");
        tgActionProcessorListener.setAttribute(TGImportSongAction.ATTRIBUTE_PROVIDER, importer);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createExportFileActionProcessor(TGLocalFileExporter exporter) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.file.export");
        tgActionProcessorListener.setAttribute(TGExportFileAction.ATTRIBUTE_PROVIDER, exporter);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createExportSongActionProcessor(TGRawExporter exporter) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.export");
        tgActionProcessorListener.setAttribute(TGExportSongAction.ATTRIBUTE_PROVIDER, exporter);
        return tgActionProcessorListener;
    }

    private String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }

    public void update() {
        TGFileHistory fileHistory = TGFileHistory.getInstance(this.findContext());
        if (fileHistory.isChanged()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            fileHistory.setChanged(false);
        }
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.fileMenuItem, "file", null);
        this.setMenuItemTextAndAccelerator(this.newSong, "file.new", null);
        this.setMenuItemTextAndAccelerator(this.newSongDefault, "file.new-song.default-template", "action.song.new-from-template");
        this.setMenuItemTextAndAccelerator(this.open, "file.open", "action.file.open");
        this.setMenuItemTextAndAccelerator(this.openURL, "file.open-url", "action.gui.open-url-dialog");
        this.setMenuItemTextAndAccelerator(this.close, "file.close", "action.file.close-current");
        this.setMenuItemTextAndAccelerator(this.closeOthers, "file.close-others", "action.file.close-others");
        this.setMenuItemTextAndAccelerator(this.closeAll, "file.close-all", "action.file.close-all");
        this.setMenuItemTextAndAccelerator(this.save, "file.save", "action.file.save");
        this.setMenuItemTextAndAccelerator(this.saveAs, "file.save-as", "action.file.save-as");
        this.setMenuItemTextAndAccelerator(this.printPreview, "file.print-preview", "action.file.print-preview");
        this.setMenuItemTextAndAccelerator(this.print, "file.print", "action.file.print");
        this.setMenuItemTextAndAccelerator(this.historyItem, "file.history", null);
        this.setMenuItemTextAndAccelerator(this.exit, "file.exit", "action.file.exit");
        if (this.importItem != null) {
            this.setMenuItemTextAndAccelerator(this.importItem, "file.import", "action.file.import");
            for (MenuItem item : this.importItems) {
                TGRawImporter itemImporter = (TGRawImporter)item.getData();
                if (itemImporter instanceof TGLocalFileImporter) {
                    item.setText(TuxGuitar.getProperty("file.import") + " " + itemImporter.getImportName());
                    continue;
                }
                item.setText(itemImporter.getImportName());
            }
        }
        if (this.exportItem != null) {
            this.setMenuItemTextAndAccelerator(this.exportItem, "file.export", "action.file.export");
            for (MenuItem item : this.exportItems) {
                TGRawExporter itemExporter = (TGRawExporter)item.getData();
                if (itemExporter instanceof TGLocalFileExporter) {
                    item.setText(TuxGuitar.getProperty("file.export") + " " + itemExporter.getExportName());
                    continue;
                }
                item.setText(itemExporter.getExportName());
            }
        }
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.getInstance().getIconManager().getFileNew());
        this.open.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        this.save.setImage(TuxGuitar.getInstance().getIconManager().getFileSave());
        this.saveAs.setImage(TuxGuitar.getInstance().getIconManager().getFileSaveAs());
        this.printPreview.setImage(TuxGuitar.getInstance().getIconManager().getFilePrintPreview());
        this.print.setImage(TuxGuitar.getInstance().getIconManager().getFilePrint());
    }
}

