/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;

public class EditMenuItem
extends TGMenuItem {
    private MenuItem editMenuItem;
    private Menu menu;
    private MenuItem undo;
    private MenuItem redo;
    private MenuItem modeSelection;
    private MenuItem modeEdition;
    private MenuItem notNaturalKey;
    private MenuItem voice1;
    private MenuItem voice2;

    public EditMenuItem(Shell shell, Menu parent, int style) {
        this.editMenuItem = new MenuItem(parent, style);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.undo = new MenuItem(this.menu, 8);
        this.undo.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.undo"));
        this.redo = new MenuItem(this.menu, 8);
        this.redo.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.redo"));
        new MenuItem(this.menu, 2);
        this.modeSelection = new MenuItem(this.menu, 16);
        this.modeSelection.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-selection"));
        this.modeEdition = new MenuItem(this.menu, 16);
        this.modeEdition.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = new MenuItem(this.menu, 32);
        this.notNaturalKey.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.set-natural-key"));
        new MenuItem(this.menu, 2);
        this.voice1 = new MenuItem(this.menu, 16);
        this.voice1.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.voice-1"));
        this.voice2 = new MenuItem(this.menu, 16);
        this.voice2.addSelectionListener((SelectionListener)this.createActionProcessor("action.edit.voice-2"));
        this.editMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        EditorKit kit = TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.undo.setEnabled(!running && TuxGuitar.getInstance().getUndoableManager().canUndo());
        this.redo.setEnabled(!running && TuxGuitar.getInstance().getUndoableManager().canRedo());
        this.modeSelection.setSelection(kit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!running);
        this.modeEdition.setSelection(kit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!running);
        this.notNaturalKey.setSelection(!kit.isNatural());
        this.notNaturalKey.setEnabled(!running && kit.getMouseMode() == 2);
        this.voice1.setSelection(kit.getTablature().getCaret().getVoice() == 0);
        this.voice2.setSelection(kit.getTablature().getCaret().getVoice() == 1);
    }

    public void loadProperties() {
        this.setMenuItemTextAndAccelerator(this.editMenuItem, "edit.menu", null);
        this.setMenuItemTextAndAccelerator(this.undo, "edit.undo", "action.edit.undo");
        this.setMenuItemTextAndAccelerator(this.redo, "edit.redo", "action.edit.redo");
        this.setMenuItemTextAndAccelerator(this.modeSelection, "edit.mouse-mode-selection", "action.edit.set-mouse-mode-selection");
        this.setMenuItemTextAndAccelerator(this.modeEdition, "edit.mouse-mode-edition", "action.edit.set-mouse-mode-edition");
        this.setMenuItemTextAndAccelerator(this.notNaturalKey, "edit.not-natural-key", "action.edit.set-natural-key");
        this.setMenuItemTextAndAccelerator(this.voice1, "edit.voice-1", "action.edit.voice-1");
        this.setMenuItemTextAndAccelerator(this.voice2, "edit.voice-2", "action.edit.voice-2");
    }

    public void loadIcons() {
        this.undo.setImage(TuxGuitar.getInstance().getIconManager().getEditUndo());
        this.redo.setImage(TuxGuitar.getInstance().getIconManager().getEditRedo());
    }
}

