/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.transpose;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;

public class TGTransposeDialog {
    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        final int[] transpositions = new int[25];
        for (int i = 0; i < transpositions.length; ++i) {
            transpositions[i] = i - transpositions.length / 2;
        }
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("tools.transpose"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("tools.transpose"));
        Label transpositionLabel = new Label((Composite)group, 0);
        transpositionLabel.setText(TuxGuitar.getProperty("tools.transpose.semitones"));
        transpositionLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        final Combo transpositionCombo = new Combo((Composite)group, 12);
        transpositionCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < transpositions.length; ++i) {
            transpositionCombo.add(Integer.toString(transpositions[i]));
        }
        transpositionCombo.select(transpositions.length / 2);
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)new GridData(4, 4, true, true));
        options.setText(TuxGuitar.getProperty("options"));
        final Button applyToAllMeasuresButton = new Button((Composite)options, 16);
        applyToAllMeasuresButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-track"));
        applyToAllMeasuresButton.setSelection(true);
        Button applyToCurrentMeasureButton = new Button((Composite)options, 16);
        applyToCurrentMeasureButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-measure"));
        final Button applyToAllTracksButton = new Button((Composite)options, 32);
        applyToAllTracksButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-all-tracks"));
        applyToAllTracksButton.setSelection(true);
        final Button applyToChordsButton = new Button((Composite)options, 32);
        applyToChordsButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-chords"));
        applyToChordsButton.setSelection(true);
        final Button tryKeepStringButton = new Button((Composite)options, 32);
        tryKeepStringButton.setText(TuxGuitar.getProperty("tools.transpose.try-keep-strings"));
        tryKeepStringButton.setSelection(true);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int transpositionIndex = transpositionCombo.getSelectionIndex();
                if (transpositionIndex >= 0 && transpositionIndex < transpositions.length) {
                    int transposition = transpositions[transpositionIndex];
                    boolean tryKeepString = tryKeepStringButton.getSelection();
                    boolean applyToChords = applyToChordsButton.getSelection();
                    boolean applyToAllTracks = applyToAllTracksButton.getSelection();
                    boolean applyToAllMeasures = applyToAllMeasuresButton.getSelection();
                    TGTransposeDialog.this.transposeNotes(context, transposition, tryKeepString, applyToChords, applyToAllMeasures, applyToAllTracks);
                }
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void transposeNotes(TGViewContext context, int transposition, boolean tryKeepString, boolean applyToChords, boolean applyToAllMeasures, boolean applyToAllTracks) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context.getContext(), "action.tools.transpose-notes");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG));
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK));
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE));
        tgActionProcessor.setAttribute("transposition", (Object)transposition);
        tgActionProcessor.setAttribute("tryKeepString", (Object)tryKeepString);
        tgActionProcessor.setAttribute("applyToChords", (Object)applyToChords);
        tgActionProcessor.setAttribute("applyToAllTracks", (Object)applyToAllTracks);
        tgActionProcessor.setAttribute("applyToAllMeasures", (Object)applyToAllMeasures);
        tgActionProcessor.processOnNewThread();
    }
}

