/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.transport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGTransportModeDialog
extends SelectionAdapter {
    protected static final int MIN_SELECTION = 1;
    protected static final int MAX_SELECTION = 500;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};
    private TGViewContext context;
    protected Button simple;
    protected Button simpleLoop;
    protected Combo simplePercent;
    protected Button custom;
    protected Spinner customFrom;
    protected Spinner customTo;
    protected Spinner customIncrement;
    protected MHeaderCombo loopSHeader;
    protected MHeaderCombo loopEHeader;

    public TGTransportModeDialog(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        MidiPlayerMode mode = MidiPlayer.getInstance((TGContext)this.context.getContext()).getMode();
        Shell parent = (Shell)this.context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("transport.mode"));
        Composite radios = new Composite((Composite)dialog, 0);
        radios.setLayout((Layout)new GridLayout());
        radios.setLayoutData((Object)this.getMainData());
        this.simple = new Button(radios, 16);
        this.simple.setText(TuxGuitar.getProperty("transport.mode.simple"));
        this.simple.setSelection(mode.getType() == 1);
        RadioSelectionAdapter simpleAdapter = new RadioSelectionAdapter(this.simple);
        Group simpleGroup = new Group(radios, 16);
        simpleGroup.setLayout((Layout)new GridLayout(2, false));
        simpleGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        simpleGroup.setText(TuxGuitar.getProperty("transport.mode.simple"));
        simpleAdapter.addControl((Control)simpleGroup);
        simpleAdapter.addControl((Control)this.makeLabel((Composite)simpleGroup, TuxGuitar.getProperty("transport.mode.simple.tempo-percent"), 16384, 1));
        this.simplePercent = new Combo((Composite)simpleGroup, 12);
        this.simplePercent.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < DEFAULT_PERCENTS.length; ++i) {
            this.simplePercent.add(Integer.toString(DEFAULT_PERCENTS[i]) + "%", i);
            if (mode.getSimplePercent() != DEFAULT_PERCENTS[i]) continue;
            this.simplePercent.select(i);
        }
        simpleAdapter.addControl((Control)this.simplePercent);
        this.simpleLoop = new Button((Composite)simpleGroup, 32);
        this.simpleLoop.setText(TuxGuitar.getProperty("transport.mode.simple.loop"));
        this.simpleLoop.setSelection(mode.isLoop());
        simpleAdapter.addControl((Control)this.simpleLoop);
        GridData loopedData = new GridData(4, 4, true, true);
        loopedData.horizontalSpan = 2;
        this.simpleLoop.setLayoutData((Object)loopedData);
        this.custom = new Button(radios, 16);
        this.custom.setText(TuxGuitar.getProperty("transport.mode.trainer"));
        this.custom.setSelection(mode.getType() == 2);
        RadioSelectionAdapter customAdapter = new RadioSelectionAdapter(this.custom);
        Group trainerGroup = new Group(radios, 16);
        trainerGroup.setLayout((Layout)new GridLayout(6, false));
        trainerGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        trainerGroup.setText(TuxGuitar.getProperty("transport.mode.trainer"));
        customAdapter.addControl((Control)trainerGroup);
        customAdapter.addControl((Control)this.makeLabel((Composite)trainerGroup, TuxGuitar.getProperty("composition.tempo"), 16384, 1));
        this.customFrom = new Spinner((Composite)trainerGroup, 2048);
        this.customFrom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customFrom.setMinimum(1);
        this.customFrom.setMaximum(500);
        this.customFrom.setSelection(mode.getCustomPercentFrom());
        customAdapter.addControl((Control)this.customFrom);
        customAdapter.addControl((Control)this.makeLabel((Composite)trainerGroup, "%", 16384, 1));
        customAdapter.addControl((Control)this.makeLabel((Composite)trainerGroup, TuxGuitar.getProperty("edit.to"), 131072, 1));
        this.customTo = new Spinner((Composite)trainerGroup, 2048);
        this.customTo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customTo.setMinimum(1);
        this.customTo.setMaximum(500);
        this.customTo.setSelection(mode.getCustomPercentTo());
        customAdapter.addControl((Control)this.customTo);
        customAdapter.addControl((Control)this.makeLabel((Composite)trainerGroup, "%", 16384, 1));
        customAdapter.addControl((Control)this.makeLabel((Composite)trainerGroup, TuxGuitar.getProperty("transport.mode.trainer.increment-description"), 16384, 4));
        this.customIncrement = new Spinner((Composite)trainerGroup, 2048);
        this.customIncrement.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customIncrement.setMinimum(1);
        this.customIncrement.setMaximum(500);
        this.customIncrement.setSelection(mode.getCustomPercentIncrement());
        customAdapter.addControl((Control)this.customIncrement);
        customAdapter.addControl((Control)this.makeLabel((Composite)trainerGroup, "%", 16384, 1));
        SpinnerSelectionAdapter spinnerAdapter = new SpinnerSelectionAdapter(this.customFrom, this.customTo, this.customIncrement);
        this.customFrom.addSelectionListener((SelectionListener)spinnerAdapter);
        this.customTo.addSelectionListener((SelectionListener)spinnerAdapter);
        this.customIncrement.addSelectionListener((SelectionListener)spinnerAdapter);
        MHeaderRangeStatus mHeaderRangeStatus = new MHeaderRangeStatus(this.simple, this.simpleLoop, this.custom);
        Group rangeGroup = new Group(radios, 16);
        rangeGroup.setLayout((Layout)new GridLayout(2, false));
        rangeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        rangeGroup.setText(TuxGuitar.getProperty("transport.mode.loop-range"));
        mHeaderRangeStatus.addControl((Control)rangeGroup);
        mHeaderRangeStatus.addControl((Control)this.makeLabel((Composite)rangeGroup, TuxGuitar.getProperty("transport.mode.loop-range.from"), 16384, 1));
        this.loopSHeader = new MHeaderCombo((Composite)rangeGroup);
        mHeaderRangeStatus.addControl((Control)this.loopSHeader.getControl());
        mHeaderRangeStatus.addControl((Control)this.makeLabel((Composite)rangeGroup, TuxGuitar.getProperty("transport.mode.loop-range.to"), 16384, 1));
        this.loopEHeader = new MHeaderCombo((Composite)rangeGroup);
        mHeaderRangeStatus.addControl((Control)this.loopEHeader.getControl());
        MHeaderComboController mHeaderController = new MHeaderComboController(this.loopSHeader, this.loopEHeader);
        mHeaderController.updateLoopSHeader(mode.getLoopSHeader());
        mHeaderController.updateLoopEHeader(mode.getLoopSHeader(), mode.getLoopEHeader());
        mHeaderController.appendListener();
        simpleAdapter.update();
        customAdapter.update();
        mHeaderRangeStatus.update();
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTransportModeDialog.this.changeTransportMode();
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getMainData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 350;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private Label makeLabel(Composite parent, String text, int aligment, int horizontalSpan) {
        Label label = new Label(parent, 0x1000000 | aligment);
        label.setText(text);
        GridData data = new GridData(4, 0x1000000, true, true);
        data.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)data);
        return label;
    }

    public void changeTransportMode() {
        Integer type = this.custom.getSelection() ? 2 : 1;
        Boolean loop = type == 2 || type == 1 && this.simpleLoop.getSelection();
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.transport.mode");
        tgActionProcessor.setAttribute("type", (Object)type);
        tgActionProcessor.setAttribute("loop", (Object)loop);
        tgActionProcessor.setAttribute("simplePercent", (Object)(this.simplePercent.getSelectionIndex() >= 0 ? DEFAULT_PERCENTS[this.simplePercent.getSelectionIndex()] : 100));
        tgActionProcessor.setAttribute("customPercentFrom", (Object)this.customFrom.getSelection());
        tgActionProcessor.setAttribute("customPercentTo", (Object)this.customTo.getSelection());
        tgActionProcessor.setAttribute("customPercentIncrement", (Object)this.customIncrement.getSelection());
        tgActionProcessor.setAttribute("loopSHeader", (Object)(loop != false ? this.loopSHeader.getValue() : -1));
        tgActionProcessor.setAttribute("loopEHeader", (Object)(loop != false ? this.loopEHeader.getValue() : -1));
        tgActionProcessor.process();
    }

    private class MHeaderComboController {
        protected MHeaderCombo loopSHeader;
        protected MHeaderCombo loopEHeader;

        public MHeaderComboController(MHeaderCombo loopSHeader, MHeaderCombo loopEHeader) {
            this.loopSHeader = loopSHeader;
            this.loopEHeader = loopEHeader;
        }

        public void updateLoopSHeader(int sHeader) {
            TGSong song = (TGSong)TGTransportModeDialog.this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            this.loopSHeader.clear();
            this.loopSHeader.addItem(TuxGuitar.getProperty("transport.mode.loop-range.from-default"), -1);
            for (int i = 0; i < song.countMeasureHeaders(); ++i) {
                TGMeasureHeader header = song.getMeasureHeader(i);
                this.loopSHeader.addItem(header);
            }
            this.loopSHeader.setValue(sHeader);
        }

        public void updateLoopEHeader(int sHeader, int eHeader) {
            TGSong song = (TGSong)TGTransportModeDialog.this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            this.loopEHeader.clear();
            this.loopEHeader.addItem(TuxGuitar.getProperty("transport.mode.loop-range.to-default"), -1);
            for (int i = 0; i < song.countMeasureHeaders(); ++i) {
                TGMeasureHeader header = song.getMeasureHeader(i);
                if (sHeader != -1 && header.getNumber() < sHeader) continue;
                this.loopEHeader.addItem(header);
            }
            this.loopEHeader.setValue(eHeader);
        }

        public void updateLoopEHeader() {
            int sHeader = this.loopSHeader.getValue();
            int eHeader = this.loopEHeader.getValue();
            if (eHeader != -1 && sHeader > eHeader) {
                eHeader = sHeader;
            }
            this.updateLoopEHeader(sHeader, eHeader);
        }

        public void appendListener() {
            this.loopSHeader.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MHeaderComboController.this.updateLoopEHeader();
                }
            });
        }
    }

    private class MHeaderCombo {
        private List<Integer> values = new ArrayList<Integer>();
        private Combo combo;

        public MHeaderCombo(Composite parent) {
            this.combo = new Combo(parent, 12);
            this.combo.setLayoutData((Object)new GridData(4, 4, true, true));
        }

        public Combo getControl() {
            return this.combo;
        }

        public void clear() {
            this.values.clear();
            this.combo.removeAll();
        }

        public void addItem(String text, int value) {
            this.values.add(new Integer(value));
            this.combo.add(text);
        }

        public void addItem(TGMeasureHeader header) {
            this.addItem(this.getItemText(header), header.getNumber());
        }

        public void setValue(int value) {
            for (int index = 0; index < this.values.size(); ++index) {
                int currentIndex;
                Integer currentValue = this.values.get(index);
                if (currentValue == null || currentValue != value || (currentIndex = this.combo.getSelectionIndex()) == index) continue;
                this.combo.select(index);
            }
        }

        public int getValue() {
            Integer value;
            int index = this.combo.getSelectionIndex();
            if (index >= 0 && index < this.values.size() && (value = this.values.get(index)) != null) {
                return value;
            }
            return -1;
        }

        private String getItemText(TGMeasureHeader header) {
            String text = "#" + header.getNumber();
            if (header.hasMarker()) {
                text = text + " (" + header.getMarker().getTitle() + ")";
            }
            return text;
        }
    }

    private class MHeaderRangeStatus
    extends SelectionAdapter {
        private List<Control> controls = new ArrayList<Control>();
        private boolean enabled = false;
        private Button simpleMode;
        private Button simpleLoop;
        private Button customLoop;

        public MHeaderRangeStatus(Button simpleMode, Button simpleLoop, Button customLoop) {
            this.simpleMode = simpleMode;
            this.simpleLoop = simpleLoop;
            this.customLoop = customLoop;
            this.simpleMode.addSelectionListener((SelectionListener)this);
            this.simpleLoop.addSelectionListener((SelectionListener)this);
            this.customLoop.addSelectionListener((SelectionListener)this);
        }

        public void addControl(Control control) {
            this.controls.add(control);
        }

        public void update() {
            this.enabled = this.customLoop.getSelection();
            if (!this.enabled && this.simpleMode.getSelection()) {
                this.enabled = this.simpleLoop.getSelection();
            }
            for (Control control : this.controls) {
                control.setEnabled(this.enabled);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.update();
        }
    }

    private class SpinnerSelectionAdapter
    extends SelectionAdapter {
        private Spinner to;
        private Spinner from;
        private Spinner increment;

        public SpinnerSelectionAdapter(Spinner from, Spinner to, Spinner increment) {
            this.from = from;
            this.to = to;
            this.increment = increment;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.from)) {
                if (this.from.getSelection() < 1) {
                    this.from.setSelection(1);
                } else if (this.from.getSelection() >= this.to.getSelection()) {
                    this.from.setSelection(this.to.getSelection() - 1);
                }
            } else if (e.widget.equals(this.to)) {
                if (this.to.getSelection() <= this.from.getSelection()) {
                    this.to.setSelection(this.from.getSelection() + 1);
                } else if (this.to.getSelection() > 500) {
                    this.to.setSelection(500);
                }
            }
            if (this.increment.getSelection() > this.to.getSelection() - this.from.getSelection()) {
                this.increment.setSelection(this.to.getSelection() - this.from.getSelection());
            }
        }
    }

    private class RadioSelectionAdapter
    extends SelectionAdapter {
        private Button control;
        private List<Control> controls = new ArrayList<Control>();

        public RadioSelectionAdapter(Button control) {
            this.control = control;
            this.control.addSelectionListener((SelectionListener)this);
        }

        public void addControl(Control control) {
            this.controls.add(control);
        }

        public void update() {
            boolean enabled = this.control.getSelection();
            for (Control control : this.controls) {
                control.setEnabled(enabled);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.update();
        }
    }
}

