/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.Option;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class MainOption
extends Option {
    private static final String VAR_START = "${";
    private static final String VAR_END = "}";
    protected boolean initialized = false;
    protected Button showSplash;
    protected Button autoSizeTable;
    protected Text windowTitle;

    public MainOption(TGSettingsEditor configEditor, ToolBar toolBar, Composite parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.main"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.main"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionMain());
        this.getToolItem().addSelectionListener((SelectionListener)this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.main.window-title"));
        Composite windowTitleComposite = new Composite(this.getComposite(), 0);
        windowTitleComposite.setLayout((Layout)new GridLayout());
        windowTitleComposite.setLayoutData((Object)this.getTabbedData());
        this.windowTitle = new Text(windowTitleComposite, 2048);
        this.windowTitle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.windowTitle.setTextLimit(80);
        Composite infoHeader = new Composite(windowTitleComposite, 0);
        infoHeader.setLayout((Layout)new GridLayout(2, false));
        infoHeader.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showImageLabel(infoHeader, 0, infoHeader.getDisplay().getSystemImage(2));
        this.showLabel(infoHeader, 16576, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.help"));
        Composite infoBody = new Composite(windowTitleComposite, 0);
        infoBody.setLayout((Layout)new GridLayout(2, false));
        infoBody.setLayoutData((Object)new GridData(4, 4, true, true));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("appname"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.appname"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("appversion"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.appversion"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("filename"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.filename"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("filepath"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.filepath"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("songname"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songname"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("songalbum"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songalbum"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("songartist"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songartist"));
        this.showLabel(infoBody, 0, 1, -1, this.getVar("songauthor"));
        this.showLabel(infoBody, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songauthor"));
        this.showLabel(this.getComposite(), 17472, 1, 0, TuxGuitar.getProperty("settings.config.main.options"));
        Composite options = new Composite(this.getComposite(), 0);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)this.getTabbedData());
        this.autoSizeTable = new Button(options, 32);
        this.autoSizeTable.setText(TuxGuitar.getProperty("settings.config.main.table.auto-size.enabled"));
        this.showSplash = new Button(options, 32);
        this.showSplash.setText(TuxGuitar.getProperty("settings.config.main.splash-enabled"));
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                final String windowTitle = MainOption.this.getConfig().getStringValue("window.title");
                final boolean showSplash = MainOption.this.getConfig().getBooleanValue("show.splash");
                final boolean autoSizeTable = MainOption.this.getConfig().getBooleanValue("table.auto-size");
                TGSynchronizer.getInstance((TGContext)MainOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (!MainOption.this.isDisposed()) {
                            MainOption.this.windowTitle.setText(windowTitle);
                            MainOption.this.showSplash.setSelection(showSplash);
                            MainOption.this.autoSizeTable.setSelection(autoSizeTable);
                            MainOption.this.initialized = true;
                            MainOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setValue("window.title", this.windowTitle.getText());
            this.getConfig().setValue("show.splash", this.showSplash.getSelection());
            this.getConfig().setValue("table.auto-size", this.autoSizeTable.getSelection());
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("window.title", this.getDefaults().getValue("window.title"));
            this.getConfig().setValue("show.splash", this.getDefaults().getValue("show.splash"));
            this.getConfig().setValue("table.auto-size", this.getDefaults().getValue("table.auto-size"));
        }
    }

    public String getVar(String varName) {
        return VAR_START + varName + VAR_END;
    }
}

