/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.scale;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.scale.ScaleManager;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.util.TGContext;

public class TGScaleDialog {
    public void show(final TGViewContext context) {
        ScaleManager scaleManager = ScaleManager.getInstance(context.getContext());
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("scale.list"));
        dialog.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)dialog, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        final List keys = new List(composite, 2560);
        keys.setLayoutData((Object)new GridData(50, 200));
        String[] keyNames = scaleManager.getKeyNames();
        for (int i = 0; i < keyNames.length; ++i) {
            keys.add(keyNames[i]);
        }
        keys.select(scaleManager.getSelectionKey());
        final List scales = new List(composite, 2560);
        scales.setLayoutData((Object)new GridData(-1, 200));
        scales.add("None");
        String[] scaleNames = scaleManager.getScaleNames();
        for (int i = 0; i < scaleNames.length; ++i) {
            scales.add(scaleNames[i]);
        }
        scales.select(scaleManager.getSelectionIndex() + 1);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGScaleDialog.this.selectScale(context.getContext(), scales.getSelectionIndex() - 1, keys.getSelectionIndex());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void selectScale(TGContext context, Integer index, Integer key) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.tools.select-scale");
        tgActionProcessor.setAttribute("scaleIndex", (Object)index);
        tgActionProcessor.setAttribute("scaleKey", (Object)key);
        tgActionProcessor.process();
    }
}

