/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.util.TGContext;

public class TGMeasurePasteDialog {
    public void show(final TGViewContext context) {
        Shell parent = (Shell)context.getAttribute("parent");
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("edit.paste"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("edit.paste"));
        Label countLabel = new Label((Composite)group, 0);
        countLabel.setText(TuxGuitar.getProperty("edit.paste.count"));
        final Spinner countSpinner = new Spinner((Composite)group, 2048);
        countSpinner.setLayoutData((Object)this.getSpinnerData());
        countSpinner.setMinimum(1);
        countSpinner.setMaximum(100);
        countSpinner.setSelection(1);
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)new GridData(4, 4, true, true));
        options.setText(TuxGuitar.getProperty("options"));
        final Button replace = new Button((Composite)options, 16);
        replace.setText(TuxGuitar.getProperty("edit.paste.replace-mode"));
        replace.setSelection(true);
        final Button insert = new Button((Composite)options, 16);
        insert.setText(TuxGuitar.getProperty("edit.paste.insert-mode"));
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int pasteMode = 0;
                int pasteCount = countSpinner.getSelection();
                if (replace.getSelection()) {
                    pasteMode = 1;
                } else if (insert.getSelection()) {
                    pasteMode = 2;
                }
                TGMeasurePasteDialog.this.processAction(context.getContext(), pasteMode, pasteCount);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 10);
    }

    private GridData getSpinnerData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 150;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    public void processAction(TGContext context, Integer pasteMode, Integer pasteCount) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.measure.paste");
        tgActionProcessor.setAttribute("pasteMode", (Object)pasteMode);
        tgActionProcessor.setAttribute("pasteCount", (Object)pasteCount);
        tgActionProcessor.process();
    }
}

