/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.matrix;

import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.graphics.TGColorImpl;
import org.herac.tuxguitar.app.graphics.TGFontImpl;
import org.herac.tuxguitar.app.graphics.TGImageImpl;
import org.herac.tuxguitar.app.graphics.TGPainterImpl;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.dialog.matrix.TGMatrixConfig;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterListenerLocked;
import org.herac.tuxguitar.app.view.util.TGBufferedPainterLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGImage;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGNoteImpl;
import org.herac.tuxguitar.player.base.MidiPercussionKey;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGMatrixEditor
implements TGEventListener {
    private static final int BORDER_HEIGHT = 20;
    private static final int SCROLL_INCREMENT = 50;
    private static final String[] NOTE_NAMES = TGMusicKeyUtils.getSharpKeyNames("matrix");
    private static final MidiPercussionKey[] PERCUSSIONS = TuxGuitar.getInstance().getPlayer().getPercussionKeys();
    protected static final int[] DIVISIONS = new int[]{1, 2, 3, 4, 6, 8, 16};
    private TGContext context;
    private TGMatrixConfig config;
    private Shell dialog;
    private Composite composite;
    private Composite toolbar;
    private Composite editor;
    private Rectangle clientArea;
    private TGImage buffer;
    private BufferDisposer bufferDisposer;
    private Label durationLabel;
    private Label gridsLabel;
    private Button settings;
    private float width;
    private float height;
    private float bufferWidth;
    private float bufferHeight;
    private float timeWidth;
    private float lineHeight;
    private float leftSpacing;
    private int minNote;
    private int maxNote;
    private int duration;
    private int selection;
    private int grids;
    private int playedTrack;
    private int playedMeasure;
    private TGBeat playedBeat;

    public TGMatrixEditor(TGContext context) {
        this.context = context;
        this.grids = this.loadGrids();
    }

    public void show() {
        this.config = new TGMatrixConfig();
        this.config.load();
        this.dialog = DialogUtils.newDialog(TuxGuitar.getInstance().getShell(), 2160);
        this.dialog.setText(TuxGuitar.getProperty("matrix.editor"));
        this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.addDisposeListener((DisposeListener)new DisposeListenerImpl());
        this.bufferDisposer = new BufferDisposer();
        this.composite = new Composite((Composite)this.dialog, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initToolBar();
        this.initEditor();
        this.loadIcons();
        this.addListeners();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGMatrixEditor.this.removeListeners();
            }
        });
        DialogUtils.openDialog(this.dialog, 8);
    }

    public void addListeners() {
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.toolbar);
        TuxGuitar.getInstance().getKeyBindingManager().appendListenersTo((Control)this.editor);
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeRedrawListener((TGEventListener)this);
    }

    private void initToolBar() {
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.toolbar = new Composite(this.composite, 0);
        ++layout.numColumns;
        Button goLeft = new Button(this.toolbar, 16388);
        goLeft.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-left"));
        ++layout.numColumns;
        Button goRight = new Button(this.toolbar, 131076);
        goRight.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.caret.go-right"));
        ++layout.numColumns;
        this.makeToolSeparator(this.toolbar);
        ++layout.numColumns;
        Button decrement = new Button(this.toolbar, 132);
        decrement.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.decrement-duration"));
        ++layout.numColumns;
        this.durationLabel = new Label(this.toolbar, 2048);
        ++layout.numColumns;
        Button increment = new Button(this.toolbar, 1028);
        increment.addSelectionListener((SelectionListener)new TGActionProcessorListener(this.context, "action.note.duration.increment-duration"));
        ++layout.numColumns;
        this.makeToolSeparator(this.toolbar);
        ++layout.numColumns;
        this.gridsLabel = new Label(this.toolbar, 0);
        this.gridsLabel.setText(TuxGuitar.getProperty("matrix.grids"));
        ++layout.numColumns;
        final Combo divisionsCombo = new Combo(this.toolbar, 12);
        divisionsCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        for (int i = 0; i < DIVISIONS.length; ++i) {
            divisionsCombo.add(Integer.toString(DIVISIONS[i]));
            if (this.grids != DIVISIONS[i]) continue;
            divisionsCombo.select(i);
        }
        if (this.grids == 0) {
            divisionsCombo.select(0);
        }
        divisionsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = divisionsCombo.getSelectionIndex();
                if (index >= 0 && index < DIVISIONS.length) {
                    TGMatrixEditor.this.setGrids(DIVISIONS[index]);
                }
            }
        });
        ++layout.numColumns;
        this.settings = new Button(this.toolbar, 8);
        this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
        this.settings.setLayoutData((Object)new GridData(131072, 4, true, true));
        this.settings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGMatrixEditor.this.configure();
            }
        });
        this.toolbar.setLayout((Layout)layout);
        this.toolbar.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void makeToolSeparator(Composite parent) {
        Label separator = new Label(parent, 2);
        separator.setLayoutData((Object)new GridData(20, 20));
    }

    private void loadDurationImage(boolean force) {
        int duration = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getDuration().getValue();
        if (force || this.duration != duration) {
            this.duration = duration;
            this.durationLabel.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.duration));
        }
    }

    public void initEditor() {
        TGMatrixMouseListener mouseListener = new TGMatrixMouseListener();
        this.selection = -1;
        this.editor = new Composite(this.composite, 0x20000B00);
        this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.setLayout((Layout)new FillLayout());
        this.editor.setFocus();
        this.editor.addPaintListener((PaintListener)new TGBufferedPainterListenerLocked(this.context, new TGMatrixPainterListener()));
        this.editor.addMouseListener((MouseListener)mouseListener);
        this.editor.addMouseMoveListener((MouseMoveListener)mouseListener);
        this.editor.addMouseTrackListener((MouseTrackListener)mouseListener);
        this.editor.getHorizontalBar().setIncrement(50);
        this.editor.getHorizontalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGMatrixEditor.this.redraw();
            }
        });
        this.editor.getVerticalBar().setIncrement(50);
        this.editor.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGMatrixEditor.this.redraw();
            }
        });
    }

    protected void updateScroll() {
        if (this.clientArea != null) {
            int borderWidth = this.editor.getBorderWidth();
            ScrollBar vBar = this.editor.getVerticalBar();
            ScrollBar hBar = this.editor.getHorizontalBar();
            vBar.setMaximum(Math.round(this.height + (float)(borderWidth * 2)));
            vBar.setThumb(Math.round(Math.min(this.height + (float)(borderWidth * 2), (float)this.clientArea.height)));
            hBar.setMaximum(Math.round(this.width + (float)(borderWidth * 2)));
            hBar.setThumb(Math.round(Math.min(this.width + (float)(borderWidth * 2), (float)this.clientArea.width)));
        }
    }

    protected int getValueAt(float y) {
        if (this.clientArea == null || y - 20.0f < 0.0f || y + 20.0f > (float)this.clientArea.height) {
            return -1;
        }
        int scroll = this.editor.getVerticalBar().getSelection();
        int value = this.maxNote - (int)((y + (float)scroll - 20.0f) / this.lineHeight);
        return value;
    }

    protected long getStartAt(float x) {
        TGMeasure measure = this.getMeasure();
        float posX = x + (float)this.editor.getHorizontalBar().getSelection();
        long start = (long)((float)measure.getStart() + (posX - this.leftSpacing) * (float)measure.getLength() / (this.timeWidth * (float)measure.getTimeSignature().getNumerator()));
        return start;
    }

    protected void paintEditor(TGPainter painter) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning()) {
            this.resetPlayed();
        }
        this.clientArea = this.editor.getClientArea();
        if (this.clientArea != null) {
            TGImage buffer = this.getBuffer();
            this.width = this.bufferWidth;
            this.height = this.bufferHeight + 40.0f;
            this.updateScroll();
            int scrollX = this.editor.getHorizontalBar().getSelection();
            int scrollY = this.editor.getVerticalBar().getSelection();
            painter.drawImage(buffer, (float)(-scrollX), (float)(20 - scrollY));
            this.paintMeasure(painter, -scrollX, 20 - scrollY);
            this.paintBorders(painter, -scrollX, 0.0f);
            this.paintPosition(painter, -scrollX, 0.0f);
            this.paintSelection(painter, -scrollX, 20 - scrollY);
        }
    }

    protected TGImage getBuffer() {
        if (this.clientArea != null) {
            this.bufferDisposer.update(this.clientArea.width, this.clientArea.height);
            if (this.buffer == null || this.buffer.isDisposed()) {
                int i;
                int i2;
                String[] names = null;
                TGMeasure measure = this.getMeasure();
                this.maxNote = 0;
                this.minNote = 127;
                if (TuxGuitar.getInstance().getSongManager().isPercussionChannel(this.getCaret().getSong(), measure.getTrack().getChannelId())) {
                    names = new String[PERCUSSIONS.length];
                    for (i2 = 0; i2 < names.length; ++i2) {
                        this.minNote = Math.min(this.minNote, PERCUSSIONS[i2].getValue());
                        this.maxNote = Math.max(this.maxNote, PERCUSSIONS[i2].getValue());
                        names[i2] = PERCUSSIONS[names.length - i2 - 1].getName();
                    }
                } else {
                    for (int sNumber = 1; sNumber <= measure.getTrack().stringCount(); ++sNumber) {
                        TGString string = measure.getTrack().getString(sNumber);
                        this.minNote = Math.min(this.minNote, string.getValue());
                        this.maxNote = Math.max(this.maxNote, string.getValue() + 20);
                    }
                    names = new String[this.maxNote - this.minNote + 1];
                    for (i2 = 0; i2 < names.length; ++i2) {
                        names[i2] = NOTE_NAMES[(this.maxNote - i2) % 12] + (this.maxNote - i2) / 12;
                    }
                }
                float minimumNameWidth = 110.0f;
                float minimumNameHeight = 0.0f;
                TGPainterImpl painter = new TGPainterImpl(new GC((Drawable)this.dialog.getDisplay()));
                painter.setFont(new TGFontImpl(this.config.getFont()));
                for (int i3 = 0; i3 < names.length; ++i3) {
                    float fmHeight;
                    float fmWidth = painter.getFMWidth(names[i3]);
                    if (fmWidth > minimumNameWidth) {
                        minimumNameWidth = fmWidth;
                    }
                    if (!((fmHeight = painter.getFMHeight()) > minimumNameHeight)) continue;
                    minimumNameHeight = fmHeight;
                }
                painter.dispose();
                int cols = measure.getTimeSignature().getNumerator();
                int rows = this.maxNote - this.minNote;
                this.leftSpacing = minimumNameWidth + 10.0f;
                this.lineHeight = Math.max(minimumNameHeight, ((float)this.clientArea.height - 40.0f) / ((float)rows + 1.0f));
                this.timeWidth = Math.max((float)(10 * (64 / measure.getTimeSignature().getDenominator().getValue())), ((float)this.clientArea.width - this.leftSpacing) / (float)cols);
                this.bufferWidth = this.leftSpacing + this.timeWidth * (float)cols;
                this.bufferHeight = this.lineHeight * (float)(rows + 1);
                this.buffer = new TGImageImpl((Device)this.editor.getDisplay(), Math.round(this.bufferWidth), Math.round(this.bufferHeight));
                painter = this.buffer.createPainter();
                painter.setFont(new TGFontImpl(this.config.getFont()));
                painter.setForeground(new TGColorImpl(this.config.getColorForeground()));
                for (i = 0; i <= rows; ++i) {
                    painter.setBackground(new TGColorImpl(this.config.getColorLine(i % 2)));
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle(0.0f, (float)i * this.lineHeight, this.bufferWidth, this.lineHeight);
                    painter.closePath();
                    painter.drawString(names[i], 5.0f, (float)i * this.lineHeight + this.lineHeight / 2.0f + painter.getFMMiddleLine());
                }
                for (i = 0; i < cols; ++i) {
                    float colX = this.leftSpacing + (float)i * this.timeWidth;
                    float divisionWidth = this.timeWidth / (float)this.grids;
                    for (int j = 0; j < this.grids; ++j) {
                        if (j == 0) {
                            painter.setLineStyleSolid();
                        } else {
                            painter.setLineStyleDot();
                        }
                        painter.initPath();
                        painter.setAntialias(false);
                        painter.moveTo(Math.round(colX + (float)j * divisionWidth), 0.0f);
                        painter.lineTo(Math.round(colX + (float)j * divisionWidth), this.bufferHeight);
                        painter.closePath();
                    }
                }
                painter.dispose();
            }
        }
        return this.buffer;
    }

    protected void paintMeasure(TGPainter painter, float fromX, float fromY) {
        TGMeasure measure;
        if (this.clientArea != null && (measure = this.getMeasure()) != null) {
            for (TGBeat beat : measure.getBeats()) {
                this.paintBeat(painter, measure, beat, fromX, fromY);
            }
        }
    }

    protected void paintBeat(TGPainter painter, TGMeasure measure, TGBeat beat, float fromX, float fromY) {
        if (this.clientArea != null) {
            int minimumY = 20;
            int maximumY = this.clientArea.height - 20;
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (int i = 0; i < voice.countNotes(); ++i) {
                    TGNoteImpl note = (TGNoteImpl)voice.getNote(i);
                    float x1 = fromX + this.leftSpacing + (float)(beat.getStart() - measure.getStart()) * (this.timeWidth * (float)measure.getTimeSignature().getNumerator()) / (float)measure.getLength() + 1.0f;
                    float y1 = fromY + (float)(this.maxNote - this.minNote - (note.getRealValue() - this.minNote)) * this.lineHeight + 1.0f;
                    float x2 = x1 + (float)voice.getDuration().getTime() * this.timeWidth / (float)measure.getTimeSignature().getDenominator().getTime() - 2.0f;
                    float y2 = y1 + this.lineHeight - 2.0f;
                    if (y1 >= (float)maximumY || y2 <= (float)minimumY) continue;
                    y1 = y1 < (float)minimumY ? (float)minimumY : y1;
                    float f = y2 = y2 > (float)maximumY ? (float)maximumY : y2;
                    if (!(x2 - x1 > 0.0f) || !(y2 - y1 > 0.0f)) continue;
                    painter.setBackground((TGColor)new TGColorImpl(note.getBeatImpl().isPlaying(TuxGuitar.getInstance().getTablatureEditor().getTablature().getViewLayout()) ? this.config.getColorPlay() : this.config.getColorNote()));
                    painter.initPath(2);
                    painter.setAntialias(false);
                    painter.addRectangle(x1, y1, x2 - x1, y2 - y1);
                    painter.closePath();
                }
            }
        }
    }

    protected void paintBorders(TGPainter painter, float fromX, float fromY) {
        if (this.clientArea != null) {
            painter.setBackground((TGColor)new TGColorImpl(this.config.getColorBorder()));
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle(fromX, fromY, this.bufferWidth, 20.0f);
            painter.addRectangle(fromX, fromY + (float)(this.clientArea.height - 20), this.bufferWidth, 20.0f);
            painter.closePath();
            painter.initPath();
            painter.setAntialias(false);
            painter.addRectangle(fromX, fromY, this.width, (float)this.clientArea.height);
            painter.closePath();
        }
    }

    protected void paintPosition(TGPainter painter, float fromX, float fromY) {
        if (this.clientArea != null && !TuxGuitar.getInstance().getPlayer().isRunning()) {
            Caret caret = this.getCaret();
            TGMeasure measure = this.getMeasure();
            TGBeatImpl beat = caret.getSelectedBeat();
            if (beat != null) {
                float x = (float)(beat.getStart() - measure.getStart()) * (this.timeWidth * (float)measure.getTimeSignature().getNumerator()) / (float)measure.getLength();
                float width = (float)beat.getVoice(caret.getVoice()).getDuration().getTime() * this.timeWidth / (float)measure.getTimeSignature().getDenominator().getTime();
                painter.setBackground((TGColor)new TGColorImpl(this.config.getColorPosition()));
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRectangle(fromX + (this.leftSpacing + x), fromY, width, 20.0f);
                painter.closePath();
                painter.initPath(2);
                painter.setAntialias(false);
                painter.addRectangle(fromX + (this.leftSpacing + x), fromY + (float)(this.clientArea.height - 20), width, 20.0f);
                painter.closePath();
            }
        }
    }

    protected void paintSelection(TGPainter painter, float fromX, float fromY) {
        if (this.clientArea != null && !TuxGuitar.getInstance().getPlayer().isRunning() && this.selection >= 0) {
            int x = Math.round(fromX);
            int y = Math.round(fromY + (float)(this.maxNote - this.selection) * this.lineHeight);
            int width = Math.round(this.bufferWidth);
            int height = Math.round(this.lineHeight);
            painter.setAlpha(100);
            painter.setBackground((TGColor)new TGColorImpl(this.config.getColorLine(2)));
            painter.initPath(2);
            painter.setAntialias(false);
            painter.addRectangle((float)x, (float)y, (float)width, (float)height);
            painter.closePath();
        }
    }

    protected void updateSelection(float y) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning()) {
            int previousSelection = this.selection;
            this.selection = this.getValueAt(y);
            if (this.selection != previousSelection) {
                this.redraw();
            }
        }
    }

    protected void hit(float x, float y) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning()) {
            int value = this.getValueAt(y);
            long start = this.getStartAt(x);
            Caret caret = this.getCaret();
            TGMeasure measure = this.getMeasure();
            TGSongManager songManager = TGDocumentManager.getInstance((TGContext)this.context).getSongManager();
            TGVoice voice = songManager.getMeasureManager().getVoiceIn(measure, start, caret.getVoice());
            if (value >= this.minNote && value <= this.maxNote) {
                if (start >= measure.getStart() && voice != null) {
                    if (!this.removeNote(voice.getBeat(), value)) {
                        this.addNote(voice.getBeat(), start, value);
                    }
                } else {
                    this.play(value);
                }
            } else if (voice != null) {
                this.moveTo(voice.getBeat());
            }
        }
    }

    private boolean removeNote(TGBeat beat, int value) {
        TGMeasure measure = this.getMeasure();
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice voice = beat.getVoice(v);
            for (TGNoteImpl note : voice.getNotes()) {
                if (note.getRealValue() != value) continue;
                TGString string = measure.getTrack().getString(note.getString());
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.beat.general.delete-note");
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
                tgActionProcessor.process();
                this.moveTo(beat, string);
                return true;
            }
        }
        return false;
    }

    private boolean addNote(TGBeat beat, long start, int value) {
        if (beat != null) {
            TGMeasure measure = this.getMeasure();
            List strings = measure.getTrack().getStrings();
            for (int i = 0; i < strings.size(); ++i) {
                TGString string = (TGString)strings.get(i);
                if (value < string.getValue()) continue;
                boolean emptyString = true;
                block1: for (int v = 0; v < beat.countVoices(); ++v) {
                    TGVoice voice = beat.getVoice(v);
                    for (TGNoteImpl note : voice.getNotes()) {
                        if (note.getString() != string.getNumber()) continue;
                        emptyString = false;
                        continue block1;
                    }
                }
                if (!emptyString) continue;
                TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.note.general.change");
                tgActionProcessor.setAttribute("position", (Object)start);
                tgActionProcessor.setAttribute("fret", (Object)(value - string.getValue()));
                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
                tgActionProcessor.process();
                this.moveTo(beat, string);
                return true;
            }
        }
        return false;
    }

    private void moveTo(TGBeat beat) {
        this.moveTo(beat, null);
    }

    private void moveTo(TGBeat beat, TGString string) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.caret.move-to");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        if (string != null) {
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        }
        tgActionProcessor.process();
    }

    protected void play(final int value) {
        new Thread(new Runnable(){

            public void run() {
                TGTrack tgTrack = TGMatrixEditor.this.getMeasure().getTrack();
                TGChannel tgChannel = TuxGuitar.getInstance().getSongManager().getChannel(tgTrack.getSong(), tgTrack.getChannelId());
                if (tgChannel != null) {
                    int volume = 127;
                    int balance = 64;
                    short chorus = tgChannel.getChorus();
                    short reverb = tgChannel.getReverb();
                    short phaser = tgChannel.getPhaser();
                    short tremolo = tgChannel.getTremolo();
                    int channel = tgChannel.getChannelId();
                    short program = tgChannel.getProgram();
                    short bank = tgChannel.getBank();
                    int[][] beat = new int[][]{{tgTrack.getOffset() + value, 95}};
                    TuxGuitar.getInstance().getPlayer().playBeat(channel, (int)bank, (int)program, volume, balance, (int)chorus, (int)reverb, (int)phaser, (int)tremolo, (int[][])beat);
                }
            }
        }).start();
    }

    protected int loadGrids() {
        int grids = TuxGuitar.getInstance().getConfig().getIntegerValue("matrix.grids");
        for (int i = 0; i < DIVISIONS.length; ++i) {
            if (grids != DIVISIONS[i]) continue;
            return grids;
        }
        return DIVISIONS[1];
    }

    protected void setGrids(int grids) {
        this.grids = grids;
        this.disposeBuffer();
        this.redraw();
    }

    public int getGrids() {
        return this.grids;
    }

    protected TGMeasure getMeasure() {
        TGMeasureImpl measure;
        if (TuxGuitar.getInstance().getPlayer().isRunning() && (measure = TuxGuitar.getInstance().getEditorCache().getPlayMeasure()) != null) {
            return measure;
        }
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
    }

    protected Caret getCaret() {
        return TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret();
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    protected void resetPlayed() {
        this.playedBeat = null;
        this.playedMeasure = -1;
        this.playedTrack = -1;
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.editor.redraw();
            this.loadDurationImage(false);
        }
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !TGEditorManager.getInstance((TGContext)this.context).isLocked() && TuxGuitar.getInstance().getPlayer().isRunning()) {
            TGMeasureImpl measure = TuxGuitar.getInstance().getEditorCache().getPlayMeasure();
            TGBeatImpl beat = TuxGuitar.getInstance().getEditorCache().getPlayBeat();
            if (measure != null && beat != null) {
                boolean changed;
                int currentMeasure = measure.getNumber();
                int currentTrack = measure.getTrack().getNumber();
                boolean bl = changed = currentMeasure != this.playedMeasure || currentTrack != this.playedTrack;
                if (changed) {
                    this.resetPlayed();
                    this.editor.redraw();
                } else {
                    TGPainterImpl painter = new TGPainterImpl(new GC((Drawable)this.editor));
                    int scrollX = this.editor.getHorizontalBar().getSelection();
                    int scrollY = this.editor.getVerticalBar().getSelection();
                    if (this.playedBeat != null) {
                        this.paintBeat(painter, (TGMeasure)measure, this.playedBeat, -scrollX, 20 - scrollY);
                    }
                    this.paintBeat(painter, (TGMeasure)measure, (TGBeat)beat, -scrollX, 20 - scrollY);
                    painter.dispose();
                }
                this.playedMeasure = currentMeasure;
                this.playedTrack = currentTrack;
                this.playedBeat = beat;
            }
        }
    }

    protected void configure() {
        this.config.configure(this.dialog);
        this.disposeBuffer();
        this.redraw();
    }

    private void layout() {
        if (!this.isDisposed()) {
            this.toolbar.layout();
            this.editor.layout();
            this.composite.layout(true, true);
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
            this.loadDurationImage(true);
            this.layout();
            this.redraw();
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty("matrix.editor"));
            this.gridsLabel.setText(TuxGuitar.getProperty("matrix.grids"));
            this.settings.setToolTipText(TuxGuitar.getProperty("settings"));
            this.disposeBuffer();
            this.layout();
            this.redraw();
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    protected void disposeBuffer() {
        if (this.buffer != null && !this.buffer.isDisposed()) {
            this.buffer.dispose();
            this.buffer = null;
        }
    }

    protected void dispose(Resource[] resources) {
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                this.dispose(resources[i]);
            }
        }
    }

    protected void dispose(Resource resource) {
        if (resource != null) {
            resource.dispose();
        }
    }

    protected void disposeAll() {
        this.disposeBuffer();
        this.config.dispose();
    }

    protected Composite getEditor() {
        return this.editor;
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redraw();
        } else if (type == 3) {
            this.redrawPlayingMode();
        }
    }

    public void processEvent(final TGEvent event) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            public void run() {
                if ("ui-icon".equals(event.getEventType())) {
                    TGMatrixEditor.this.loadIcons();
                } else if ("language".equals(event.getEventType())) {
                    TGMatrixEditor.this.loadProperties();
                } else if ("ui-redraw".equals(event.getEventType())) {
                    TGMatrixEditor.this.processRedrawEvent(event);
                }
            }
        });
    }

    public static TGMatrixEditor getInstance(TGContext context) {
        return (TGMatrixEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TGMatrixEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGMatrixEditor>(){

            public TGMatrixEditor createInstance(TGContext context) {
                return new TGMatrixEditor(context);
            }
        });
    }

    private class TGMatrixPainterListener
    implements TGBufferedPainterLocked.TGBufferedPainterHandle {
        public void paintControl(TGPainter painter) {
            TGMatrixEditor.this.paintEditor(painter);
        }

        public Composite getPaintableControl() {
            return TGMatrixEditor.this.editor;
        }
    }

    protected class TGMatrixMouseListener
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        public void mouseUp(MouseEvent e) {
            TGMatrixEditor.this.getEditor().setFocus();
            if (e.button == 1 && !TGEditorManager.getInstance((TGContext)TGMatrixEditor.this.context).isLocked()) {
                TGMatrixEditor.this.hit(e.x, e.y);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (!TGEditorManager.getInstance((TGContext)TGMatrixEditor.this.context).isLocked()) {
                TGMatrixEditor.this.updateSelection(e.y);
            }
        }

        public void mouseExit(MouseEvent e) {
            if (!TGEditorManager.getInstance((TGContext)TGMatrixEditor.this.context).isLocked()) {
                TGMatrixEditor.this.updateSelection(-1.0f);
            }
        }

        public void mouseEnter(MouseEvent e) {
            if (!TGEditorManager.getInstance((TGContext)TGMatrixEditor.this.context).isLocked()) {
                TGMatrixEditor.this.redraw();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }
    }

    protected class DisposeListenerImpl
    implements DisposeListener {
        protected DisposeListenerImpl() {
        }

        public void widgetDisposed(DisposeEvent e) {
            TGMatrixEditor.this.disposeAll();
        }
    }

    protected class BufferDisposer {
        private int numerator;
        private int denominator;
        private int track;
        private boolean percussion;
        private int width;
        private int height;

        protected BufferDisposer() {
        }

        public void update(int width, int height) {
            TGMeasure measure = TGMatrixEditor.this.getMeasure();
            int track = measure.getTrack().getNumber();
            int numerator = measure.getTimeSignature().getNumerator();
            int denominator = measure.getTimeSignature().getDenominator().getValue();
            boolean percussion = TuxGuitar.getInstance().getSongManager().isPercussionChannel(measure.getTrack().getSong(), measure.getTrack().getChannelId());
            if (width != this.width || height != this.height || this.track != track || this.numerator != numerator || this.denominator != denominator || this.percussion != percussion) {
                TGMatrixEditor.this.disposeBuffer();
            }
            this.track = track;
            this.numerator = numerator;
            this.denominator = denominator;
            this.percussion = percussion;
            this.width = width;
            this.height = height;
        }
    }
}

