/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.marker;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class TGMarkerEditor {
    private static final int MINIMUM_CONTROL_WIDTH = 180;
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private static final int MINIMUM_BUTTON_HEIGHT = 25;
    private TGViewContext context;
    private TGMarker marker;
    private Shell dialog;
    private Spinner measureSpinner;
    private Text titleText;
    private Button colorButton;
    private Color colorButtonValue;

    public TGMarkerEditor(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        this.createEditableMarker();
        Shell parent = (Shell)this.context.getAttribute("parent");
        this.dialog = DialogUtils.newDialog(parent, 67680);
        this.dialog.setLayout((Layout)new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("marker"));
        Group group = new Group((Composite)this.dialog, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("marker"));
        final int measureCount = TuxGuitar.getInstance().getDocumentManager().getSong().countMeasureHeaders();
        Label measureLabel = new Label((Composite)group, 0);
        measureLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        measureLabel.setText(TuxGuitar.getProperty("measure"));
        this.measureSpinner = new Spinner((Composite)group, 2048);
        this.measureSpinner.setLayoutData((Object)this.getAlignmentData(180, 4));
        this.measureSpinner.setMinimum(1);
        this.measureSpinner.setMaximum(measureCount);
        this.measureSpinner.setSelection(this.marker.getMeasure());
        this.measureSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = TGMarkerEditor.this.measureSpinner.getSelection();
                if (selection < 1) {
                    TGMarkerEditor.this.measureSpinner.setSelection(1);
                } else if (selection > measureCount) {
                    TGMarkerEditor.this.measureSpinner.setSelection(measureCount);
                }
            }
        });
        Label titleLabel = new Label((Composite)group, 0);
        titleLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        titleLabel.setText(TuxGuitar.getProperty("title"));
        this.titleText = new Text((Composite)group, 2048);
        this.titleText.setLayoutData((Object)this.getAlignmentData(180, 4));
        this.titleText.setText(this.marker.getTitle());
        Label colorLabel = new Label((Composite)group, 0);
        colorLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        colorLabel.setText(TuxGuitar.getProperty("color"));
        this.colorButton = new Button((Composite)group, 8);
        this.colorButton.setLayoutData((Object)this.getAlignmentData(180, 4));
        this.colorButton.setText(TuxGuitar.getProperty("choose"));
        this.colorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(TGMarkerEditor.this.dialog);
                dlg.setRGB(TGMarkerEditor.this.dialog.getDisplay().getSystemColor(2).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                    TGMarkerEditor.this.marker.getColor().setR(rgb.red);
                    TGMarkerEditor.this.marker.getColor().setG(rgb.green);
                    TGMarkerEditor.this.marker.getColor().setB(rgb.blue);
                    TGMarkerEditor.this.setButtonColor();
                }
            }
        });
        this.colorButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGMarkerEditor.this.disposeButtonColor();
            }
        });
        this.setButtonColor();
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)data);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMarkerEditor.this.updateMarker();
                TGMarkerEditor.this.dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGMarkerEditor.this.dialog.dispose();
            }
        });
        this.dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(this.dialog, 10);
    }

    private GridData getAlignmentData(int minimumWidth, int horizontalAlignment) {
        GridData data = new GridData();
        data.minimumWidth = minimumWidth;
        data.horizontalAlignment = horizontalAlignment;
        data.verticalAlignment = -1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        return data;
    }

    protected void setButtonColor() {
        Color color = new Color((Device)this.dialog.getDisplay(), this.marker.getColor().getR(), this.marker.getColor().getG(), this.marker.getColor().getB());
        this.colorButton.setForeground(color);
        this.disposeButtonColor();
        this.colorButtonValue = color;
    }

    protected void disposeButtonColor() {
        if (this.colorButtonValue != null && !this.colorButtonValue.isDisposed()) {
            this.colorButtonValue.dispose();
            this.colorButtonValue = null;
        }
    }

    protected void updateMarker() {
        this.marker.setMeasure(this.measureSpinner.getSelection());
        this.marker.setTitle(this.titleText.getText());
        TGSongManager songManager = (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.marker.modify");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER));
        tgActionProcessor.setAttribute("modifiedMarker", (Object)this.marker.clone(songManager.getFactory()));
        tgActionProcessor.process();
    }

    private void createEditableMarker() {
        TGSongManager songManager = (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        TGMarker marker = (TGMarker)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER);
        if (marker == null) {
            TGMeasureHeader header = (TGMeasureHeader)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
            marker = songManager.getFactory().newMarker();
            marker.setMeasure(header.getNumber());
        }
        this.marker = marker.clone(songManager.getFactory());
    }
}

