/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.harmonic;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeHarmonicNoteAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.util.TGContext;

public class TGHarmonicDialog
extends SelectionAdapter {
    public static final int WIDTH = 400;
    protected Combo harmonicType;
    protected Combo harmonicDataCombo;
    protected Button[] typeButtons;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        final TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            Shell parent = (Shell)context.getAttribute("parent");
            final Shell dialog = DialogUtils.newDialog(parent, 67680);
            dialog.setLayout((Layout)new GridLayout());
            dialog.setText(TuxGuitar.getProperty("effects.harmonic-editor"));
            Group group = new Group((Composite)dialog, 16);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)this.resizeData(new GridData(4, 4, true, true), 400));
            group.setText(TuxGuitar.getProperty("effects.harmonic.type-of-harmonic"));
            this.typeButtons = new Button[5];
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TGHarmonicDialog.this.update(note, TGHarmonicDialog.this.getSelectedType());
                }
            };
            String label = "[N.H] " + TuxGuitar.getProperty("effects.harmonic.natural");
            this.initButton((Composite)group, (SelectionListener)listener, 0, 1, label);
            label = "[A.H] " + TuxGuitar.getProperty("effects.harmonic.artificial");
            this.initButton((Composite)group, (SelectionListener)listener, 1, 2, label);
            label = "[T.H] " + TuxGuitar.getProperty("effects.harmonic.tapped");
            this.initButton((Composite)group, (SelectionListener)listener, 2, 3, label);
            label = "[P.H] " + TuxGuitar.getProperty("effects.harmonic.pinch");
            this.initButton((Composite)group, (SelectionListener)listener, 3, 4, label);
            label = "[S.H] " + TuxGuitar.getProperty("effects.harmonic.semi");
            this.initButton((Composite)group, (SelectionListener)listener, 4, 5, label);
            this.harmonicDataCombo = new Combo((Composite)group, 12);
            this.harmonicDataCombo.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite buttons = new Composite((Composite)dialog, 0);
            buttons.setLayout((Layout)new GridLayout(3, false));
            buttons.setLayoutData((Object)new GridData(0x1000008, 1024, true, true));
            Button buttonOK = new Button(buttons, 8);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData((Object)this.getButtonData());
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGHarmonicDialog.this.changeHarmonic(context.getContext(), measure, beat, string, TGHarmonicDialog.this.getHarmonic());
                    dialog.dispose();
                }
            });
            Button buttonClean = new Button(buttons, 8);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.setLayoutData((Object)this.getButtonData());
            buttonClean.setEnabled(note.getEffect().isHarmonic());
            buttonClean.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TGHarmonicDialog.this.changeHarmonic(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button(buttons, 8);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData((Object)this.getButtonData());
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            this.initDefaults(note);
            dialog.setDefaultButton(buttonOK);
            DialogUtils.openDialog(dialog, 10);
        }
    }

    private GridData resizeData(GridData data, int minWidth) {
        data.minimumWidth = minWidth;
        return data;
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private void initButton(Composite parent, SelectionListener listener, int index, int type, String label) {
        this.typeButtons[index] = new Button(parent, 16);
        this.typeButtons[index].setText(label);
        this.typeButtons[index].setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeButtons[index].setData((Object)new Integer(type));
        this.typeButtons[index].addSelectionListener(listener);
    }

    protected void initDefaults(TGNote note) {
        int type = 1;
        if (note.getEffect().isHarmonic()) {
            type = note.getEffect().getHarmonic().getType();
        } else {
            boolean naturalValid = false;
            for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                if (note.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[i][0] % 12) continue;
                naturalValid = true;
                break;
            }
            if (!naturalValid) {
                this.typeButtons[0].setEnabled(false);
                type = 2;
            }
        }
        for (int i = 0; i < this.typeButtons.length; ++i) {
            int data = (Integer)this.typeButtons[i].getData();
            this.typeButtons[i].setSelection(data == type);
        }
        this.update(note, type);
    }

    protected int getSelectedType() {
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].getSelection()) continue;
            return (Integer)this.typeButtons[i].getData();
        }
        return 0;
    }

    protected void update(TGNote note, int type) {
        TGEffectHarmonic h = note.getEffect().getHarmonic();
        this.harmonicDataCombo.removeAll();
        this.harmonicDataCombo.setEnabled(type != 1);
        if (type != 1) {
            String label = this.getTypeLabel(type);
            for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                this.harmonicDataCombo.add(label + "(" + Integer.toString(TGEffectHarmonic.NATURAL_FREQUENCIES[i][0]) + ")");
            }
            this.harmonicDataCombo.select(h != null && h.getType() == type ? h.getData() : 0);
        }
    }

    private String getTypeLabel(int type) {
        if (type == 1) {
            return "N.H";
        }
        if (type == 2) {
            return "A.H";
        }
        if (type == 3) {
            return "T.H";
        }
        if (type == 4) {
            return "P.H";
        }
        if (type == 5) {
            return "S.H";
        }
        return new String();
    }

    public TGEffectHarmonic getHarmonic() {
        int type = this.getSelectedType();
        if (type > 0) {
            TGEffectHarmonic effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectHarmonic();
            effect.setType(type);
            effect.setData(this.harmonicDataCombo.getSelectionIndex());
            return effect;
        }
        return null;
    }

    public void changeHarmonic(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectHarmonic effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-harmonic");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeHarmonicNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

