/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class TGScalePopup {
    private int type;
    private int value;
    private boolean inverted;
    private Shell shell;
    private Composite composite;
    private Button item;
    private Scale scale;
    private String text;
    private SelectionListener selectionListener;
    private MouseListener mouseListener;

    public TGScalePopup(Composite parent) {
        this.init(parent);
    }

    public void init(Composite parent) {
        this.value = -1;
        this.inverted = true;
        this.item = new Button(parent, 2);
        this.item.addDisposeListener(this.createItemDisposeListener());
        this.item.addSelectionListener(this.createItemSelectionListener());
        this.item.getShell().addListener(10, this.createMoveShellListener());
    }

    public void reset() {
        this.item.setSelection(false);
        this.hideShell();
    }

    public void addDefaultListeners() {
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TGScalePopup.this.getValueFromScale();
                if (TGScalePopup.this.selectionListener != null) {
                    TGScalePopup.this.selectionListener.widgetSelected(event);
                }
            }
        });
        if (this.mouseListener != null) {
            this.scale.addMouseListener(this.mouseListener);
        }
    }

    private GridLayout getGridLayout() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        return layout;
    }

    private GridData getScaleLayoutData() {
        GridData data = new GridData(0x1000000, 4, false, true);
        data.heightHint = 65;
        return data;
    }

    public int getType() {
        return this.type;
    }

    public int getValue() {
        if (this.value < 0) {
            this.getValueFromScale();
        }
        return this.value;
    }

    public void setValue(int value) {
        if (value != this.value) {
            this.value = value;
            this.setValueToScale();
            this.updateToolTipValue();
        }
    }

    public void getValueFromScale() {
        if (!this.isShellDisposed()) {
            this.setValue(this.inverted ? 127 - this.scale.getSelection() : this.scale.getSelection());
        }
    }

    public void setValueToScale() {
        if (!this.isShellDisposed()) {
            this.scale.setSelection(this.inverted ? 127 - this.value : this.value);
        }
    }

    public void updateToolTipValue() {
        if (this.getText() != null) {
            this.item.setToolTipText(this.getText() + ": " + this.getValue());
            if (!this.isShellDisposed()) {
                this.scale.setToolTipText(this.text + ": " + this.getValue());
            }
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.getText() != null && this.getText().length() > 0) {
            this.item.setText(this.getText().substring(0, 1));
        }
        this.updateToolTipValue();
    }

    public String getText() {
        return this.text;
    }

    public void showShell() {
        if (this.isShellDisposed()) {
            this.shell = new Shell(this.item.getShell(), 8);
            this.shell.setVisible(false);
            this.shell.setLayout((Layout)this.getGridLayout());
            this.composite = new Composite((Composite)this.shell, 2048);
            this.composite.setLayout((Layout)this.getGridLayout());
            this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.scale = new Scale(this.composite, 512);
            this.scale.setMaximum(127);
            this.scale.setMinimum(0);
            this.scale.setIncrement(1);
            this.scale.setPageIncrement(64);
            this.scale.setLayoutData((Object)this.getScaleLayoutData());
            this.setValueToScale();
            this.addDefaultListeners();
            this.shell.pack();
            this.moveShell();
            this.shell.setVisible(true);
        }
    }

    public void hideShell() {
        if (!this.isShellDisposed()) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    public void showHideShell() {
        if (this.item.getSelection()) {
            this.showShell();
        } else {
            this.hideShell();
        }
    }

    public void moveShell() {
        if (!this.isShellDisposed()) {
            Rectangle bounds = this.item.getBounds();
            Point location = this.item.getParent().toDisplay(new Point(bounds.x, bounds.y));
            this.shell.setLocation(location.x + bounds.width / 2 - this.shell.getSize().x / 2, location.y + bounds.height);
        }
    }

    public boolean isShellDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    private DisposeListener createItemDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGScalePopup.this.hideShell();
            }
        };
    }

    private SelectionListener createItemSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGScalePopup.this.showHideShell();
            }
        };
    }

    private Listener createMoveShellListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                TGScalePopup.this.moveShell();
            }
        };
    }
}

