/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelHandle;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelList;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsHandlerManager;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGChannelManagerDialog
implements TGEventListener {
    private Shell dialog;
    private TGContext context;
    private TGChannelHandle channelHandle;
    private TGChannelList channelList;
    private TGChannelSettingsHandlerManager channelSettingsHandlerManager;
    private TGCursorController cursorController;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateItemsProcess;
    private Button addChannelButton;
    private Scale volumeScale;
    private Label volumeValueLabel;
    private Label volumeValueTitleLabel;
    private String volumeTip;
    private int volumeValue;

    public TGChannelManagerDialog(TGContext context) {
        this.context = context;
        this.channelHandle = new TGChannelHandle(context);
        this.channelSettingsHandlerManager = new TGChannelSettingsHandlerManager();
        this.createSyncProcesses();
    }

    public void show(TGViewContext viewContext) {
        Shell parent = (Shell)viewContext.getAttribute("parent");
        this.dialog = DialogUtils.newDialog(parent, 2160);
        this.dialog.setLayout((Layout)this.createGridLayout(1, false, true, true));
        this.createWindow((Composite)this.dialog, new GridData(4, 4, true, true));
        this.addListeners();
        this.dialog.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGChannelManagerDialog.this.removeListeners();
            }
        });
        DialogUtils.openDialog(this.dialog, 10);
    }

    public TGContext getContext() {
        return this.context;
    }

    public Shell getShell() {
        return this.dialog;
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.dialog.dispose();
        }
    }

    public void addListeners() {
        TuxGuitar.getInstance().getIconManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getIconManager().removeLoader(this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader(this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    private void createWindow(Composite parent, Object layoutData) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)this.createGridLayout(2, false, true, true));
        composite.setLayoutData(layoutData);
        this.createChannelList(composite);
        this.createRightComposite(composite);
        this.updateItems();
        this.loadProperties();
        this.loadIcons();
    }

    private void createRightComposite(Composite composite) {
        Composite rightComposite = new Composite(composite, 0);
        rightComposite.setLayout((Layout)this.createGridLayout(1, false, true, false));
        rightComposite.setLayoutData((Object)new GridData(131072, 4, false, true));
        Composite toolbarComposite = new Composite(rightComposite, 2048);
        toolbarComposite.setLayout((Layout)this.createGridLayout(1, false, true, true));
        toolbarComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addChannelButton = new Button(toolbarComposite, 8);
        this.addChannelButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addChannelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChannelManagerDialog.this.getHandle().addChannel();
            }
        });
        Composite volumeComposite = new Composite(rightComposite, 2048);
        volumeComposite.setLayout((Layout)this.createGridLayout(1, false, true, true));
        volumeComposite.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.volumeScale = new Scale(volumeComposite, 512);
        this.volumeScale.setMaximum(10);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(1);
        this.volumeScale.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        Label separator = new Label(volumeComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite volumeValueComposite = new Composite(volumeComposite, 0);
        volumeValueComposite.setLayout((Layout)this.createGridLayout(2, false, true, true));
        this.volumeValueTitleLabel = new Label(volumeValueComposite, 0);
        this.volumeValueLabel = new Label(volumeValueComposite, 0x1000000);
        this.volumeValueLabel.setLayoutData((Object)this.createGridData(0x1000000, 0, true, false, 1, 1, 40, 0));
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TGChannelManagerDialog.this.changeVolume();
            }
        });
    }

    private void createChannelList(Composite composite) {
        this.channelList = new TGChannelList(this);
        this.channelList.show(composite);
    }

    public GridLayout createGridLayout(int numColumns, boolean makeColumnsEqualWidth, boolean addSpacings, boolean addMargins) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        gridLayout.horizontalSpacing = addSpacings ? gridLayout.horizontalSpacing : 0;
        gridLayout.verticalSpacing = addSpacings ? gridLayout.verticalSpacing : 0;
        gridLayout.marginWidth = addMargins ? gridLayout.marginWidth : 0;
        gridLayout.marginHeight = addMargins ? gridLayout.marginHeight : 0;
        gridLayout.marginLeft = addMargins ? gridLayout.marginLeft : 0;
        gridLayout.marginTop = addMargins ? gridLayout.marginTop : 0;
        gridLayout.marginRight = addMargins ? gridLayout.marginRight : 0;
        gridLayout.marginBottom = addMargins ? gridLayout.marginBottom : 0;
        return gridLayout;
    }

    public GridData createGridData(int hAlign, int vAlign, boolean gEHSpace, boolean gEVSpace, int hSpan, int vSpan, int mWidth, int mHeight) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = hAlign;
        gridData.verticalAlignment = vAlign;
        gridData.grabExcessHorizontalSpace = gEHSpace;
        gridData.grabExcessVerticalSpace = gEVSpace;
        gridData.horizontalSpan = hSpan;
        gridData.verticalSpan = vSpan;
        gridData.minimumWidth = mWidth;
        gridData.minimumHeight = mHeight;
        return gridData;
    }

    protected void changeVolume() {
        short volume = (short)(this.volumeScale.getMaximum() - this.volumeScale.getSelection());
        if (volume != TuxGuitar.getInstance().getPlayer().getVolume()) {
            TuxGuitar.getInstance().getPlayer().setVolume((int)volume);
            this.volumeScale.setToolTipText(this.volumeTip + ": " + TuxGuitar.getInstance().getPlayer().getVolume());
            this.volumeValueLabel.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
            this.volumeValue = volume;
        }
    }

    private void updateItems() {
        if (!this.isDisposed()) {
            this.loadCursor(1);
            this.channelList.updateItems();
            int volume = TuxGuitar.getInstance().getPlayer().getVolume();
            if (this.volumeValue != volume) {
                this.volumeScale.setSelection(this.volumeScale.getMaximum() - TuxGuitar.getInstance().getPlayer().getVolume());
                this.volumeValueLabel.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
                this.volumeValue = volume;
            }
            this.loadCursor(0);
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.addChannelButton.setText(TuxGuitar.getProperty("add"));
            this.volumeValueTitleLabel.setText(TuxGuitar.getProperty("instruments.volume") + ":");
            this.volumeTip = TuxGuitar.getProperty("instruments.volume");
            this.volumeScale.setToolTipText(this.volumeTip + ": " + TuxGuitar.getInstance().getPlayer().getVolume());
            this.dialog.setText(TuxGuitar.getProperty("instruments.dialog-title"));
            this.channelList.loadProperties();
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.channelList.loadIcons();
        }
    }

    public void loadCursor(int cursorStyle) {
        if (!this.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((Control)this.dialog)) {
                this.cursorController = new TGCursorController(this.context, (Control)this.dialog);
            }
            this.cursorController.loadCursor(cursorStyle);
        }
    }

    public void onUpdateChannel(TGChannel channel) {
        if (TuxGuitar.getInstance().getPlayer().isRunning()) {
            TuxGuitar.getInstance().getPlayer().updateControllers();
        }
    }

    public TGChannelHandle getHandle() {
        return this.channelHandle;
    }

    public TGChannelSettingsHandlerManager getChannelSettingsHandlerManager() {
        return this.channelSettingsHandlerManager;
    }

    public void createSyncProcesses() {
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGChannelManagerDialog.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            public void run() {
                TGChannelManagerDialog.this.loadIcons();
            }
        });
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            public void run() {
                TGChannelManagerDialog.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TGChannelManagerDialog getInstance(TGContext context) {
        return (TGChannelManagerDialog)TGSingletonUtil.getInstance((TGContext)context, (String)TGChannelManagerDialog.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGChannelManagerDialog>(){

            public TGChannelManagerDialog createInstance(TGContext context) {
                return new TGChannelManagerDialog(context);
            }
        });
    }
}

