/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelHandle;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import org.herac.tuxguitar.app.view.dialog.channel.TGScalePopup;
import org.herac.tuxguitar.app.view.dialog.channel.TGScaleSelectionListener;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGChannelItem {
    private TGChannel channel;
    private TGChannelManagerDialog dialog;
    private Composite composite;
    private Text nameText;
    private Combo programCombo;
    private Combo bankCombo;
    private Button setupChannelButton;
    private Button removeChannelButton;
    private Button percussionButton;
    private TGScalePopup volumeScale;
    private TGScalePopup balanceScale;
    private TGScalePopup reverbScale;
    private TGScalePopup chorusScale;
    private TGScalePopup tremoloScale;
    private TGScalePopup phaserScale;

    public TGChannelItem(TGChannelManagerDialog dialog) {
        this.dialog = dialog;
    }

    public void show(Composite parent, Object layoutData) {
        this.composite = new Composite(parent, 2048);
        this.composite.setLayout((Layout)this.dialog.createGridLayout(3, false, true, true));
        this.composite.setLayoutData(layoutData);
        Composite col1Composite = new Composite(this.composite, 0);
        col1Composite.setLayout((Layout)this.dialog.createGridLayout(1, false, true, false));
        col1Composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nameText = new Text(col1Composite, 18432);
        this.nameText.setLayoutData((Object)new GridData(150, -1));
        this.nameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TGChannelItem.this.checkForNameModified();
            }
        });
        this.nameText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TGChannelItem.this.checkForNameModified();
            }
        });
        this.programCombo = new Combo(col1Composite, 12);
        this.programCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.programCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChannelItem.this.updateChannel(false);
            }
        });
        this.bankCombo = new Combo(col1Composite, 12);
        this.bankCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.bankCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChannelItem.this.updateChannel(false);
            }
        });
        Composite col2Composite = new Composite(this.composite, 0);
        col2Composite.setLayout((Layout)this.dialog.createGridLayout(1, false, true, false));
        col2Composite.setLayoutData((Object)new GridData(4, 1024, true, true));
        this.percussionButton = new Button(col2Composite, 32);
        this.percussionButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.percussionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChannelItem.this.updateChannel(true);
            }
        });
        Composite col3Composite = new Composite(this.composite, 0);
        col3Composite.setLayout((Layout)this.dialog.createGridLayout(1, false, true, false));
        col3Composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite actionButtonsComposite = new Composite(col3Composite, 0);
        actionButtonsComposite.setLayout((Layout)this.dialog.createGridLayout(2, false, true, false));
        actionButtonsComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setupChannelButton = new Button(actionButtonsComposite, 8);
        this.setupChannelButton.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.setupChannelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChannelItem.this.setupChannel();
            }
        });
        this.removeChannelButton = new Button(actionButtonsComposite, 8);
        this.removeChannelButton.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.removeChannelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGChannelItem.this.removeChannel();
            }
        });
        Composite controllerScalesComposite = new Composite(col3Composite, 0);
        controllerScalesComposite.setLayout((Layout)new RowLayout());
        controllerScalesComposite.setLayoutData((Object)new GridData(131072, 1024, true, true));
        TGScaleSelectionListener scaleSelectionListener = new TGScaleSelectionListener(this);
        this.volumeScale = new TGScalePopup(controllerScalesComposite);
        this.volumeScale.setSelectionListener((SelectionListener)scaleSelectionListener);
        this.balanceScale = new TGScalePopup(controllerScalesComposite);
        this.balanceScale.setSelectionListener((SelectionListener)scaleSelectionListener);
        this.reverbScale = new TGScalePopup(controllerScalesComposite);
        this.reverbScale.setSelectionListener((SelectionListener)scaleSelectionListener);
        this.chorusScale = new TGScalePopup(controllerScalesComposite);
        this.chorusScale.setSelectionListener((SelectionListener)scaleSelectionListener);
        this.tremoloScale = new TGScalePopup(controllerScalesComposite);
        this.tremoloScale.setSelectionListener((SelectionListener)scaleSelectionListener);
        this.phaserScale = new TGScalePopup(controllerScalesComposite);
        this.phaserScale.setSelectionListener((SelectionListener)scaleSelectionListener);
        this.loadIcons();
        this.loadProperties();
        this.updateItems();
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.percussionButton.setText(TuxGuitar.getProperty("instrument.percussion-channel"));
            this.removeChannelButton.setText(TuxGuitar.getProperty("remove"));
            this.setupChannelButton.setToolTipText(TuxGuitar.getProperty("settings"));
            this.volumeScale.setText(TuxGuitar.getProperty("instrument.volume"));
            this.balanceScale.setText(TuxGuitar.getProperty("instrument.balance"));
            this.reverbScale.setText(TuxGuitar.getProperty("instrument.reverb"));
            this.chorusScale.setText(TuxGuitar.getProperty("instrument.chorus"));
            this.tremoloScale.setText(TuxGuitar.getProperty("instrument.tremolo"));
            this.phaserScale.setText(TuxGuitar.getProperty("instrument.phaser"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.setupChannelButton.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        }
    }

    public void resetItems() {
        if (!this.isDisposed()) {
            this.volumeScale.reset();
            this.balanceScale.reset();
            this.reverbScale.reset();
            this.chorusScale.reset();
            this.tremoloScale.reset();
            this.phaserScale.reset();
        }
    }

    public void updateItems() {
        if (!this.isDisposed() && this.getChannel() != null) {
            boolean playerRunning = this.getHandle().isPlayerRunning();
            boolean anyPercussionChannel = this.getHandle().isAnyPercussionChannel();
            boolean anyTrackConnectedToChannel = this.getHandle().isAnyTrackConnectedToChannel(this.getChannel());
            this.nameText.setText(this.getChannel().getName());
            this.percussionButton.setSelection(this.getChannel().isPercussionChannel());
            this.percussionButton.setEnabled(!anyTrackConnectedToChannel && (!anyPercussionChannel || this.getChannel().isPercussionChannel()));
            this.removeChannelButton.setEnabled(!anyTrackConnectedToChannel);
            this.setupChannelButton.setEnabled(this.dialog.getChannelSettingsHandlerManager().isChannelSettingsHandlerAvailable());
            this.volumeScale.setValue(this.getChannel().getVolume());
            this.balanceScale.setValue(this.getChannel().getBalance());
            this.reverbScale.setValue(this.getChannel().getReverb());
            this.chorusScale.setValue(this.getChannel().getChorus());
            this.tremoloScale.setValue(this.getChannel().getTremolo());
            this.phaserScale.setValue(this.getChannel().getPhaser());
            this.updateBankCombo(playerRunning);
            this.updateProgramCombo(playerRunning);
        }
    }

    private void updateBankCombo(boolean playerRunning) {
        if (!this.isDisposed() && this.getChannel() != null) {
            if (this.bankCombo.getItemCount() == 0) {
                String bankPrefix = TuxGuitar.getProperty("instrument.bank");
                for (int i = 0; i < 128; ++i) {
                    this.bankCombo.add(bankPrefix + " #" + i);
                }
            }
            if (this.getChannel().getBank() >= 0 && this.getChannel().getBank() < this.bankCombo.getItemCount()) {
                this.bankCombo.select((int)this.getChannel().getBank());
            }
            this.bankCombo.setEnabled(!this.getChannel().isPercussionChannel());
        }
    }

    private void updateProgramCombo(boolean playerRunning) {
        if (!this.isDisposed() && this.getChannel() != null) {
            List<String> programNames = this.getProgramNames();
            if (!(this.programCombo.getData() instanceof List) || this.isDifferentList(programNames, (List)this.programCombo.getData())) {
                this.programCombo.removeAll();
                this.programCombo.setData(programNames);
                for (int i = 0; i < programNames.size(); ++i) {
                    this.programCombo.add(programNames.get(i));
                }
            }
            if (this.getChannel().getProgram() >= 0 && this.getChannel().getProgram() < this.programCombo.getItemCount()) {
                this.programCombo.select((int)this.getChannel().getProgram());
            }
        }
    }

    private List<String> getProgramNames() {
        MidiInstrument[] instruments;
        ArrayList<String> programNames = new ArrayList<String>();
        if (!this.getChannel().isPercussionChannel() && (instruments = MidiPlayer.getInstance((TGContext)this.getContext()).getInstruments()) != null) {
            int count = instruments.length;
            if (count > 128) {
                count = 128;
            }
            for (int i = 0; i < count; ++i) {
                programNames.add(instruments[i].getName());
            }
        }
        if (programNames.isEmpty()) {
            String programPrefix = TuxGuitar.getProperty("instrument.program");
            for (int i = 0; i < 128; ++i) {
                programNames.add(programPrefix + " #" + i);
            }
        }
        return programNames;
    }

    private boolean isDifferentList(List<? extends Object> list1, List<? extends Object> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }

    public void checkForNameModified() {
        if (this.getChannel() != null && !this.isDisposed() && !this.nameText.getText().equals(this.getChannel().getName())) {
            this.updateChannel(false);
        }
    }

    public void checkForChannelChanged(TGChannel newChannel) {
        if (this.channel == null || newChannel != null && !newChannel.equals(this.channel)) {
            this.resetItems();
        }
    }

    public TGContext getContext() {
        return this.dialog.getContext();
    }

    public TGChannelHandle getHandle() {
        return this.dialog.getHandle();
    }

    public TGChannel getChannel() {
        return this.channel;
    }

    public void setChannel(TGChannel channel) {
        this.checkForChannelChanged(channel);
        this.channel = channel;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public boolean isDisposed() {
        return this.getComposite() == null || this.getComposite().isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getComposite().dispose();
        }
    }

    public void updateChannel(boolean percussionChanged) {
        if (this.getChannel() != null && !this.isDisposed()) {
            boolean percussionChannel = this.percussionButton.getSelection();
            int bank = this.getChannel().getBank();
            int program = this.getChannel().getProgram();
            if (percussionChanged) {
                bank = percussionChannel ? 128 : 0;
                program = percussionChannel ? 0 : 25;
            } else {
                int programSelection;
                int bankSelection;
                if (!percussionChannel && (bankSelection = this.bankCombo.getSelectionIndex()) >= 0) {
                    bank = bankSelection;
                }
                if ((programSelection = this.programCombo.getSelectionIndex()) >= 0) {
                    program = programSelection;
                }
            }
            this.getHandle().updateChannel(this.getChannel().getChannelId(), (short)bank, (short)program, (short)this.volumeScale.getValue(), (short)this.balanceScale.getValue(), (short)this.chorusScale.getValue(), (short)this.reverbScale.getValue(), (short)this.phaserScale.getValue(), (short)this.tremoloScale.getValue(), this.nameText.getText());
        }
    }

    public void removeChannel() {
        if (this.getChannel() != null && !this.isDisposed()) {
            this.getHandle().removeChannel(this.getChannel());
        }
    }

    public void setupChannel() {
        TGChannelSettingsDialog settingsDialog;
        if (this.getChannel() != null && !this.isDisposed() && (settingsDialog = this.dialog.getChannelSettingsHandlerManager().findChannelSettingsDialog(this.getChannel())) != null) {
            settingsDialog.show(this.dialog.getShell());
        }
    }
}

