/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.tab.edit;

import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.util.TGContext;

public class MouseKit
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
MenuListener {
    private EditorKit kit;
    private Point position;
    private boolean menuOpen;

    public MouseKit(EditorKit kit) {
        this.kit = kit;
        this.position = new Point(0, 0);
        this.menuOpen = false;
    }

    public boolean isBusy() {
        TGContext context = this.kit.getTablature().getContext();
        return TGEditorManager.getInstance((TGContext)context).isLocked() || MidiPlayer.getInstance((TGContext)context).isRunning();
    }

    public void executeAction(String actionId, int x, int y, boolean byPassProcessing) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.kit.getTablature().getContext(), actionId);
        tgActionProcessor.setAttribute("editorKit-x", (Object)x);
        tgActionProcessor.setAttribute("editorKit-y", (Object)y);
        tgActionProcessor.setAttribute("byPassProcessingListener", (Object)byPassProcessing);
        tgActionProcessor.process();
    }

    public void mouseDown(MouseEvent e) {
        this.position.x = e.x;
        this.position.y = e.y;
    }

    public void mouseUp(MouseEvent e) {
        this.position.x = e.x;
        this.position.y = e.y;
        this.kit.getTablature().setFocus();
        this.executeAction("action.edit.tablature.mouse-click", e.x, e.y, false);
    }

    public void mouseMove(MouseEvent e) {
        if (!this.menuOpen && this.kit.isMouseEditionAvailable() && !this.isBusy()) {
            this.executeAction("action.edit.tablature.mouse-move", e.x, e.y, true);
        }
    }

    public void mouseExit(MouseEvent e) {
        if (!this.menuOpen && this.kit.isMouseEditionAvailable()) {
            this.executeAction("action.edit.tablature.mouse-exit", e.x, e.y, true);
        }
    }

    public void menuShown(MenuEvent e) {
        this.menuOpen = true;
        this.executeAction("action.edit.tablature.menu-shown", this.position.x, this.position.y, false);
    }

    public void menuHidden(MenuEvent e) {
        this.menuOpen = false;
        TuxGuitar.getInstance().updateCache(true);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }
}

