/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.browser.filesystem;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserData;
import org.herac.tuxguitar.app.tools.browser.filesystem.TGBrowserDataImpl;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.util.TGContext;

public class TGBrowserDataDialog {
    private TGContext context;
    private TGBrowserData data;

    public TGBrowserDataDialog(TGContext context) {
        this.context = context;
    }

    public TGBrowserData getData() {
        return this.data;
    }

    public void setData(TGBrowserData data) {
        this.data = data;
    }

    public TGBrowserData open(Shell parent) {
        final Shell dialog = DialogUtils.newDialog(parent, 67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty("browser.collection.fs.editor-title"));
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("browser.collection.fs.editor-tip"));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label titleLabel = new Label(composite, 16384);
        titleLabel.setText(TuxGuitar.getProperty("browser.collection.fs.name"));
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Text titleValue = new Text(composite, 2048);
        titleValue.setLayoutData((Object)this.getTextData(2));
        Label pathLabel = new Label(composite, 16384);
        pathLabel.setText(TuxGuitar.getProperty("browser.collection.fs.path"));
        pathLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Text pathValue = new Text(composite, 2048);
        pathValue.setLayoutData((Object)this.getTextData(1));
        Button pathChooser = new Button(composite, 8);
        pathChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        pathChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(dialog);
                String selection = directoryDialog.open();
                if (selection != null) {
                    pathValue.setText(selection);
                }
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData((Object)this.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String selectedTitle = titleValue.getText();
                String selectedPath = pathValue.getText();
                if (!TGBrowserDataDialog.this.isValidPath(selectedPath)) {
                    TGMessageDialogUtil.errorMessage(TGBrowserDataDialog.this.context, dialog, TuxGuitar.getProperty("browser.collection.fs.invalid-path"));
                    return;
                }
                if (TGBrowserDataDialog.this.isBlank(selectedTitle)) {
                    selectedTitle = selectedPath;
                }
                TGBrowserDataDialog.this.setData(new TGBrowserDataImpl(selectedTitle, selectedPath));
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog(dialog, 11);
        return this.getData();
    }

    private GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private GridData getTextData(int span) {
        GridData data = new GridData(16384, 0x1000000, true, true, span, 1);
        data.minimumWidth = 350;
        return data;
    }

    protected boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    protected boolean isValidPath(String path) {
        if (!this.isBlank(path)) {
            File file = new File(path);
            return file.exists() && file.isDirectory();
        }
        return false;
    }
}

