/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.config;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.util.properties.TGProperties;
import org.herac.tuxguitar.util.properties.TGPropertiesManager;

public class TGConfigDefaults {
    public static final String RESOURCE = "config-defaults";
    public static final String MODULE = "tuxguitar";
    private static final String DEFAULT_FONT_NAME = TGConfigDefaults.getDefaultFontName();

    public static TGProperties createDefaults() {
        TGPropertiesManager propertiesManager = TuxGuitar.getInstance().getPropertiesManager();
        TGProperties properties = propertiesManager.createProperties();
        TGConfigDefaults.loadProperties(properties);
        propertiesManager.readProperties(properties, RESOURCE, MODULE);
        return properties;
    }

    public static void loadProperties(TGProperties properties) {
        TGConfigDefaults.loadProperty(properties, "skin", "Lavender");
        TGConfigDefaults.loadProperty(properties, "window.title", "${appname} - ${filename}");
        TGConfigDefaults.loadProperty(properties, "show.splash", true);
        TGConfigDefaults.loadProperty(properties, "window.maximized", false);
        TGConfigDefaults.loadProperty(properties, "window.width", 800);
        TGConfigDefaults.loadProperty(properties, "window.height", 600);
        TGConfigDefaults.loadProperty(properties, "show.instruments", false);
        TGConfigDefaults.loadProperty(properties, "show.transport", false);
        TGConfigDefaults.loadProperty(properties, "show.fretboard", false);
        TGConfigDefaults.loadProperty(properties, "show.piano", false);
        TGConfigDefaults.loadProperty(properties, "show.markers", false);
        TGConfigDefaults.loadProperty(properties, "layout.mode", 1);
        TGConfigDefaults.loadProperty(properties, "layout.style", 45);
        TGConfigDefaults.loadProperty(properties, "editor.mouse.mode", 1);
        TGConfigDefaults.loadProperty(properties, "editor.natural.key.mode", true);
        TGConfigDefaults.loadProperty(properties, "font.default", DEFAULT_FONT_NAME + ",6,0");
        TGConfigDefaults.loadProperty(properties, "font.note", DEFAULT_FONT_NAME + ",7,0");
        TGConfigDefaults.loadProperty(properties, "font.time-signature", DEFAULT_FONT_NAME + ",13,1");
        TGConfigDefaults.loadProperty(properties, "font.lyric", DEFAULT_FONT_NAME + ",7,0");
        TGConfigDefaults.loadProperty(properties, "font.text", DEFAULT_FONT_NAME + ",8,0");
        TGConfigDefaults.loadProperty(properties, "font.chord", DEFAULT_FONT_NAME + ",7,0");
        TGConfigDefaults.loadProperty(properties, "font.chord-fret", DEFAULT_FONT_NAME + ",5,0");
        TGConfigDefaults.loadProperty(properties, "font.grace", DEFAULT_FONT_NAME + ",6,0");
        TGConfigDefaults.loadProperty(properties, "font.marker", DEFAULT_FONT_NAME + ",7,0");
        TGConfigDefaults.loadProperty(properties, "font.printer.default", DEFAULT_FONT_NAME + ",6,0");
        TGConfigDefaults.loadProperty(properties, "font.printer.note", DEFAULT_FONT_NAME + ",6,0");
        TGConfigDefaults.loadProperty(properties, "font.printer.time-signature", DEFAULT_FONT_NAME + ",10,1");
        TGConfigDefaults.loadProperty(properties, "font.printer.lyric", DEFAULT_FONT_NAME + ",7,0");
        TGConfigDefaults.loadProperty(properties, "font.printer.text", DEFAULT_FONT_NAME + ",8,0");
        TGConfigDefaults.loadProperty(properties, "font.printer.chord", DEFAULT_FONT_NAME + ",7,0");
        TGConfigDefaults.loadProperty(properties, "font.printer.grace", DEFAULT_FONT_NAME + ",6,0");
        TGConfigDefaults.loadProperty(properties, "font.about.dialog.title", DEFAULT_FONT_NAME + ",36,3");
        TGConfigDefaults.loadProperty(properties, "color.background", "255,255,255");
        TGConfigDefaults.loadProperty(properties, "color.line", "214,214,214");
        TGConfigDefaults.loadProperty(properties, "color.score.note", "64,64,64");
        TGConfigDefaults.loadProperty(properties, "color.tab.note", "64,64,64");
        TGConfigDefaults.loadProperty(properties, "color.play.note", "255,0,0");
        TGConfigDefaults.loadProperty(properties, "color.caret.1", "127,127,127");
        TGConfigDefaults.loadProperty(properties, "color.caret.2", "165,42,42");
        TGConfigDefaults.loadProperty(properties, "color.loop.s.marker", "42,165,42");
        TGConfigDefaults.loadProperty(properties, "color.loop.e.marker", "165,42,42");
        TGConfigDefaults.loadProperty(properties, "history.max-files", 10);
        TGConfigDefaults.loadProperty(properties, "score.min.score-tab-spacing", 20);
        TGConfigDefaults.loadProperty(properties, "score.line-spacing", 8);
        TGConfigDefaults.loadProperty(properties, "tab.line-spacing", 10);
        TGConfigDefaults.loadProperty(properties, "first-track.spacing", 20);
        TGConfigDefaults.loadProperty(properties, "track.spacing", 10);
        TGConfigDefaults.loadProperty(properties, "language", "");
        TGConfigDefaults.loadProperty(properties, "fretboard.string-spacing", 20);
        TGConfigDefaults.loadProperty(properties, "fretboard.style", 2);
        TGConfigDefaults.loadProperty(properties, "fretboard.direction", 0);
        TGConfigDefaults.loadProperty(properties, "fretboard.font", DEFAULT_FONT_NAME + ",8,1");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.background", "0,0,0");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.string", "227,217,217");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.fret-point", "192,192,192");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.note", "42,85,128");
        TGConfigDefaults.loadProperty(properties, "fretboard.color.scale", "128,32,32");
        TGConfigDefaults.loadProperty(properties, "piano.color.natural-key", "255,255,255");
        TGConfigDefaults.loadProperty(properties, "piano.color.not-natural-key", "0,0,0");
        TGConfigDefaults.loadProperty(properties, "piano.color.note", "42,85,128");
        TGConfigDefaults.loadProperty(properties, "piano.color.scale", "128,32,32");
        TGConfigDefaults.loadProperty(properties, "matrix.font", DEFAULT_FONT_NAME + ",8,1");
        TGConfigDefaults.loadProperty(properties, "matrix.color.foreground", "190,190,190");
        TGConfigDefaults.loadProperty(properties, "matrix.color.border", "25,25,25");
        TGConfigDefaults.loadProperty(properties, "matrix.color.position", "190,190,190");
        TGConfigDefaults.loadProperty(properties, "matrix.color.note", "42,85,128");
        TGConfigDefaults.loadProperty(properties, "matrix.color.play-note", "128,32,32");
        TGConfigDefaults.loadProperty(properties, "matrix.color.line-1", "255,255,255");
        TGConfigDefaults.loadProperty(properties, "matrix.color.line-2", "230,230,250");
        TGConfigDefaults.loadProperty(properties, "matrix.color.line-3", "173,216,230");
        TGConfigDefaults.loadProperty(properties, "table.auto-size", true);
        TGConfigDefaults.loadProperty(properties, "browser.lines-visible", true);
    }

    private static void loadProperty(TGProperties properties, String key, String value) {
        properties.setValue(key, value);
    }

    private static void loadProperty(TGProperties properties, String key, int value) {
        properties.setValue(key, Integer.toString(value));
    }

    private static void loadProperty(TGProperties properties, String key, boolean value) {
        properties.setValue(key, Boolean.toString(value));
    }

    private static String getDefaultFontName() {
        FontData[] fd;
        Font font = TuxGuitar.getInstance().getDisplay().getSystemFont();
        if (font != null && (fd = font.getFontData()) != null && fd.length > 0) {
            return fd[0].getName();
        }
        return new String();
    }
}

