/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.printer;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.printer.PrintDocument;
import org.herac.tuxguitar.app.printer.PrintStyles;
import org.herac.tuxguitar.graphics.TGFont;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLyricImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGTrack;

public class PrintLayout
extends TGLayout {
    private PrintStyles styles;
    private PrintDocument document;
    private int page;
    private TGFont songNameFont;
    private TGFont trackNameFont;
    private TGFont songAuthorFont;

    public PrintLayout(TGController controller, PrintStyles styles) {
        super(controller, styles.getStyle() | 1);
        this.styles = styles;
    }

    public int getMode() {
        return 0;
    }

    public void makeDocument(PrintDocument document) {
        this.page = 0;
        this.document = document;
        this.makeDocument();
    }

    private void makeDocument() {
        this.document.start();
        this.openPage();
        this.paintHeader(this.document.getPainter());
        this.paintSong(this.document.getPainter(), null, this.document.getBounds().getX(), this.document.getBounds().getY() + 80.0f * this.getScale());
        this.paintFooter(this.document.getPainter());
        this.closePage();
        this.document.finish();
    }

    public void paintSong(TGPainter painter, TGRectangle clientArea, float fromX, float fromY) {
        this.setWidth(0.0f);
        this.setHeight(0.0f);
        int style = this.getStyle();
        float posY = Math.round(fromY + this.getFirstTrackSpacing());
        float height = this.getFirstTrackSpacing();
        float lineHeight = 0.0f;
        TGTrackImpl track = (TGTrackImpl)this.getSongManager().getTrack(this.getSong(), this.styles.getTrackNumber());
        ((TGLyricImpl)track.getLyrics()).start(this.getSkippedBeats((TGTrack)track));
        TGTrackSpacing ts = new TGTrackSpacing((TGLayout)this);
        TempLine line = this.getTempLines((TGTrack)track, this.styles.getFromMeasure() - 1, ts);
        while (!line.measures.isEmpty()) {
            ts.setSize(8, (style & 4) != 0 ? this.getScoreLineSpacing() * 5.0f : 0.0f);
            if ((style & 4) != 0) {
                ts.setSize(7, Math.abs(line.minY));
                if (line.maxY > track.getScoreHeight()) {
                    ts.setSize(9, line.maxY - track.getScoreHeight());
                }
            }
            if ((style & 8) != 0) {
                ts.setSize(12, (style & 4) != 0 ? this.getMinScoreTabSpacing() : Math.max(Math.abs(line.minY), this.getStringSpacing()));
                ts.setSize(13, (style & 4) != 0 ? track.getTabHeight() + this.getStringSpacing() + 1.0f : Math.max(line.maxY, track.getTabHeight() + this.getStringSpacing() + 1.0f));
            }
            ts.setSize(14, 10.0f);
            this.checkDefaultSpacing(ts);
            lineHeight = ts.getSize();
            if (posY + lineHeight + this.getTrackSpacing() > this.document.getBounds().getY() + this.getMaxHeight()) {
                this.paintFooter(painter);
                this.closePage();
                this.openPage();
                posY = Math.round(this.document.getBounds().getY() + this.getFirstTrackSpacing());
            }
            this.paintLine(track, line, painter, fromX, posY, ts);
            float lineHeightWithSpacing = Math.round(lineHeight + this.getTrackSpacing() + 0.5f);
            posY += lineHeightWithSpacing;
            height += lineHeightWithSpacing;
            ts = new TGTrackSpacing((TGLayout)this);
            line = this.getTempLines((TGTrack)track, line.lastIndex + 1, ts);
        }
        this.setHeight(height);
    }

    public void paintHeader(TGPainter painter) {
        if (this.document.isPaintable(this.page)) {
            float x = this.document.getBounds().getX();
            float y = this.document.getBounds().getY();
            String songName = this.getSong().getName();
            String songAuthor = this.getSong().getAuthor();
            String trackName = "(" + this.getSongManager().getTrack(this.getSong(), this.styles.getTrackNumber()).getName() + ")";
            if (songName == null || songName.length() == 0) {
                songName = TuxGuitar.getProperty("print-header.default-song-name");
            }
            if (songAuthor == null || songAuthor.length() == 0) {
                songAuthor = TuxGuitar.getProperty("print-header.default-song-author");
            }
            painter.setFont(this.getSongNameFont((TGResourceFactory)painter));
            painter.drawString(songName, x + this.getCenter(painter, songName), y);
            painter.setFont(this.getTrackNameFont((TGResourceFactory)painter));
            painter.drawString(trackName, x + this.getCenter(painter, trackName), y + (float)Math.round(30.0f * this.getScale()));
            painter.setFont(this.getSongAuthorFont((TGResourceFactory)painter));
            painter.drawString(songAuthor, x + this.getRight(painter, songAuthor), y + (float)Math.round(50.0f * this.getScale()));
        }
    }

    private void paintFooter(TGPainter painter) {
        if (this.document.isPaintable(this.page)) {
            float x = this.document.getBounds().getX();
            float y = this.document.getBounds().getY();
            String pageNumber = Integer.toString(this.page);
            painter.setBackground(this.getResources().getColorWhite());
            painter.setForeground(this.getResources().getColorBlack());
            painter.drawString(pageNumber, x + this.getRight(painter, pageNumber), y + this.getBottom(painter, pageNumber));
        }
    }

    public void paintLine(TGTrackImpl track, TempLine line, TGPainter painter, float fromX, float fromY, TGTrackSpacing ts) {
        if (this.document.isPaintable(this.page)) {
            float diff;
            float posX = fromX;
            float posY = fromY;
            float width = 0.0f;
            float defaultMeasureSpacing = 0.0f;
            if (line.fullLine && (diff = this.getMaxWidth() - line.tempWith) != 0.0f && line.measures.size() > 0) {
                defaultMeasureSpacing = diff / (float)line.measures.size();
            }
            float measureSpacing = defaultMeasureSpacing;
            for (int i = 0; i < line.measures.size(); ++i) {
                int index = line.measures.get(i);
                TGMeasureImpl currMeasure = (TGMeasureImpl)track.getMeasure(index);
                currMeasure.setPosX(posX);
                currMeasure.setPosY(posY);
                currMeasure.setTs(ts);
                ((TGLyricImpl)track.getLyrics()).setCurrentMeasure(currMeasure);
                currMeasure.setFirstOfLine(i == 0);
                float measureWidth = currMeasure.getWidth((TGLayout)this);
                float measureWidthWithSpacing = this.isBufferEnabled() ? (float)Math.round(measureWidth + measureSpacing) : measureWidth + measureSpacing;
                float measureSpacingAfterRound = measureWidthWithSpacing - measureWidth;
                this.paintMeasure(currMeasure, painter, measureSpacingAfterRound);
                ((TGLyricImpl)track.getLyrics()).paintCurrentNoteBeats(painter, (TGLayout)this, currMeasure, posX, posY);
                posX += measureWidthWithSpacing;
                width += measureWidthWithSpacing;
                measureSpacing = defaultMeasureSpacing + (measureSpacing - measureSpacingAfterRound);
            }
            this.setWidth(Math.max(this.getWidth(), width));
        }
    }

    private void openPage() {
        ++this.page;
        if (this.document.isPaintable(this.page)) {
            this.document.pageStart();
        }
    }

    private void closePage() {
        if (this.document.isPaintable(this.page)) {
            this.document.pageFinish();
        }
    }

    private float getCenter(TGPainter painter, String text) {
        return (this.getMaxWidth() - painter.getFMWidth(text)) / 2.0f;
    }

    private float getRight(TGPainter painter, String text) {
        return this.getMaxWidth() - painter.getFMWidth(text);
    }

    private float getBottom(TGPainter painter, String text) {
        return this.getMaxHeight() - painter.getFMHeight();
    }

    private TempLine getTempLines(TGTrack track, int fromIndex, TGTrackSpacing ts) {
        TempLine line = new TempLine();
        int measureCount = track.countMeasures();
        for (int measureIdx = fromIndex; measureIdx < measureCount; ++measureIdx) {
            TGMeasureImpl measure = (TGMeasureImpl)track.getMeasure(measureIdx);
            if (measure.getNumber() < this.styles.getFromMeasure() || measure.getNumber() > this.styles.getToMeasure()) continue;
            if (line.tempWith + measure.getWidth((TGLayout)this) >= this.getMaxWidth()) {
                if (line.measures.isEmpty()) {
                    this.addToTempLine(line, ts, measure, measureIdx);
                }
                line.fullLine = true;
                return line;
            }
            this.addToTempLine(line, ts, measure, measureIdx);
        }
        return line;
    }

    private void addToTempLine(TempLine line, TGTrackSpacing ts, TGMeasureImpl measure, int measureIdx) {
        line.tempWith += measure.getWidth((TGLayout)this);
        line.maxY = measure.getMaxY() > line.maxY ? measure.getMaxY() : line.maxY;
        line.minY = measure.getMinY() < line.minY ? measure.getMinY() : line.minY;
        line.addMeasure(measureIdx);
        measure.registerSpacing((TGLayout)this, ts);
    }

    private int getSkippedBeats(TGTrack track) {
        int beats = 0;
        for (int i = 0; i < this.styles.getFromMeasure() - 1; ++i) {
            TGMeasureImpl measure = (TGMeasureImpl)track.getMeasure(i);
            beats += measure.getNotEmptyBeats();
        }
        return beats;
    }

    public boolean isPlayModeEnabled() {
        return false;
    }

    public float getMaxWidth() {
        return this.document.getBounds().getWidth() - this.document.getBounds().getX() - 10.0f;
    }

    public float getMaxHeight() {
        return this.document.getBounds().getHeight() - this.document.getBounds().getY() - 10.0f;
    }

    public boolean isFirstMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == this.styles.getFromMeasure();
    }

    public boolean isLastMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == this.styles.getToMeasure();
    }

    public TGFont getSongNameFont(TGResourceFactory factory) {
        if (factory != null && (this.songNameFont == null || this.songNameFont.isDisposed())) {
            this.songNameFont = factory.createFont(this.getResources().getDefaultFont().getName(), 16.0f * this.getFontScale(), true, false);
        }
        return this.songNameFont;
    }

    public TGFont getSongAuthorFont(TGResourceFactory factory) {
        if (factory != null && (this.songAuthorFont == null || this.songAuthorFont.isDisposed())) {
            this.songAuthorFont = factory.createFont(this.getResources().getDefaultFont().getName(), 8.0f * this.getFontScale(), true, false);
        }
        return this.songAuthorFont;
    }

    public TGFont getTrackNameFont(TGResourceFactory factory) {
        if (factory != null && (this.trackNameFont == null || this.trackNameFont.isDisposed())) {
            this.trackNameFont = factory.createFont(this.getResources().getDefaultFont().getName(), 8.0f * this.getFontScale(), true, false);
        }
        return this.trackNameFont;
    }

    public void disposeLayout() {
        super.disposeLayout();
        if (this.songNameFont != null && !this.songNameFont.isDisposed()) {
            this.songNameFont.dispose();
        }
        if (this.songAuthorFont != null && !this.songAuthorFont.isDisposed()) {
            this.songAuthorFont.dispose();
        }
        if (this.trackNameFont != null && !this.trackNameFont.isDisposed()) {
            this.trackNameFont.dispose();
        }
    }

    private class TempLine {
        protected float tempWith;
        protected int lastIndex;
        protected boolean fullLine;
        protected float maxY = 0.0f;
        protected float minY = 50.0f;
        protected List<Integer> measures = new ArrayList<Integer>();

        protected void addMeasure(int index) {
            this.measures.add(new Integer(index));
            this.lastIndex = index;
        }
    }
}

