/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.listener.lock;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.util.TGContext;

public class TGLockableActionListener
implements TGEventListener {
    private TGContext context;
    private List<String> actionIds;

    public TGLockableActionListener(TGContext context) {
        this.context = context;
        this.actionIds = new ArrayList<String>();
    }

    public boolean containsActionId(String id) {
        return this.actionIds.contains(id);
    }

    public void addActionId(String id) {
        this.actionIds.add(id);
    }

    public void removeActionId(String id) {
        this.actionIds.remove(id);
    }

    public void checkForLock(String actionId) {
        if (this.containsActionId(actionId)) {
            TGEditorManager.getInstance((TGContext)this.context).lock();
        }
    }

    public void checkForUnlock(String actionId) {
        if (this.containsActionId(actionId)) {
            TGEditorManager.getInstance((TGContext)this.context).unlock();
        }
    }

    public void processEvent(TGEvent event) {
        if ("action-pre-execution".equals(event.getEventType())) {
            this.checkForLock((String)event.getAttribute("actionId"));
        } else if ("action-post-execution".equals(event.getEventType())) {
            this.checkForUnlock((String)event.getAttribute("actionId"));
        } else if ("action-error".equals(event.getEventType())) {
            this.checkForUnlock((String)event.getAttribute("actionId"));
        }
    }
}

