/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.io.File;
import java.net.URL;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstaller;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerlistener;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorManager;

public class SBInstallerGui
implements SBInstallerlistener {
    private static final String SB_PATH = TGFileUtils.PATH_USER_PLUGINS_CONFIG + File.separator + "tuxguitar-jsa";
    private TGContext context;
    private Shell dialog;
    private Label progressLabel;
    private SBInstaller installer;

    public SBInstallerGui(TGContext context, URL url, MidiPortSynthesizer synthesizer) {
        this.context = context;
        this.initInstaller(url, synthesizer);
    }

    public void initInstaller(URL url, MidiPortSynthesizer synthesizer) {
        File tmpPath = new File(SB_PATH);
        File dstPath = new File(SB_PATH);
        if (!tmpPath.exists()) {
            tmpPath.mkdirs();
        }
        if (!dstPath.exists()) {
            dstPath.mkdirs();
        }
        this.installer = new SBInstaller(this.context, url, tmpPath, dstPath, synthesizer, this);
    }

    public void open() {
        this.dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        this.dialog.setLayout((Layout)new GridLayout());
        Composite header = new Composite((Composite)this.dialog, 0);
        header.setLayout((Layout)new GridLayout(2, false));
        header.setLayoutData((Object)new GridData(4, 128, true, false));
        Label headerImage = new Label(header, 0);
        headerImage.setImage(TuxGuitar.getInstance().getDisplay().getSystemImage(2));
        headerImage.setLayoutData((Object)new GridData(16384, 128, false, false));
        Label headerTip = new Label(header, 64);
        headerTip.setLayoutData((Object)new GridData(4, 128, true, false));
        headerTip.setText(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.process.tip"));
        FontData[] fontData = headerTip.getFont().getFontData();
        for (int i = 0; i < fontData.length; ++i) {
            fontData[i].setStyle(1);
        }
        final Font font = new Font((Device)headerTip.getDisplay(), fontData);
        headerTip.setFont(font);
        headerTip.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                font.dispose();
            }
        });
        Composite composite = new Composite((Composite)this.dialog, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ProgressBar progressBar = new ProgressBar(composite, 2);
        progressBar.setLayoutData((Object)new GridData(4, 128, true, false));
        this.progressLabel = new Label(composite, 64);
        this.progressLabel.setLayoutData((Object)new GridData(4, 128, true, true));
        Composite buttons = new Composite((Composite)this.dialog, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(131072, 1024, true, false));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SBInstallerGui.this.getInstaller().setCancelled(true);
                SBInstallerGui.this.getDialog().dispose();
            }
        });
        this.process();
        DialogUtils.openDialog((Shell)this.dialog, (int)10);
    }

    private void process() {
        new Thread(new Runnable(){

            public void run() throws TGException {
                if (!SBInstallerGui.this.isDisposed()) {
                    SBInstallerGui.this.getInstaller().process();
                }
            }
        }).start();
    }

    public void notifyProcess(final String process) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getProgressLabel().setText(process);
                    }
                }
            });
        }
    }

    public void notifyFinish() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getDialog().dispose();
                    }
                }
            });
        }
    }

    public void notifyFailed(final Throwable throwable) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                public void run() {
                    if (!SBInstallerGui.this.isDisposed()) {
                        SBInstallerGui.this.getDialog().dispose();
                        TGErrorManager.getInstance((TGContext)SBInstallerGui.this.context).handleError(throwable);
                    }
                }
            });
        }
    }

    public boolean isDisposed() {
        return TuxGuitar.isDisposed() || this.getDialog().isDisposed();
    }

    public Shell getDialog() {
        return this.dialog;
    }

    public Label getProgressLabel() {
        return this.progressLabel;
    }

    public SBInstaller getInstaller() {
        return this.installer;
    }
}

