/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerGui;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBUrl;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class SBAssistant {
    public static final SBUrl[] URLS = new SBUrl[]{new SBUrl(SBAssistant.toURL("http://www.oracle.com/technetwork/java/soundbank-min-150078.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.minimal")), new SBUrl(SBAssistant.toURL("http://www.oracle.com/technetwork/java/soundbank-mid-149984.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.medium")), new SBUrl(SBAssistant.toURL("http://www.oracle.com/technetwork/java/soundbank-deluxe-150042.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.deluxe"))};
    private TGContext context;
    private MidiPortSynthesizer synthesizer;

    public SBAssistant(TGContext context, MidiPortSynthesizer synthesizer) {
        this.context = context;
        this.synthesizer = synthesizer;
    }

    public void process() {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
        tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty((String)"jsa.soundbank-assistant.confirm-message"));
        tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO));
        tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_NO);
        tgActionProcessor.setAttribute("yesRunnable", (Object)new Runnable(){

            public void run() {
                TGSynchronizer.getInstance((TGContext)SBAssistant.this.context).executeLater(new Runnable(){

                    public void run() {
                        SBAssistant.this.open();
                    }
                });
            }
        });
        tgActionProcessor.process();
    }

    protected void open() {
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)this.getGroupData());
        group.setText(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.select"));
        final Button[] urls = new Button[URLS.length];
        for (int i = 0; i < URLS.length; ++i) {
            urls[i] = new Button((Composite)group, 16);
            urls[i].setText(URLS[i].getName());
            urls[i].setData((Object)URLS[i]);
            urls[i].setSelection(i == 0);
        }
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(131072, 1024, true, false));
        Button buttonOk = new Button(buttons, 8);
        buttonOk.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOk.setLayoutData((Object)this.getButtonsData());
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                URL url = SBAssistant.this.getSelection(urls);
                dialog.dispose();
                if (url != null) {
                    SBAssistant.this.install(url);
                }
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)this.getButtonsData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOk);
        DialogUtils.openDialog((Shell)dialog, (int)10);
    }

    protected GridData getGroupData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 250;
        return data;
    }

    protected GridData getButtonsData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    protected URL getSelection(Button[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].getSelection() || !(buttons[i].getData() instanceof SBUrl)) continue;
            return ((SBUrl)buttons[i].getData()).getUrl();
        }
        return null;
    }

    protected void install(URL url) {
        new SBInstallerGui(this.context, url, this.synthesizer).open();
    }

    private static URL toURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

