/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.image;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.printer.PrintStyles;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.io.base.TGSongStreamContext;
import org.herac.tuxguitar.io.image.ImageExporterSettings;
import org.herac.tuxguitar.io.image.ImageFormat;
import org.herac.tuxguitar.song.models.TGSong;

public class ImageExporterSettingsDialog {
    public void openSettingsDialog(final TGSongStreamContext context, final Runnable callback) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final PrintStyles styles = this.createDefaultStyles(song);
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty((String)"options"));
        Group formatGroup = new Group((Composite)dialog, 16);
        formatGroup.setLayout((Layout)new GridLayout(2, false));
        formatGroup.setLayoutData((Object)ImageExporterSettingsDialog.getGroupData());
        formatGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-image.format"));
        Label formatLabel = new Label((Composite)formatGroup, 0);
        formatLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-image.format"));
        final Combo formatCombo = new Combo((Composite)formatGroup, 12);
        formatCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < ImageFormat.IMAGE_FORMATS.length; ++i) {
            formatCombo.add(ImageFormat.IMAGE_FORMATS[i].getName());
        }
        formatCombo.select(0);
        Group track = new Group((Composite)dialog, 16);
        track.setLayout((Layout)new GridLayout(2, false));
        track.setLayoutData((Object)ImageExporterSettingsDialog.getGroupData());
        track.setText(TuxGuitar.getProperty((String)"track"));
        Label trackLabel = new Label((Composite)track, 0);
        trackLabel.setText(TuxGuitar.getProperty((String)"track"));
        final Combo tracks = new Combo((Composite)track, 12);
        tracks.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int number = 1; number <= song.countTracks(); ++number) {
            tracks.add(TuxGuitar.getInstance().getSongManager().getTrack(song, number).getName());
        }
        tracks.select(TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        Group range = new Group((Composite)dialog, 16);
        range.setLayout((Layout)new GridLayout(2, false));
        range.setLayoutData((Object)ImageExporterSettingsDialog.getGroupData());
        range.setText(TuxGuitar.getProperty((String)"print.range"));
        boolean minSelection = true;
        final int maxSelection = song.countMeasureHeaders();
        Label fromLabel = new Label((Composite)range, 0);
        fromLabel.setText(TuxGuitar.getProperty((String)"edit.from"));
        final Spinner fromSpinner = new Spinner((Composite)range, 2048);
        fromSpinner.setLayoutData((Object)ImageExporterSettingsDialog.getSpinnerData());
        fromSpinner.setMaximum(maxSelection);
        fromSpinner.setMinimum(1);
        fromSpinner.setSelection(1);
        Label toLabel = new Label((Composite)range, 0);
        toLabel.setText(TuxGuitar.getProperty((String)"edit.to"));
        final Spinner toSpinner = new Spinner((Composite)range, 2048);
        toSpinner.setLayoutData((Object)ImageExporterSettingsDialog.getSpinnerData());
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(maxSelection);
        toSpinner.setSelection(maxSelection);
        fromSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection = fromSpinner.getSelection();
                int toSelection = toSpinner.getSelection();
                if (fromSelection < 1) {
                    fromSpinner.setSelection(1);
                } else if (fromSelection > toSelection) {
                    fromSpinner.setSelection(toSelection);
                }
            }
        });
        toSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fromSelection;
                int toSelection = toSpinner.getSelection();
                if (toSelection < (fromSelection = fromSpinner.getSelection())) {
                    toSpinner.setSelection(fromSelection);
                } else if (toSelection > maxSelection) {
                    toSpinner.setSelection(maxSelection);
                }
            }
        });
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)ImageExporterSettingsDialog.getGroupData());
        options.setText(TuxGuitar.getProperty((String)"options"));
        final Button tablatureEnabled = new Button((Composite)options, 32);
        tablatureEnabled.setText(TuxGuitar.getProperty((String)"export.tablature-enabled"));
        tablatureEnabled.setSelection(true);
        final Button scoreEnabled = new Button((Composite)options, 32);
        scoreEnabled.setText(TuxGuitar.getProperty((String)"export.score-enabled"));
        scoreEnabled.setSelection(true);
        final Button chordNameEnabled = new Button((Composite)options, 32);
        chordNameEnabled.setText(TuxGuitar.getProperty((String)"export.chord-name-enabled"));
        chordNameEnabled.setSelection(true);
        final Button chordDiagramEnabled = new Button((Composite)options, 32);
        chordDiagramEnabled.setText(TuxGuitar.getProperty((String)"export.chord-diagram-enabled"));
        chordDiagramEnabled.setSelection(true);
        final Button blackAndWhite = new Button((Composite)options, 32);
        blackAndWhite.setText(TuxGuitar.getProperty((String)"export.black-and-white"));
        blackAndWhite.setSelection(true);
        tablatureEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!tablatureEnabled.getSelection()) {
                    scoreEnabled.setSelection(true);
                }
            }
        });
        scoreEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!scoreEnabled.getSelection()) {
                    tablatureEnabled.setSelection(true);
                }
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)ImageExporterSettingsDialog.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int format = formatCombo.getSelectionIndex();
                if (format < 0 || format >= ImageFormat.IMAGE_FORMATS.length) {
                    format = 0;
                }
                int style = 0;
                style |= scoreEnabled.getSelection() ? 4 : 0;
                style |= tablatureEnabled.getSelection() ? 8 : 0;
                style |= chordNameEnabled.getSelection() ? 16 : 0;
                style |= chordDiagramEnabled.getSelection() ? 32 : 0;
                int n = blackAndWhite.getSelection() ? 64 : 0;
                styles.setTrackNumber(tracks.getSelectionIndex() + 1);
                styles.setFromMeasure(fromSpinner.getSelection());
                styles.setToMeasure(toSpinner.getSelection());
                styles.setStyle(style |= n);
                dialog.dispose();
                ImageExporterSettings settings = new ImageExporterSettings();
                settings.setStyles(styles);
                settings.setFormat(ImageFormat.IMAGE_FORMATS[format]);
                ImageExporterSettingsDialog.this.openDirectoryDialog(settings, context, callback);
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)ImageExporterSettingsDialog.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)10);
    }

    public void openDirectoryDialog(ImageExporterSettings settings, TGSongStreamContext context, Runnable callback) {
        DirectoryDialog dialog = new DirectoryDialog(TuxGuitar.getInstance().getShell());
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-image.directory-dialog.title"));
        settings.setPath(dialog.open());
        if (settings.getPath() != null) {
            context.setAttribute(ImageExporterSettings.class.getName(), (Object)settings);
            callback.run();
        }
    }

    public PrintStyles createDefaultStyles(TGSong song) {
        PrintStyles styles = new PrintStyles();
        styles.setStyle(8);
        styles.setFromMeasure(1);
        styles.setToMeasure(song.countMeasureHeaders());
        styles.setTrackNumber(1);
        return styles;
    }

    private static GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private static GridData getSpinnerData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 60;
        return data;
    }

    private static GridData getGroupData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 300;
        return data;
    }
}

