/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerDialog;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerSettings;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.util.TGContext;

public class TGTunerSettingsDialog {
    private static final int SHELL_WIDTH = 350;
    protected TGTunerDialog tunerDialog = null;
    protected Combo sampleRateCombo = null;
    protected Combo sampleSizeCombo = null;
    protected Combo bufferSizeCombo = null;
    protected Combo FFTSizeCombo = null;
    protected Scale noiseGate = null;
    protected Label noiseGateValue = null;
    protected Text settingsInfo = null;
    protected boolean updated;

    public TGTunerSettingsDialog(TGTunerDialog dialog) {
        this.tunerDialog = dialog;
        this.updated = false;
    }

    public void show() {
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)2160);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
        dialog.setText(TuxGuitar.getProperty((String)"tuner.settings"));
        dialog.setMinimumSize(350, -1);
        Group group = new Group((Composite)dialog, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuner.device-settings"));
        Composite sampleComposite = this.createGroup(TuxGuitar.getProperty((String)"tuner.sound-format"), (Composite)group);
        new Label(sampleComposite, 16384).setText(TuxGuitar.getProperty((String)"tuner.sample-rate"));
        this.sampleRateCombo = new Combo(sampleComposite, 12);
        this.sampleRateCombo.add("48000");
        this.sampleRateCombo.add("44100");
        this.sampleRateCombo.add("22050");
        this.sampleRateCombo.add("11025");
        this.sampleRateCombo.add("8000");
        this.sampleRateCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        new Label(sampleComposite, 16384).setText(TuxGuitar.getProperty((String)"tuner.sample-size"));
        this.sampleSizeCombo = new Combo(sampleComposite, 12);
        this.sampleSizeCombo.add("16");
        this.sampleSizeCombo.add("8");
        this.sampleSizeCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        Composite analyzeComposite = this.createGroup(TuxGuitar.getProperty((String)"tuner.sampling-and-analyze"), (Composite)group);
        new Label(analyzeComposite, 16384).setText(TuxGuitar.getProperty((String)"tuner.sampling-buffer-size"));
        this.bufferSizeCombo = new Combo(analyzeComposite, 12);
        this.bufferSizeCombo.add(new Integer(512).toString());
        this.bufferSizeCombo.add(new Integer(1024).toString());
        this.bufferSizeCombo.add(new Integer(2048).toString());
        this.bufferSizeCombo.add(new Integer(4096).toString());
        this.bufferSizeCombo.add(new Integer(8192).toString());
        this.bufferSizeCombo.add(new Integer(16348).toString());
        this.bufferSizeCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        new Label(analyzeComposite, 16384).setText(TuxGuitar.getProperty((String)"tuner.fourier-buffer-size"));
        this.FFTSizeCombo = new Combo(analyzeComposite, 12);
        this.FFTSizeCombo.add(new Integer(1024).toString());
        this.FFTSizeCombo.add(new Integer(2048).toString());
        this.FFTSizeCombo.add(new Integer(4096).toString());
        this.FFTSizeCombo.add(new Integer(8192).toString());
        this.FFTSizeCombo.add(new Integer(16384).toString());
        this.FFTSizeCombo.add(new Integer(32768).toString());
        this.FFTSizeCombo.addSelectionListener((SelectionListener)new UpdatedListener());
        Composite noiseGateComposite = this.createGroup(TuxGuitar.getProperty((String)"tuner.noise-gate"), (Composite)group);
        this.noiseGate = new Scale(noiseGateComposite, 2048);
        this.noiseGate.setMaximum(100);
        this.noiseGate.setIncrement(5);
        this.noiseGate.setPageIncrement(10);
        this.noiseGate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTunerSettingsDialog.this.noiseGateValue.setText(new Integer(TGTunerSettingsDialog.this.noiseGate.getSelection()).toString() + "%");
            }
        });
        this.noiseGate.addSelectionListener((SelectionListener)new UpdatedListener());
        this.noiseGate.setLayoutData((Object)new GridData(0, 0, true, false, 1, 1));
        ((GridData)this.noiseGate.getLayoutData()).widthHint = 270;
        ((GridData)this.noiseGate.getLayoutData()).grabExcessHorizontalSpace = true;
        this.noiseGateValue = new Label(noiseGateComposite, 16384);
        this.noiseGateValue.setText("                       ");
        Composite infoComposite = this.createGroup(TuxGuitar.getProperty((String)"tuner.info"), (Composite)group);
        this.settingsInfo = new Text(infoComposite, 10);
        this.settingsInfo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        ((GridData)this.settingsInfo.getLayoutData()).heightHint = 30;
        ((GridData)this.settingsInfo.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)this.settingsInfo.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.settingsInfo.getLayoutData()).widthHint = 300;
        Composite btnComposite = new Composite((Composite)dialog, 0);
        btnComposite.setLayout((Layout)new GridLayout(2, false));
        btnComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Button buttonOK = new Button(btnComposite, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTunerSettingsDialog.this.dispose(dialog, true);
            }
        });
        Button buttonExit = new Button(btnComposite, 8);
        buttonExit.setText(TuxGuitar.getProperty((String)"close"));
        buttonExit.setLayoutData((Object)TGTunerDialog.getGridData(80, 25));
        buttonExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TGTunerSettingsDialog.this.dispose(dialog, false);
            }
        });
        this.loadSettings(this.tunerDialog.getTuner().getSettings(), dialog);
        DialogUtils.openDialog((Shell)dialog, (int)10);
    }

    protected void loadSettings(TGTunerSettings settings, Shell dialog) {
        block9: {
            boolean loadedDefaults = false;
            if (settings == null) {
                settings = TGTunerSettings.getDefaults();
                loadedDefaults = true;
            }
            boolean found = false;
            int i = 0;
            try {
                while (!found) {
                    if (Float.parseFloat(this.sampleRateCombo.getItem(i)) == settings.getSampleRate()) {
                        this.sampleRateCombo.select(i);
                        found = true;
                    }
                    ++i;
                }
                i = 0;
                found = false;
                while (!found) {
                    if (Integer.parseInt(this.sampleSizeCombo.getItem(i)) == settings.getSampleSize()) {
                        this.sampleSizeCombo.select(i);
                        found = true;
                    }
                    ++i;
                }
                i = 0;
                found = false;
                while (!found) {
                    if (Integer.parseInt(this.FFTSizeCombo.getItem(i)) == settings.getFFTSize()) {
                        this.FFTSizeCombo.select(i);
                        found = true;
                    }
                    ++i;
                }
                this.bufferSizeCombo.setText(new Integer(settings.getBufferSize()).toString());
                this.noiseGate.setSelection((int)Math.round(settings.getThreshold() * 100.0));
                this.noiseGateValue.setText(new Integer(this.noiseGate.getSelection()).toString() + "%");
            }
            catch (Exception ex) {
                if (loadedDefaults) break block9;
                TGMessageDialogUtil.errorMessage((TGContext)this.getContext(), (Shell)dialog, (String)"Failed to load TuxGuitar settings.\nLoading defaults.");
                this.loadSettings(TGTunerSettings.getDefaults(), dialog);
            }
        }
    }

    protected void dispose(Shell dialog, boolean saveWanted) {
        try {
            if (this.updated & saveWanted) {
                TGTunerSettings settings = new TGTunerSettings();
                settings.setSampleRate(this.getSampleRate());
                settings.setSampleSize(Integer.parseInt(this.sampleSizeCombo.getItem(this.sampleSizeCombo.getSelectionIndex())));
                settings.setBufferSize(this.getBufferSize());
                settings.setFFTSize(this.getFFTSize());
                settings.setThreshold((float)this.noiseGate.getSelection() / 100.0f);
                settings.setWaitPeriod(100);
                this.checkBufferValues(settings);
                this.tunerDialog.getTuner().setSettings(settings);
            }
            this.tunerDialog.getTuner().resumeFromPause();
            dialog.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TGMessageDialogUtil.errorMessage((TGContext)this.getContext(), (Shell)dialog, (String)ex.getMessage());
        }
    }

    private float getSampleRate() {
        return Float.parseFloat(this.sampleRateCombo.getItem(this.sampleRateCombo.getSelectionIndex()));
    }

    private int getFFTSize() {
        return Integer.parseInt(this.FFTSizeCombo.getItem(this.FFTSizeCombo.getSelectionIndex()));
    }

    private int getBufferSize() {
        return Integer.parseInt(this.bufferSizeCombo.getText());
    }

    protected Composite createGroup(String groupCaption, Composite parent) {
        Group tempGroup = new Group(parent, 16);
        tempGroup.setLayout((Layout)new GridLayout());
        tempGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        tempGroup.setText(groupCaption);
        Composite groupComposite = new Composite((Composite)tempGroup, 0);
        groupComposite.setLayout((Layout)new GridLayout(2, false));
        groupComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        return groupComposite;
    }

    protected void checkBufferValues(TGTunerSettings settings) throws Exception {
        if (settings.bufferSize % settings.sampleSize != 0 || settings.bufferSize > settings.fftSize) {
            throw new Exception("Invalid sampling buffer size");
        }
    }

    protected TGContext getContext() {
        return this.tunerDialog.getContext();
    }

    protected class UpdatedListener
    extends SelectionAdapter {
        protected UpdatedListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            TGTunerSettingsDialog.this.updated = true;
            TGTunerSettingsDialog.this.settingsInfo.setText(" Minimal freq diff = " + this.getMinimalFrequencyDiff() + "Hz   \n Time to fill the buffer = " + this.getTimeToFillBuffer() + " sec");
        }

        private double getMinimalFrequencyDiff() {
            return (double)TGTunerSettingsDialog.this.getSampleRate() / (double)TGTunerSettingsDialog.this.getFFTSize();
        }

        private double getTimeToFillBuffer() {
            return (float)TGTunerSettingsDialog.this.getBufferSize() / TGTunerSettingsDialog.this.getSampleRate();
        }
    }
}

