/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gervill;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGFileChooser;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserDialog;
import org.herac.tuxguitar.app.view.dialog.file.TGFileChooserHandler;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.gervill.MidiToAudioSettings;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiToAudioSettingsDialog {
    private TGContext context;
    protected boolean success;

    public MidiToAudioSettingsDialog(TGContext context) {
        this.context = context;
    }

    public boolean open(final MidiToAudioSettings settings) {
        this.success = false;
        final List<MidiToAudioFormat> formats = this.getAvailableFormats();
        final List<TGFileFormat> soundbankFormats = this.getSupportedSoundbankFormats();
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty((String)"gervill.options"));
        Group audioFormatGroup = new Group((Composite)dialog, 16);
        audioFormatGroup.setLayout((Layout)new GridLayout(2, false));
        audioFormatGroup.setLayoutData((Object)this.getGroupData());
        audioFormatGroup.setText(TuxGuitar.getProperty((String)"gervill.options.audio-format"));
        Label eLabel = new Label((Composite)audioFormatGroup, 0);
        eLabel.setText(TuxGuitar.getProperty((String)"gervill.options.file-encoding") + ":");
        eLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Combo eCombo = new Combo((Composite)audioFormatGroup, 12);
        eCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Label tLabel = new Label((Composite)audioFormatGroup, 0);
        tLabel.setText(TuxGuitar.getProperty((String)"gervill.options.file-type") + ":");
        tLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Combo tCombo = new Combo((Composite)audioFormatGroup, 12);
        tCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        int eSelectionIndex = 0;
        for (int i = 0; i < formats.size(); ++i) {
            MidiToAudioFormat format = formats.get(i);
            eCombo.add(format.getFormat().getEncoding().toString());
            if (!this.isSameEncoding(settings.getFormat(), format.getFormat())) continue;
            eSelectionIndex = i;
        }
        if (!formats.isEmpty()) {
            eCombo.select(eSelectionIndex);
            this.updateTypesCombo(settings, formats, eCombo, tCombo);
        }
        eCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidiToAudioSettingsDialog.this.updateTypesCombo(settings, formats, eCombo, tCombo);
            }
        });
        Group soundbankGroup = new Group((Composite)dialog, 16);
        soundbankGroup.setLayout((Layout)new GridLayout());
        soundbankGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        soundbankGroup.setText(TuxGuitar.getProperty((String)"gervill.options.soundbank.tip"));
        Button sbDefault = new Button((Composite)soundbankGroup, 16);
        sbDefault.setText(TuxGuitar.getProperty((String)"gervill.options.soundbank.default"));
        sbDefault.setSelection(settings.getSoundbankPath() == null);
        final Button sbCustom = new Button((Composite)soundbankGroup, 16);
        sbCustom.setText(TuxGuitar.getProperty((String)"gervill.options.soundbank.custom"));
        sbCustom.setSelection(settings.getSoundbankPath() != null);
        Composite chooser = new Composite((Composite)soundbankGroup, 0);
        chooser.setLayout((Layout)new GridLayout(2, false));
        final Text sbCustomPath = new Text(chooser, 2048);
        sbCustomPath.setLayoutData((Object)new GridData(350, -1));
        sbCustomPath.setText(settings.getSoundbankPath() == null ? new String() : settings.getSoundbankPath());
        sbCustomPath.setEnabled(settings.getSoundbankPath() != null);
        final Button sbCustomChooser = new Button(chooser, 8);
        sbCustomChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        sbCustomChooser.setEnabled(settings.getSoundbankPath() != null);
        sbCustomChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TGFileChooser.getInstance((TGContext)MidiToAudioSettingsDialog.this.context).openChooser(new TGFileChooserHandler(){

                    public void updateFileName(String fileName) {
                        sbCustomPath.setText(fileName);
                    }
                }, soundbankFormats, TGFileChooserDialog.STYLE_OPEN);
            }
        });
        SelectionAdapter sbRadioSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sbCustomPath.setEnabled(sbCustom.getSelection());
                sbCustomChooser.setEnabled(sbCustom.getSelection());
            }
        };
        sbDefault.addSelectionListener((SelectionListener)sbRadioSelectionListener);
        sbCustom.addSelectionListener((SelectionListener)sbRadioSelectionListener);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)data);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String soundbankPath = sbCustom.getSelection() ? sbCustomPath.getText() : null;
                int tIndex = tCombo.getSelectionIndex();
                int eIndex = eCombo.getSelectionIndex();
                if (eIndex >= 0 && eIndex < formats.size()) {
                    MidiToAudioFormat format = (MidiToAudioFormat)formats.get(eIndex);
                    if (tIndex >= 0 && tIndex < format.getTypes().length) {
                        settings.setType(format.getTypes()[tIndex]);
                        settings.setFormat(format.getFormat());
                        settings.setSoundbankPath(soundbankPath);
                        MidiToAudioSettingsDialog.this.success = true;
                    }
                }
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
        return this.success;
    }

    private GridData getGroupData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 300;
        return data;
    }

    private void updateTypesCombo(MidiToAudioSettings settings, List<MidiToAudioFormat> encodings, Combo eCombo, Combo tCombo) {
        tCombo.removeAll();
        int eIndex = eCombo.getSelectionIndex();
        if (eIndex >= 0 && eIndex < encodings.size()) {
            MidiToAudioFormat encoding = encodings.get(eIndex);
            AudioFileFormat.Type[] types = encoding.getTypes();
            int tSelectionIndex = 0;
            for (int tIndex = 0; tIndex < types.length; ++tIndex) {
                tCombo.add(types[tIndex] + " (*." + types[tIndex].getExtension() + ")");
                if (settings.getType() == null || !settings.getType().equals(types[tIndex])) continue;
                tSelectionIndex = tIndex;
            }
            tCombo.select(tSelectionIndex);
        }
    }

    public List<MidiToAudioFormat> getAvailableFormats() {
        ArrayList<MidiToAudioFormat> list = new ArrayList<MidiToAudioFormat>();
        AudioFormat srcFormat = MidiToAudioSettings.DEFAULT_FORMAT;
        AudioFormat.Encoding[] encodings = AudioSystem.getTargetEncodings(srcFormat);
        for (int i = 0; i < encodings.length; ++i) {
            AudioFormat dstFormat = new AudioFormat(encodings[i], srcFormat.getSampleRate(), srcFormat.getSampleSizeInBits(), srcFormat.getChannels(), srcFormat.getFrameSize(), srcFormat.getFrameRate(), srcFormat.isBigEndian());
            AudioInputStream dstStream = new AudioInputStream(null, dstFormat, 0L);
            AudioFileFormat.Type[] dstTypes = AudioSystem.getAudioFileTypes(dstStream);
            if (dstTypes.length <= 0) continue;
            list.add(new MidiToAudioFormat(dstFormat, dstTypes));
        }
        return list;
    }

    private List<TGFileFormat> getSupportedSoundbankFormats() {
        ArrayList<TGFileFormat> list = new ArrayList<TGFileFormat>();
        list.add(new TGFileFormat("SF2 files", new String[]{"sf2"}));
        list.add(new TGFileFormat("DLS files", new String[]{"dls"}));
        return list;
    }

    public boolean isSameEncoding(AudioFormat f1, AudioFormat f2) {
        if (f1 == null || f2 == null || f1.getEncoding() == null || f2.getEncoding() == null) {
            return false;
        }
        return f1.getEncoding().toString().equals(f2.getEncoding().toString());
    }

    private class MidiToAudioFormat {
        private AudioFormat format;
        private AudioFileFormat.Type[] types;

        public MidiToAudioFormat(AudioFormat format, AudioFileFormat.Type[] types) {
            this.format = format;
            this.types = types;
        }

        public AudioFormat getFormat() {
            return this.format;
        }

        public AudioFileFormat.Type[] getTypes() {
            return this.types;
        }
    }
}

