/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.io.midi.MidiSettings;

public class MidiSettingsDialog {
    public static final int MAX_TRANSPOSE = 24;
    public static final int MIN_TRANSPOSE = -24;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_CANCELLED = 1;
    private static final int STATUS_ACCEPTED = 2;
    protected int status;
    protected MidiSettings settings = new MidiSettings();

    public MidiSettings open() {
        this.status = 0;
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText("Options");
        Group trackGroup = new Group((Composite)dialog, 16);
        trackGroup.setLayout((Layout)new GridLayout(2, false));
        trackGroup.setLayoutData((Object)this.getGroupData());
        trackGroup.setText("Transpose notes");
        Label transposeLabel = new Label((Composite)trackGroup, 0);
        transposeLabel.setText("Transpose:");
        transposeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        final Combo transposeCombo = new Combo((Composite)trackGroup, 12);
        transposeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        for (int i = -24; i <= 24; ++i) {
            transposeCombo.add(Integer.toString(i));
        }
        transposeCombo.select(24);
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)data);
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MidiSettingsDialog.this.status = 2;
                MidiSettingsDialog.this.settings.setTranspose(-24 + transposeCombo.getSelectionIndex());
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MidiSettingsDialog.this.status = 1;
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
        return this.status == 2 ? this.settings : null;
    }

    private GridData getGroupData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 300;
        return data;
    }
}

