/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.svg;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.io.svg.SVGExporterStyles;
import org.herac.tuxguitar.song.models.TGSong;

public class SVGExporterStylesDialog
extends SVGExporterStyles {
    public void configure() {
        final Shell dialog = DialogUtils.newDialog((Shell)TuxGuitar.getInstance().getShell(), (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty((String)"options"));
        Group trackGroup = new Group((Composite)dialog, 16);
        trackGroup.setLayout((Layout)new GridLayout(2, false));
        trackGroup.setLayoutData((Object)SVGExporterStylesDialog.getGroupData());
        trackGroup.setText(TuxGuitar.getProperty((String)"track"));
        final Label trackLabel = new Label((Composite)trackGroup, 0);
        trackLabel.setText(TuxGuitar.getProperty((String)"track"));
        final Combo trackCombo = new Combo((Composite)trackGroup, 12);
        trackCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
        for (int number = 1; number <= song.countTracks(); ++number) {
            trackCombo.add(TuxGuitar.getInstance().getSongManager().getTrack(song, number).getName());
        }
        trackCombo.select(TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber() - 1);
        final Button trackAllCheck = new Button((Composite)trackGroup, 32);
        trackAllCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        trackAllCheck.setText(TuxGuitar.getProperty((String)"export.all-tracks"));
        trackAllCheck.setSelection(false);
        trackAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                trackLabel.setEnabled(!trackAllCheck.getSelection());
                trackCombo.setEnabled(!trackAllCheck.getSelection());
            }
        });
        Group options = new Group((Composite)dialog, 16);
        options.setLayout((Layout)new GridLayout());
        options.setLayoutData((Object)SVGExporterStylesDialog.getGroupData());
        options.setText(TuxGuitar.getProperty((String)"options"));
        final Button tablatureEnabled = new Button((Composite)options, 32);
        tablatureEnabled.setText(TuxGuitar.getProperty((String)"export.tablature-enabled"));
        tablatureEnabled.setSelection(true);
        final Button scoreEnabled = new Button((Composite)options, 32);
        scoreEnabled.setText(TuxGuitar.getProperty((String)"export.score-enabled"));
        scoreEnabled.setSelection(true);
        final Button chordNameEnabled = new Button((Composite)options, 32);
        chordNameEnabled.setText(TuxGuitar.getProperty((String)"export.chord-name-enabled"));
        chordNameEnabled.setSelection(true);
        final Button chordDiagramEnabled = new Button((Composite)options, 32);
        chordDiagramEnabled.setText(TuxGuitar.getProperty((String)"export.chord-diagram-enabled"));
        chordDiagramEnabled.setSelection(true);
        tablatureEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!tablatureEnabled.getSelection()) {
                    scoreEnabled.setSelection(true);
                }
            }
        });
        scoreEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (!scoreEnabled.getSelection()) {
                    tablatureEnabled.setSelection(true);
                }
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button buttonOK = new Button(buttons, 8);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setLayoutData((Object)SVGExporterStylesDialog.getButtonData());
        buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int track = !trackAllCheck.getSelection() ? trackCombo.getSelectionIndex() + 1 : -1;
                boolean showScore = scoreEnabled.getSelection();
                boolean showTablature = tablatureEnabled.getSelection();
                boolean showChordName = chordNameEnabled.getSelection();
                boolean showChordDiagram = chordDiagramEnabled.getSelection();
                SVGExporterStylesDialog.this.configure(track, showScore, showTablature, showChordName, showChordDiagram);
                dialog.dispose();
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.setLayoutData((Object)SVGExporterStylesDialog.getButtonData());
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOK);
        DialogUtils.openDialog((Shell)dialog, (int)11);
    }

    public void configure(int track, boolean showScore, boolean showTablature, boolean showChordName, boolean showChordDiagram) {
        this.configureWithDefaults();
        this.setTrack(track);
        this.setFlags(1);
        if (showScore) {
            this.setFlags(this.getFlags() | 4);
        }
        if (showTablature) {
            this.setFlags(this.getFlags() | 8);
        }
        if (showChordName) {
            this.setFlags(this.getFlags() | 0x10);
        }
        if (showChordDiagram) {
            this.setFlags(this.getFlags() | 0x20);
        }
        if (track < 0) {
            this.setFlags(this.getFlags() | 2);
        }
        this.setConfigured(true);
    }

    private static GridData getButtonData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        return data;
    }

    private static GridData getGroupData() {
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 300;
        return data;
    }
}

