/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGColorModel;
import org.herac.tuxguitar.graphics.TGFont;
import org.herac.tuxguitar.graphics.TGFontModel;
import org.herac.tuxguitar.graphics.TGResource;
import org.herac.tuxguitar.graphics.TGResourceFactory;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;

public class TGResources {
    private List<TGResource> resources;
    private TGLayout layout;
    private TGFont defaultFont;
    private TGFont noteFont;
    private TGFont timeSignatureFont;
    private TGFont lyricFont;
    private TGFont textFont;
    private TGFont markerFont;
    private TGFont graceFont;
    private TGFont chordFont;
    private TGFont chordFretFont;
    private TGColor backgroundColor;
    private TGColor lineColor;
    private TGColor scoreNoteColor;
    private TGColor tabNoteColor;
    private TGColor playNoteColor;
    private TGColor colorWhite;
    private TGColor colorBlack;
    private TGColor colorRed;
    private TGColor loopSMarkerColor;
    private TGColor loopEMarkerColor;

    public TGResources(TGLayout layout) {
        this.layout = layout;
        this.resources = new ArrayList<TGResource>();
    }

    public void load(TGLayoutStyles styles) {
        this.dispose();
        this.initFonts(styles);
        this.initColors(styles);
    }

    public TGLayout getLayout() {
        return this.layout;
    }

    public TGFont getDefaultFont() {
        return this.defaultFont;
    }

    public TGFont getNoteFont() {
        return this.noteFont;
    }

    public TGFont getTimeSignatureFont() {
        return this.timeSignatureFont;
    }

    public TGFont getLyricFont() {
        return this.lyricFont;
    }

    public TGFont getTextFont() {
        return this.textFont;
    }

    public TGFont getMarkerFont() {
        return this.markerFont;
    }

    public TGFont getChordFont() {
        return this.chordFont;
    }

    public TGFont getChordFretFont() {
        return this.chordFretFont;
    }

    public TGFont getGraceFont() {
        return this.graceFont;
    }

    public TGColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public TGColor getLineColor() {
        return this.lineColor;
    }

    public TGColor getPlayNoteColor() {
        return this.playNoteColor;
    }

    public TGColor getScoreNoteColor() {
        return this.scoreNoteColor;
    }

    public TGColor getTabNoteColor() {
        return this.tabNoteColor;
    }

    public TGColor getColorWhite() {
        return this.colorWhite;
    }

    public TGColor getColorBlack() {
        return this.colorBlack;
    }

    public TGColor getColorRed() {
        return this.colorRed;
    }

    public TGColor getLoopSMarkerColor() {
        return this.loopSMarkerColor;
    }

    public TGColor getLoopEMarkerColor() {
        return this.loopEMarkerColor;
    }

    private void initFonts(TGLayoutStyles style) {
        float scale = this.layout.getFontScale();
        this.defaultFont = this.getFont(style.getDefaultFont(), scale);
        this.noteFont = this.getFont(style.getNoteFont(), scale);
        this.timeSignatureFont = this.getFont(style.getTimeSignatureFont(), scale);
        this.lyricFont = this.getFont(style.getLyricFont(), scale);
        this.textFont = this.getFont(style.getTextFont(), scale);
        this.markerFont = this.getFont(style.getMarkerFont(), scale);
        this.graceFont = this.getFont(style.getGraceFont(), scale);
        this.chordFont = this.getFont(style.getChordFont(), scale);
        this.chordFretFont = this.getFont(style.getChordFretFont(), scale);
    }

    private void initColors(TGLayoutStyles style) {
        this.backgroundColor = this.getColor(style.getBackgroundColor());
        this.lineColor = this.getColor(style.getLineColor());
        this.scoreNoteColor = this.getColor(style.getScoreNoteColor());
        this.tabNoteColor = this.getColor(style.getTabNoteColor());
        this.playNoteColor = this.getColor(style.getPlayNoteColor());
        this.loopSMarkerColor = this.getColor(style.getLoopSMarkerColor());
        this.loopEMarkerColor = this.getColor(style.getLoopEMarkerColor());
        this.colorWhite = this.getColor(new TGColorModel(255, 255, 255));
        this.colorBlack = this.getColor(new TGColorModel(0, 0, 0));
        this.colorRed = this.getColor(new TGColorModel(255, 0, 0));
    }

    private TGFont getFont(TGFontModel model, float scale) {
        TGResourceFactory factory = this.getLayout().getComponent().getResourceFactory();
        TGFontModel fm = new TGFontModel();
        if (model != null) {
            float height = model.getHeight() * scale;
            fm.setHeight(height > 1.0f ? Math.round(height) : 1);
            fm.setName(model.getName());
            fm.setBold(model.isBold());
            fm.setItalic(model.isItalic());
        }
        return (TGFont)this.addResource(factory.createFont(fm));
    }

    private TGColor getColor(TGColorModel model) {
        TGResourceFactory factory = this.getLayout().getComponent().getResourceFactory();
        TGColorModel cm = model != null ? model : new TGColorModel();
        return (TGColor)this.addResource(factory.createColor(cm));
    }

    private TGResource addResource(TGResource resource) {
        this.resources.add(resource);
        return resource;
    }

    public void dispose() {
        for (TGResource resource : this.resources) {
            resource.dispose();
        }
        this.resources.clear();
    }
}

