/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.graphics.TGColor;
import org.herac.tuxguitar.graphics.TGPainter;
import org.herac.tuxguitar.graphics.TGRectangle;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGChordImpl;
import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.TGLyricImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureHeaderImpl;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.graphics.control.TGResources;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.graphics.control.TGTrackSpacing;
import org.herac.tuxguitar.graphics.control.TGVoiceImpl;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;

public abstract class TGLayout {
    public static final int MODE_VERTICAL = 1;
    public static final int MODE_HORIZONTAL = 2;
    public static final int DEFAULT_MODE = 2;
    public static final int DISPLAY_COMPACT = 1;
    public static final int DISPLAY_MULTITRACK = 2;
    public static final int DISPLAY_SCORE = 4;
    public static final int DISPLAY_TABLATURE = 8;
    public static final int DISPLAY_CHORD_NAME = 16;
    public static final int DISPLAY_CHORD_DIAGRAM = 32;
    public static final int DISPLAY_MODE_BLACK_WHITE = 64;
    private int style;
    private float scale;
    private float fontScale;
    private float width;
    private float height;
    private float minBufferSeparator;
    private float minTopSpacing;
    private float minScoreTabSpacing;
    private float stringSpacing;
    private float scoreLineSpacing;
    private float trackSpacing;
    private float firstTrackSpacing;
    private float firstMeasureSpacing;
    private float chordFretIndexSpacing;
    private float chordStringSpacing;
    private float chordFretSpacing;
    private float chordNoteSize;
    private float chordLineWidth;
    private float repeatEndingSpacing;
    private float effectSpacing;
    private float divisionTypeSpacing;
    private float textSpacing;
    private float markerSpacing;
    private float loopMarkerSpacing;
    private boolean bufferEnabled;
    private boolean playModeEnabled;
    private List<TrackPosition> trackPositions;
    private TGController controller;
    private TGResources resources;
    private TGLayoutStyles styles;

    public TGLayout(TGController controller, int style) {
        this.controller = controller;
        this.trackPositions = new ArrayList<TrackPosition>();
        this.playModeEnabled = false;
        this.resources = new TGResources(this);
        this.styles = new TGLayoutStyles();
        this.style = style;
        if ((this.style & 8) == 0 && (this.style & 4) == 0) {
            this.style |= 8;
        }
    }

    public void loadStyles() {
        this.loadStyles(1.0f);
    }

    public void loadStyles(float scale) {
        this.loadStyles(scale, scale);
    }

    public void loadStyles(float scale, float fontScale) {
        this.setScale(scale);
        this.setFontScale(fontScale);
        this.getComponent().configureStyles(this.styles);
        this.setBufferEnabled(this.styles.isBufferEnabled());
        this.setStringSpacing(this.styles.getStringSpacing() * this.getScale());
        this.setScoreLineSpacing(this.styles.getScoreLineSpacing() * this.getScale());
        this.setFirstMeasureSpacing(this.styles.getFirstMeasureSpacing() * this.getScale());
        this.setMinBufferSeparator(this.styles.getMinBufferSeparator() * this.getScale());
        this.setMinTopSpacing(this.styles.getMinTopSpacing() * this.getScale());
        this.setMinScoreTabSpacing(this.styles.getMinScoreTabSpacing() * this.getScale());
        this.setFirstTrackSpacing(this.styles.getFirstTrackSpacing() * this.getScale());
        this.setTrackSpacing(this.styles.getTrackSpacing() * this.getScale());
        this.setChordFretIndexSpacing(this.styles.getChordFretIndexSpacing() * this.getScale());
        this.setChordStringSpacing(this.styles.getChordStringSpacing() * this.getScale());
        this.setChordFretSpacing(this.styles.getChordFretSpacing() * this.getScale());
        this.setChordNoteSize(this.styles.getChordNoteSize() * this.getScale());
        this.setChordLineWidth(this.styles.getChordLineWidth() * this.getScale());
        this.setRepeatEndingSpacing(this.styles.getRepeatEndingSpacing() * this.getScale());
        this.setTextSpacing(this.styles.getTextSpacing() * this.getScale());
        this.setMarkerSpacing(this.styles.getMarkerSpacing() * this.getScale());
        this.setLoopMarkerSpacing(this.styles.getLoopMarkerSpacing() * this.getScale());
        this.setDivisionTypeSpacing(this.styles.getDivisionTypeSpacing() * this.getScale());
        this.setEffectSpacing(this.styles.getEffectSpacing() * this.getScale());
        this.getResources().load(this.styles);
    }

    public abstract void paintSong(TGPainter var1, TGRectangle var2, float var3, float var4);

    public abstract int getMode();

    public void paint(TGPainter painter, TGRectangle clientArea, float fromX, float fromY) {
        this.playModeEnabled = false;
        this.paintSong(painter, clientArea, fromX, fromY);
    }

    public void paintMeasure(TGMeasureImpl measure, TGPainter painter, float spacing) {
        measure.setSpacing(spacing);
        measure.paintMeasure(this, painter);
    }

    public void updateSong() {
        this.getResourceBuffer().clearRegistry();
        this.updateMeasures();
    }

    public void updateMeasures() {
        int measureCount = this.getSong().countMeasureHeaders();
        for (int measureIdx = 0; measureIdx < measureCount; ++measureIdx) {
            this.updateMeasureIndex(measureIdx);
        }
    }

    private void updateMeasureIndex(int index) {
        if (index >= 0 && index < this.getSong().countMeasureHeaders()) {
            TGMeasureImpl measure;
            TGTrackImpl track;
            int trackIdx;
            ((TGMeasureHeaderImpl)this.getSong().getMeasureHeader(index)).update(this, index);
            int trackCount = this.getSong().countTracks();
            for (trackIdx = 0; trackIdx < trackCount; ++trackIdx) {
                track = (TGTrackImpl)this.getSong().getTrack(trackIdx);
                measure = (TGMeasureImpl)track.getMeasure(index);
                measure.create(this);
            }
            for (trackIdx = 0; trackIdx < trackCount; ++trackIdx) {
                track = (TGTrackImpl)this.getSong().getTrack(trackIdx);
                measure = (TGMeasureImpl)track.getMeasure(index);
                track.update(this);
                measure.update(this);
            }
        }
    }

    public void updateMeasureNumber(int number) {
        int index;
        TGMeasureHeader header = this.getSongManager().getMeasureHeader(this.getSong(), number);
        if (header != null && (index = this.getSongManager().getMeasureHeaderIndex(this.getSong(), header)) >= 0) {
            this.updateMeasureIndex(index);
        }
    }

    public void paintLines(TGTrackImpl track, TGTrackSpacing ts, TGPainter painter, float x, float y, float width) {
        if (width > 0.0f) {
            this.setLineStyle(painter);
            float tempX = x < 0.0f ? 0.0f : x;
            float tempY = y;
            if ((this.style & 4) != 0) {
                float posY = tempY + ts.getPosition(8);
                painter.initPath();
                painter.setAntialias(false);
                for (int i = 1; i <= 5; ++i) {
                    painter.moveTo(tempX, posY);
                    painter.lineTo(tempX + width, posY);
                    posY += this.getScoreLineSpacing();
                }
                painter.closePath();
            }
            if ((this.style & 8) != 0) {
                tempY += ts.getPosition(13);
                painter.initPath();
                painter.setAntialias(false);
                for (int i = 0; i < track.stringCount(); ++i) {
                    painter.moveTo(tempX, tempY);
                    painter.lineTo(tempX + width, tempY);
                    tempY += this.getStringSpacing();
                }
                painter.closePath();
            }
        }
    }

    public void paintPlayMode(TGPainter painter, TGMeasureImpl measure, TGBeatImpl beat, boolean paintMeasure) {
        this.playModeEnabled = true;
        if (paintMeasure) {
            measure.paintMeasure(this, painter);
        }
        if (beat != null) {
            beat.paint(this, painter, measure.getPosX() + measure.getHeaderImpl().getLeftSpacing(this), measure.getPosY());
        }
        ((TGLyricImpl)measure.getTrackImpl().getLyrics()).paintCurrentNoteBeats(painter, this, measure, measure.getPosX(), measure.getPosY());
        this.playModeEnabled = false;
    }

    protected float checkScale() {
        float v1 = (this.style & 4) != 0 ? this.getScoreLineSpacing() * 1.25f : 0.0f;
        float v2 = (this.style & 8) != 0 ? this.getStringSpacing() : 0.0f;
        float scale = Math.max(v1, v2) / 10.0f;
        return scale;
    }

    protected void checkDefaultSpacing(TGTrackSpacing ts) {
        float checkPosition = -1.0f;
        float minBufferSeparator = this.getMinBufferSeparator();
        if ((this.style & 4) != 0) {
            float bufferSeparator = ts.getPosition(7) - ts.getPosition(4);
            if (bufferSeparator < minBufferSeparator) {
                ts.setSize(4, minBufferSeparator - bufferSeparator);
            }
            checkPosition = ts.getPosition(8);
        } else if ((this.style & 8) != 0) {
            float bufferSeparator = ts.getPosition(13) - ts.getPosition(4);
            if (bufferSeparator < minBufferSeparator) {
                ts.setSize(4, minBufferSeparator - bufferSeparator);
            }
            checkPosition = ts.getPosition(13);
        }
        if (checkPosition >= 0.0f && checkPosition < this.getMinTopSpacing()) {
            ts.setSize(0, this.getMinTopSpacing() - checkPosition);
        }
    }

    public float getSpacingForQuarter(TGDuration duration) {
        return 960.0f / (float)duration.getTime() * this.getMinSpacing(duration);
    }

    protected float getMinSpacing(TGDuration duration) {
        float scale = this.getScale();
        switch (duration.getValue()) {
            case 1: {
                return 50.0f * scale;
            }
            case 2: {
                return 30.0f * scale;
            }
            case 4: {
                return 25.0f * scale;
            }
            case 8: {
                return 20.0f * scale;
            }
        }
        return 18.0f * scale;
    }

    public float getMinBeatWidth() {
        return 17.0f * this.getScale();
    }

    public float getVoiceWidth(TGVoiceImpl voice) {
        float scale = this.getScale();
        TGDuration duration = voice.getDuration();
        if (duration != null) {
            switch (duration.getValue()) {
                case 1: {
                    return 30.0f * scale;
                }
                case 2: {
                    return 25.0f * scale;
                }
                case 4: {
                    return 21.0f * scale;
                }
                case 8: {
                    return 20.0f * scale;
                }
                case 16: {
                    return 19.0f * scale;
                }
                case 32: {
                    return 18.0f * scale;
                }
            }
            return this.getMinBeatWidth();
        }
        return 20.0f * scale;
    }

    public float getScoreNoteWidth() {
        return this.getScoreLineSpacing() * 1.085f;
    }

    public boolean isPlayModeEnabled() {
        return this.playModeEnabled;
    }

    public void setMeasureNumberStyle(TGPainter painter) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getDarkColor(this.getResources().getColorRed()));
    }

    public void setDivisionsStyle(TGPainter painter, boolean fill) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setBackground(fill ? this.getResources().getColorBlack() : this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getResources().getColorBlack());
    }

    public void setTempoStyle(TGPainter painter, boolean fontStyle) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setForeground(this.getResources().getColorBlack());
        painter.setBackground(fontStyle ? this.getLightColor(this.getResources().getBackgroundColor()) : this.getResources().getColorBlack());
    }

    public void setTripletFeelStyle(TGPainter painter, boolean fontStyle) {
        painter.setFont(this.getResources().getDefaultFont());
        painter.setForeground(this.getResources().getColorBlack());
        painter.setBackground(fontStyle ? this.getLightColor(this.getResources().getBackgroundColor()) : this.getResources().getColorBlack());
    }

    public void setMeasurePlayingStyle(TGPainter painter) {
        painter.setBackground(this.getResources().getBackgroundColor());
        painter.setForeground(this.getResources().getColorBlack());
    }

    public void setLyricStyle(TGPainter painter, boolean playMode) {
        painter.setFont(this.getResources().getLyricFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getResources().getColorBlack());
    }

    public void setMarkerStyle(TGPainter painter, TGColor color) {
        painter.setFont(this.getResources().getMarkerFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getDarkColor(color));
    }

    public void setTextStyle(TGPainter painter) {
        painter.setFont(this.getResources().getTextFont());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setForeground(this.getResources().getColorBlack());
    }

    public void setTimeSignatureStyle(TGPainter painter) {
        painter.setFont(this.getResources().getTimeSignatureFont());
        painter.setForeground(this.getResources().getColorBlack());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
    }

    public void setKeySignatureStyle(TGPainter painter) {
        painter.setBackground(this.getResources().getColorBlack());
    }

    public void setClefStyle(TGPainter painter) {
        painter.setBackground(this.getResources().getColorBlack());
    }

    public void setLineStyle(TGPainter painter) {
        painter.setLineWidth(0.0f);
        painter.setForeground(this.getDarkColor(this.getResources().getLineColor()));
    }

    public void setScoreSilenceStyle(TGPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setTabSilenceStyle(TGPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setScoreNoteStyle(TGPainter painter, boolean playing) {
        painter.setForeground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(playing ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setScoreNoteFooterStyle(TGPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setScoreEffectStyle(TGPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getScoreNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getScoreNoteColor()));
    }

    public void setTabNoteStyle(TGPainter painter, boolean playMode) {
        painter.setForeground(playMode ? this.getResources().getPlayNoteColor() : this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getNoteFont());
    }

    public void setTabNoteFooterStyle(TGPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setTabEffectStyle(TGPainter painter) {
        painter.setForeground(this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getDarkColor(this.getResources().getTabNoteColor()));
    }

    public void setTabGraceStyle(TGPainter painter) {
        painter.setFont(this.getResources().getGraceFont());
        painter.setForeground(this.getDarkColor(this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
    }

    public void setPlayNoteColor(TGPainter painter) {
        painter.setForeground(this.getResources().getPlayNoteColor());
        painter.setBackground(this.getResources().getPlayNoteColor());
    }

    public void setOfflineEffectStyle(TGPainter painter) {
        painter.setForeground(this.getDarkColor((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor()));
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getDefaultFont());
    }

    public void setDotStyle(TGPainter painter) {
        painter.setForeground((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor());
        painter.setBackground((this.getStyle() & 4) != 0 ? this.getResources().getScoreNoteColor() : this.getResources().getTabNoteColor());
    }

    public void setDivisionTypeStyle(TGPainter painter) {
        painter.setForeground(this.getResources().getColorBlack());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getDefaultFont());
    }

    public void setRepeatEndingStyle(TGPainter painter) {
        painter.setForeground(this.getResources().getColorBlack());
        painter.setBackground(this.getLightColor(this.getResources().getBackgroundColor()));
        painter.setFont(this.getResources().getDefaultFont());
    }

    public void setChordStyle(TGChordImpl chord) {
        chord.setFont(this.getResources().getChordFont());
        chord.setForegroundColor(this.getResources().getColorBlack());
        chord.setBackgroundColor(this.getResources().getBackgroundColor());
        chord.setColor(this.getDarkColor(this.getResources().getLineColor()));
        chord.setNoteColor(this.getDarkColor(this.getResources().getTabNoteColor()));
        chord.setTonicColor(this.getDarkColor(this.getResources().getTabNoteColor()));
        chord.setStyle(this.style);
        chord.setFretSpacing(this.getChordFretSpacing());
        chord.setStringSpacing(this.getChordStringSpacing());
        chord.setNoteSize(this.getChordNoteSize());
        chord.setLineWidth(this.getChordLineWidth());
        chord.setFirstFretSpacing(this.getChordFretIndexSpacing());
        chord.setFirstFretFont(this.getResources().getChordFretFont());
    }

    public void setLoopSMarkerStyle(TGPainter painter) {
        painter.setBackground(this.getResources().getLoopSMarkerColor());
    }

    public void setLoopEMarkerStyle(TGPainter painter) {
        painter.setBackground(this.getResources().getLoopEMarkerColor());
    }

    public TGColor getDarkColor(TGColor color) {
        return (this.getStyle() & 0x40) != 0 ? this.getResources().getColorBlack() : color;
    }

    public TGColor getLightColor(TGColor color) {
        return (this.getStyle() & 0x40) != 0 ? this.getResources().getColorWhite() : color;
    }

    public TGRectangle getNoteOrientation(TGPainter painter, float x, float y, TGNote note) {
        String noteAsString = null;
        if (note.isTiedNote()) {
            noteAsString = "L";
            noteAsString = note.getEffect().isGhostNote() ? "(" + noteAsString + ")" : noteAsString;
        } else if (note.getEffect().isDeadNote()) {
            noteAsString = "X";
            noteAsString = note.getEffect().isGhostNote() ? "(" + noteAsString + ")" : noteAsString;
        } else {
            noteAsString = Integer.toString(note.getValue());
            noteAsString = note.getEffect().isGhostNote() ? "(" + noteAsString + ")" : noteAsString;
        }
        return this.getOrientation(painter, x, y, noteAsString);
    }

    public TGRectangle getOrientation(TGPainter painter, float x, float y, String s) {
        float fmWidth = painter.getFMWidth(s);
        float fmTopLine = painter.getFMTopLine();
        float fmMiddleLine = painter.getFMMiddleLine();
        float fmBaseLine = painter.getFMBaseLine();
        return new TGRectangle(x - fmWidth / 2.0f, y + fmMiddleLine, fmWidth, fmBaseLine - fmTopLine);
    }

    public TGSongManager getSongManager() {
        return this.getComponent().getSongManager();
    }

    public TGSong getSong() {
        return this.getComponent().getSong();
    }

    public TGResourceBuffer getResourceBuffer() {
        return this.getComponent().getResourceBuffer();
    }

    public TGController getComponent() {
        return this.controller;
    }

    public TGResources getResources() {
        return this.resources;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
    }

    public boolean isBufferEnabled() {
        return this.bufferEnabled;
    }

    public void setBufferEnabled(boolean bufferEnabled) {
        this.bufferEnabled = bufferEnabled;
    }

    public float getFirstMeasureSpacing() {
        return this.firstMeasureSpacing;
    }

    public void setFirstMeasureSpacing(float firstMeasureSpacing) {
        this.firstMeasureSpacing = firstMeasureSpacing;
    }

    public float getMinBufferSeparator() {
        return this.minBufferSeparator;
    }

    public void setMinBufferSeparator(float minBufferSeparator) {
        this.minBufferSeparator = minBufferSeparator;
    }

    public float getMinTopSpacing() {
        return this.minTopSpacing;
    }

    public void setMinTopSpacing(float minTopSpacing) {
        this.minTopSpacing = minTopSpacing;
    }

    public float getMinScoreTabSpacing() {
        return this.minScoreTabSpacing;
    }

    public void setMinScoreTabSpacing(float minScoreTabSpacing) {
        this.minScoreTabSpacing = minScoreTabSpacing;
    }

    public float getScoreLineSpacing() {
        return this.scoreLineSpacing;
    }

    public void setScoreLineSpacing(float scoreLineSpacing) {
        this.scoreLineSpacing = scoreLineSpacing;
    }

    public float getFirstTrackSpacing() {
        return this.firstTrackSpacing;
    }

    public void setFirstTrackSpacing(float firstTrackSpacing) {
        this.firstTrackSpacing = firstTrackSpacing;
    }

    public float getTrackSpacing() {
        return this.trackSpacing;
    }

    public void setTrackSpacing(float trackSpacing) {
        this.trackSpacing = trackSpacing;
    }

    public float getStringSpacing() {
        return this.stringSpacing;
    }

    public void setStringSpacing(float stringSpacing) {
        this.stringSpacing = stringSpacing;
    }

    public float getChordFretIndexSpacing() {
        return this.chordFretIndexSpacing;
    }

    public void setChordFretIndexSpacing(float chordFretIndexSpacing) {
        this.chordFretIndexSpacing = chordFretIndexSpacing;
    }

    public float getChordStringSpacing() {
        return this.chordStringSpacing;
    }

    public void setChordStringSpacing(float chordStringSpacing) {
        this.chordStringSpacing = chordStringSpacing;
    }

    public float getChordFretSpacing() {
        return this.chordFretSpacing;
    }

    public void setChordFretSpacing(float chordFretSpacing) {
        this.chordFretSpacing = chordFretSpacing;
    }

    public float getChordNoteSize() {
        return this.chordNoteSize;
    }

    public void setChordNoteSize(float chordNoteSize) {
        this.chordNoteSize = chordNoteSize;
    }

    public float getChordLineWidth() {
        return this.chordLineWidth;
    }

    public void setChordLineWidth(float chordLineWidth) {
        this.chordLineWidth = chordLineWidth;
    }

    public float getRepeatEndingSpacing() {
        return this.repeatEndingSpacing;
    }

    public void setRepeatEndingSpacing(float repeatEndingSpacing) {
        this.repeatEndingSpacing = repeatEndingSpacing;
    }

    public float getDivisionTypeSpacing() {
        return this.divisionTypeSpacing;
    }

    public void setDivisionTypeSpacing(float divisionTypeSpacing) {
        this.divisionTypeSpacing = divisionTypeSpacing;
    }

    public float getTextSpacing() {
        return this.textSpacing;
    }

    public void setTextSpacing(float textSpacing) {
        this.textSpacing = textSpacing;
    }

    public float getMarkerSpacing() {
        return this.markerSpacing;
    }

    public void setMarkerSpacing(float markerSpacing) {
        this.markerSpacing = markerSpacing;
    }

    public float getLoopMarkerSpacing() {
        return this.loopMarkerSpacing;
    }

    public void setLoopMarkerSpacing(float loopMarkerSpacing) {
        this.loopMarkerSpacing = loopMarkerSpacing;
    }

    public float getEffectSpacing() {
        return this.effectSpacing;
    }

    public void setEffectSpacing(float effectSpacing) {
        this.effectSpacing = effectSpacing;
    }

    public float getDefaultChordSpacing() {
        float spacing = 0.0f;
        if ((this.style & 0x20) != 0) {
            spacing += 6.0f * this.getChordFretSpacing() + this.getChordFretSpacing();
        }
        if ((this.style & 0x10) != 0) {
            spacing += (float)Math.round(15.0f * this.getScale());
        }
        return spacing;
    }

    public boolean isFirstMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == 1;
    }

    public boolean isFirstMeasure(TGMeasure measure) {
        return this.isFirstMeasure(measure.getHeader());
    }

    public boolean isLastMeasure(TGMeasureHeader mh) {
        return mh.getNumber() == this.getSong().countMeasureHeaders();
    }

    public boolean isLastMeasure(TGMeasure measure) {
        return this.isLastMeasure(measure.getHeader());
    }

    public boolean hasLoopMarker(TGMeasureHeader mh) {
        return this.getComponent().isLoopSHeader(mh) || this.getComponent().isLoopEHeader(mh);
    }

    public boolean hasLoopMarker(TGMeasure measure) {
        return this.hasLoopMarker(measure.getHeader());
    }

    protected void clearTrackPositions() {
        this.trackPositions.clear();
    }

    protected void addTrackPosition(int track, float posY, float height) {
        this.trackPositions.add(new TrackPosition(track, posY, height));
    }

    public int getTrackNumberAt(float y) {
        TrackPosition trackPos = this.getTrackPositionAt(y);
        return trackPos != null ? trackPos.getTrack() : -1;
    }

    public TrackPosition getTrackPositionAt(float y) {
        TrackPosition trackPos = null;
        float minorDistance = 0.0f;
        for (TrackPosition pos : this.trackPositions) {
            float distanceY = Math.min(Math.abs(y - pos.getPosY()), Math.abs(y - (pos.getPosY() + pos.getHeight() - 10.0f)));
            if (trackPos != null && !(distanceY < minorDistance)) continue;
            trackPos = pos;
            minorDistance = distanceY;
        }
        return trackPos;
    }

    public void disposeLayout() {
        this.getResources().dispose();
    }

    public class TrackPosition {
        private int track;
        private float posY;
        private float height;

        public TrackPosition(int track, float posY, float height) {
            this.track = track;
            this.posY = posY;
            this.height = height;
        }

        public float getPosY() {
            return this.posY;
        }

        public float getHeight() {
            return this.height;
        }

        public int getTrack() {
            return this.track;
        }
    }
}

