/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableCloneTrack
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;

    private TGUndoableCloneTrack(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.cloneTrack(this.getSong(), this.getSongManager().getTrack(this.getSong(), this.trackNumber));
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.removeTrack(this.getSong(), this.getSongManager().getLastTrack(this.getSong()));
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableCloneTrack startUndo(TGContext context, TGTrack track) {
        TGUndoableCloneTrack undoable = new TGUndoableCloneTrack(context);
        undoable.doAction = 1;
        undoable.trackNumber = track.getNumber();
        return undoable;
    }

    public TGUndoableCloneTrack endUndo() {
        return this;
    }
}

