/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.measure;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.measure.TGInsertMeasuresAction;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGSongSegmentHelper;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableRemoveMeasure
extends TGUndoableEditBase {
    private int doAction = 1;
    private TGSongSegment tracksMeasures;
    private int number;

    public TGUndoableRemoveMeasure(TGContext context, int number) {
        super(context);
        this.number = number;
        this.tracksMeasures = new TGSongSegmentHelper(this.getSongManager()).copyMeasures(this.getSong(), number, number);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.removeMeasure(this.getSong(), this.number);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.insertMeasures(this.getSong(), this.tracksMeasures.clone(this.getSongManager().getFactory()), this.number, 0, 0L);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public TGUndoableRemoveMeasure endUndo() {
        return this;
    }

    public void removeMeasure(TGSong song, Integer number) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.measure.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("measureNumber", number);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void insertMeasures(TGSong song, TGSongSegment segment, int fromNumber, int toTrack, long theMove) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.measure.insert");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGInsertMeasuresAction.ATTRIBUTE_SONG_SEGMENT, segment);
        tgActionProcessor.setAttribute("fromNumber", fromNumber);
        tgActionProcessor.setAttribute("toTrack", toTrack);
        tgActionProcessor.setAttribute("theMove", theMove);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

