/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.measure;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableAddMeasure
extends TGUndoableEditBase {
    private int doAction;
    private int number;

    private TGUndoableAddMeasure(TGContext context) {
        super(context);
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.addMeasure(this.getSong(), this.number);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.removeMeasure(this.getSong(), this.number);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableAddMeasure startUndo(TGContext context, int number) {
        TGUndoableAddMeasure undoable = new TGUndoableAddMeasure(context);
        undoable.doAction = 1;
        undoable.number = number;
        return undoable;
    }

    public TGUndoableAddMeasure endUndo() {
        return this;
    }

    public void addMeasure(TGSong song, Integer number) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.measure.add");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("measureNumber", number);
        this.processByPassUndoableAction(tgActionProcessor);
    }

    public void removeMeasure(TGSong song, Integer number) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.measure.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("measureNumber", number);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

