/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.channel;

import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableModifyChannel
extends TGUndoableEditBase {
    private int doAction;
    private int channelId;
    private TGChannel undoChannel;
    private TGChannel redoChannel;

    private TGUndoableModifyChannel(TGContext context, int channelId) {
        super(context);
        this.channelId = channelId;
    }

    public void redo() throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.updateChannel(this.getSong(), this.redoChannel);
        this.doAction = 1;
    }

    public void undo() throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.updateChannel(this.getSong(), this.undoChannel);
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableModifyChannel startUndo(TGContext context, int channelId) {
        TGUndoableModifyChannel undoable = new TGUndoableModifyChannel(context, channelId);
        undoable.doAction = 1;
        undoable.undoChannel = undoable.cloneChannel(undoable.getChannel());
        return undoable;
    }

    public TGUndoableModifyChannel endUndo() {
        this.redoChannel = this.cloneChannel(this.getChannel());
        return this;
    }

    private TGChannel cloneChannel(TGChannel channel) {
        return channel.clone(this.getSongManager().getFactory());
    }

    private TGChannel getChannel() {
        return this.getSongManager().getChannel(this.getSong(), this.channelId);
    }

    public void updateChannel(TGSong song, TGChannel channel) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.channel.update");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, channel);
        this.processByPassUndoableAction(tgActionProcessor);
    }
}

