/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSOpenGLPixelFormat;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    NSOpenGLContext context;
    NSOpenGLPixelFormat pixelFormat;
    static final int MAX_ATTRIBUTES = 32;
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";

    public GLCanvas(Composite composite, int n, GLData gLData) {
        super(composite, n);
        if (gLData == null) {
            SWT.error(4);
        }
        int[] nArray = new int[32];
        int n2 = 0;
        if (gLData.doubleBuffer) {
            nArray[n2++] = 5;
        }
        if (gLData.stereo) {
            nArray[n2++] = 6;
        }
        if (gLData.redSize + gLData.blueSize + gLData.greenSize > 0) {
            nArray[n2++] = 8;
            nArray[n2++] = gLData.redSize + gLData.greenSize + gLData.blueSize;
        }
        if (gLData.alphaSize > 0) {
            nArray[n2++] = 11;
            nArray[n2++] = gLData.alphaSize;
        }
        if (gLData.depthSize > 0) {
            nArray[n2++] = 12;
            nArray[n2++] = gLData.depthSize;
        }
        if (gLData.stencilSize > 0) {
            nArray[n2++] = 13;
            nArray[n2++] = gLData.stencilSize;
        }
        if (gLData.accumRedSize + gLData.accumBlueSize + gLData.accumGreenSize > 0) {
            nArray[n2++] = 14;
            nArray[n2++] = gLData.accumRedSize + gLData.accumGreenSize + gLData.accumBlueSize + gLData.accumAlphaSize;
        }
        if (gLData.sampleBuffers > 0) {
            nArray[n2++] = 55;
            nArray[n2++] = gLData.sampleBuffers;
        }
        if (gLData.samples > 0) {
            nArray[n2++] = 56;
            nArray[n2++] = gLData.samples;
        }
        nArray[n2++] = 0;
        this.pixelFormat = (NSOpenGLPixelFormat)new NSOpenGLPixelFormat().alloc();
        if (this.pixelFormat == null) {
            this.dispose();
            SWT.error(38);
        }
        this.pixelFormat.initWithAttributes(nArray);
        NSOpenGLContext nSOpenGLContext = gLData.shareContext != null ? gLData.shareContext.context : null;
        this.context = (NSOpenGLContext)new NSOpenGLContext().alloc();
        if (this.context == null) {
            this.dispose();
            SWT.error(38);
        }
        this.context = this.context.initWithFormat(this.pixelFormat, nSOpenGLContext);
        this.context.setValues(new int[]{-1}, 235);
        this.setData(GLCONTEXT_KEY, this.context);
        NSNotificationCenter.defaultCenter().addObserver(this.view, OS.sel_updateOpenGLContext_, OS.NSViewGlobalFrameDidChangeNotification, this.view);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        GLCanvas.this.setData(GLCanvas.GLCONTEXT_KEY, null);
                        NSNotificationCenter.defaultCenter().removeObserver(GLCanvas.this.view);
                        if (GLCanvas.this.context != null) {
                            GLCanvas.this.context.clearDrawable();
                            GLCanvas.this.context.release();
                        }
                        GLCanvas.this.context = null;
                        if (GLCanvas.this.pixelFormat != null) {
                            GLCanvas.this.pixelFormat.release();
                        }
                        GLCanvas.this.pixelFormat = null;
                    }
                }
            }
        };
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        int n;
        int n2;
        this.checkWidget();
        GLData gLData = new GLData();
        int[] nArray = new int[1];
        this.pixelFormat.getValues(nArray, 5, 0);
        gLData.doubleBuffer = nArray[0] != 0;
        this.pixelFormat.getValues(nArray, 6, 0);
        gLData.stereo = nArray[0] != 0;
        this.pixelFormat.getValues(nArray, 11, 0);
        gLData.alphaSize = nArray[0];
        this.pixelFormat.getValues(nArray, 8, 0);
        gLData.redSize = n2 = (nArray[0] - gLData.alphaSize) / 3;
        gLData.greenSize = n2;
        gLData.blueSize = n2;
        this.pixelFormat.getValues(nArray, 12, 0);
        gLData.depthSize = nArray[0];
        this.pixelFormat.getValues(nArray, 13, 0);
        gLData.stencilSize = nArray[0];
        this.pixelFormat.getValues(nArray, 14, 0);
        gLData.accumRedSize = n = nArray[0] / 4;
        gLData.accumGreenSize = n;
        gLData.accumBlueSize = n;
        gLData.accumAlphaSize = n;
        this.pixelFormat.getValues(nArray, 55, 0);
        gLData.sampleBuffers = nArray[0];
        this.pixelFormat.getValues(nArray, 56, 0);
        gLData.samples = nArray[0];
        return gLData;
    }

    public boolean isCurrent() {
        this.checkWidget();
        NSOpenGLContext nSOpenGLContext = NSOpenGLContext.currentContext();
        return nSOpenGLContext != null && nSOpenGLContext.id == this.context.id;
    }

    public void setCurrent() {
        this.checkWidget();
        this.context.makeCurrentContext();
    }

    public void swapBuffers() {
        this.checkWidget();
        this.context.flushBuffer();
    }
}

