/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.browser.ftp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.ftp.TGBrowserDataImpl;
import org.herac.tuxguitar.app.util.DialogUtils;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TGBrowserDataDialog {
    private TGContext context;
    private TGBrowserDataImpl data;

    public TGBrowserDataDialog(TGContext context) {
        this.context = context;
    }

    public TGBrowserDataImpl show(final Shell parent) {
        final Shell dialog = DialogUtils.newDialog((Shell)parent, (int)67680);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(TuxGuitar.getProperty((String)"FTP Location"));
        Composite composite = new Composite((Composite)dialog, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData textData = new GridData(4, 4, true, true);
        textData.minimumWidth = 300;
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(TuxGuitar.getProperty((String)"Name"));
        final Text nameText = new Text(composite, 2048);
        nameText.setLayoutData((Object)textData);
        Label hostLabel = new Label(composite, 0);
        hostLabel.setText(TuxGuitar.getProperty((String)"Host"));
        final Text hostText = new Text(composite, 2048);
        hostText.setLayoutData((Object)textData);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(TuxGuitar.getProperty((String)"Path"));
        final Text pathText = new Text(composite, 2048);
        pathText.setLayoutData((Object)textData);
        Label userLabel = new Label(composite, 0);
        userLabel.setText(TuxGuitar.getProperty((String)"Login name"));
        final Text userText = new Text(composite, 2048);
        userText.setLayoutData((Object)textData);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(TuxGuitar.getProperty((String)"Password"));
        final Text passwordText = new Text(composite, 0x400800);
        passwordText.setLayoutData((Object)textData);
        final Button hasProxy = new Button(composite, 32);
        hasProxy.setText("Connect via Proxy Server");
        Label dummyLabel = new Label(composite, 0);
        dummyLabel.setLayoutData((Object)textData);
        Label proxyHostLabel = new Label(composite, 0);
        proxyHostLabel.setText(TuxGuitar.getProperty((String)"Proxy Server Host"));
        final Text proxyHostText = new Text(composite, 2048);
        proxyHostText.setLayoutData((Object)textData);
        Label proxyPortLabel = new Label(composite, 0);
        proxyPortLabel.setText(TuxGuitar.getProperty((String)"Proxy Server Port"));
        final Text proxyPortText = new Text(composite, 2048);
        proxyPortText.setText("1080");
        proxyPortText.setLayoutData((Object)textData);
        Label proxyUserLabel = new Label(composite, 0);
        proxyUserLabel.setText(TuxGuitar.getProperty((String)"Proxy Server User"));
        final Text proxyUserText = new Text(composite, 2048);
        proxyUserText.setLayoutData((Object)textData);
        Label proxyPwdLabel = new Label(composite, 0);
        proxyPwdLabel.setText(TuxGuitar.getProperty((String)"Proxy Server Password"));
        final Text proxyPwdText = new Text(composite, 0x400800);
        proxyPwdText.setLayoutData((Object)textData);
        proxyHostText.setEnabled(false);
        proxyPortText.setEnabled(false);
        proxyUserText.setEnabled(false);
        proxyPwdText.setEnabled(false);
        hasProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                proxyHostText.setEnabled(hasProxy.getSelection());
                proxyPortText.setEnabled(hasProxy.getSelection());
                proxyUserText.setEnabled(hasProxy.getSelection());
                proxyPwdText.setEnabled(hasProxy.getSelection());
            }
        });
        Composite buttons = new Composite((Composite)dialog, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        Button buttonOk = new Button(buttons, 8);
        buttonOk.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOk.setLayoutData((Object)data);
        buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String name = nameText.getText();
                String host = hostText.getText();
                String path = pathText.getText();
                String user = userText.getText();
                String password = passwordText.getText();
                String proxyHost = proxyHostText.getText();
                String proxyPortStr = proxyPortText.getText();
                String proxyUser = proxyUserText.getText();
                String proxyPwd = proxyPwdText.getText();
                List<String> errors = TGBrowserDataDialog.this.validate(name, host, proxyHost, proxyPortStr, hasProxy.getSelection());
                if (!errors.isEmpty()) {
                    StringWriter buffer = new StringWriter();
                    PrintWriter writer = new PrintWriter(buffer);
                    Iterator<String> it = errors.iterator();
                    while (it.hasNext()) {
                        writer.println("*" + it.next());
                    }
                    TGMessageDialogUtil.errorMessage((TGContext)TGBrowserDataDialog.this.getContext(), (Shell)parent, (String)buffer.getBuffer().toString());
                } else {
                    int proxyPort = Integer.parseInt(proxyPortStr);
                    TGBrowserDataDialog.this.data = new TGBrowserDataImpl(name, host, path, user, password, proxyUser, proxyPwd, proxyHost, proxyPort);
                    dialog.dispose();
                }
            }
        });
        Button buttonCancel = new Button(buttons, 8);
        buttonCancel.setLayoutData((Object)data);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });
        dialog.setDefaultButton(buttonOk);
        DialogUtils.openDialog((Shell)dialog, (int)11);
        return this.data;
    }

    protected List<String> validate(String name, String host, String pHost, String pPort, boolean pEnabled) {
        ArrayList<String> errors = new ArrayList<String>();
        if (name == null || name.trim().length() == 0) {
            errors.add("Please enter the Name");
        } else {
            Iterator it = TGBrowserManager.getInstance((TGContext)this.getContext()).getCollections();
            while (it.hasNext()) {
                TGBrowserCollection collection = (TGBrowserCollection)it.next();
                if (!name.equals(collection.getData().getTitle())) continue;
                errors.add("A collection named \"" + name + "\" already exists");
                break;
            }
        }
        if (host == null || host.trim().length() == 0) {
            errors.add("Please enter the Host");
        }
        if (pEnabled) {
            if (pHost == null || pHost.trim().length() == 0) {
                errors.add("Please enter Proxy Host");
            }
            if (pPort == null || pPort.trim().length() == 0) {
                errors.add("Please enter Proxy Port");
            } else if (!this.isNumber(pPort)) {
                errors.add("Proxy Port should be a valid number");
            }
        }
        return errors;
    }

    private boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public TGContext getContext() {
        return this.context;
    }
}

